/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import forge.game.CardTraitBase;
import forge.game.ability.AbilityUtils;
import forge.game.ability.SpellAbilityEffect;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardCollectionView;
import forge.game.card.CardLists;
import forge.game.player.Player;
import forge.game.player.PlayerCollection;
import forge.game.spellability.SpellAbility;
import forge.game.zone.ZoneType;
import forge.util.Aggregates;
import forge.util.Lang;
import forge.util.Localizer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class MultiplePilesEffect
extends SpellAbilityEffect {
    @Override
    protected String getStackDescription(SpellAbility sa) {
        StringBuilder sb = new StringBuilder();
        String piles = sa.getParam("Piles");
        String valid = sa.getParamOrDefault("ValidCards", "");
        sb.append("Separate all ").append(valid).append(" cards ");
        sb.append(Lang.joinHomogenous(MultiplePilesEffect.getTargetPlayers(sa)));
        sb.append("controls into ").append(piles).append(" piles.");
        return sb.toString();
    }

    @Override
    public void resolve(SpellAbility sa) {
        Card source = sa.getHostCard();
        ZoneType zone = sa.hasParam("Zone") ? ZoneType.smartValueOf(sa.getParam("Zone")) : ZoneType.Battlefield;
        boolean randomChosen = sa.hasParam("RandomChosen");
        int piles = Integer.parseInt(sa.getParam("Piles"));
        HashMap record = Maps.newHashMap();
        String valid = sa.getParamOrDefault("ValidCards", "");
        PlayerCollection tgtPlayers = MultiplePilesEffect.getTargetPlayers(sa);
        int pSize = tgtPlayers.size();
        Player activator = sa.getActivatingPlayer();
        while (tgtPlayers.contains(activator) && !activator.equals(Iterables.getFirst(tgtPlayers, null))) {
            tgtPlayers.add(pSize - 1, (Player)tgtPlayers.remove(0));
        }
        for (Player player : tgtPlayers) {
            if (!player.isInGame()) continue;
            CardCollection pool = sa.hasParam("DefinedCards") ? AbilityUtils.getDefinedCards(source, sa.getParam("DefinedCards"), sa) : new CardCollection(player.getCardsIn(zone));
            pool = CardLists.getValidCards((Iterable<Card>)pool, valid, source.getController(), source, (CardTraitBase)sa);
            ArrayList<CardCollectionView> pileList = Lists.newArrayList();
            for (int i = 1; i < piles; ++i) {
                int size = pool.size();
                CardCollectionView pile = player.getController().chooseCardsForEffect(pool, sa, Localizer.getInstance().getMessage("lblChooseCardsInTargetPile", String.valueOf(i)), 0, size, false, null);
                pileList.add(pile);
                pool.removeAll(pile);
            }
            pileList.add(pool);
            player.getGame().getAction().notifyOfValue(sa, player, ((Object)pileList).toString(), player);
            record.put(player, pileList);
        }
        if (randomChosen) {
            for (Map.Entry entry : record.entrySet()) {
                CardCollectionView chosen = (CardCollectionView)Aggregates.random((Iterable)entry.getValue());
                source.addRemembered(chosen);
            }
            SpellAbility sub = sa.getAdditionalAbility("ChosenPile");
            if (sub != null) {
                AbilityUtils.resolve(sub);
            }
            source.clearRemembered();
        }
    }
}

