/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import forge.game.Game;
import forge.game.ability.AbilityKey;
import forge.game.ability.AbilityUtils;
import forge.game.ability.SpellAbilityEffect;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardZoneTable;
import forge.game.player.Player;
import forge.game.player.PlayerCollection;
import forge.game.spellability.SpellAbility;
import forge.game.zone.ZoneType;
import forge.util.Lang;
import forge.util.Localizer;
import forge.util.TextUtil;
import java.util.EnumMap;

public class MillEffect
extends SpellAbilityEffect {
    @Override
    public void resolve(SpellAbility sa) {
        ZoneType destination;
        int numCards;
        Card source = sa.getHostCard();
        Game game = source.getGame();
        int n = numCards = sa.hasParam("NumCards") ? AbilityUtils.calculateAmount(source, sa.getParam("NumCards"), sa) : 1;
        if (numCards <= 0) {
            return;
        }
        if (sa.hasParam("ForgetOtherRemembered")) {
            source.clearRemembered();
        }
        if ((destination = ZoneType.smartValueOf(sa.getParam("Destination"))) == null) {
            destination = ZoneType.Graveyard;
        }
        PlayerCollection millers = MillEffect.getTargetPlayers(sa);
        if (sa.hasParam("Optional")) {
            PlayerCollection toRemove = new PlayerCollection();
            for (Player p : millers) {
                String d = destination.equals((Object)ZoneType.Graveyard) ? "" : " (" + destination.getTranslatedName() + ")";
                String prompt = TextUtil.concatWithSpace(Localizer.getInstance().getMessage("lblDoYouWantToMill", Lang.nounWithNumeral(numCards, "card"), d));
                if (numCards <= p.getZone(ZoneType.Library).size() && p.getController().confirmAction(sa, null, prompt, null)) continue;
                toRemove.add(p);
            }
            millers.removeAll(toRemove);
        }
        EnumMap<AbilityKey, Object> moveParams = AbilityKey.newMap();
        CardZoneTable table = AbilityKey.addCardZoneTableParams(moveParams, sa);
        CardCollection milled = game.getAction().mill(millers, numCards, destination, sa, moveParams);
        if (sa.hasParam("RememberMilled")) {
            sa.getHostCard().addRemembered(milled);
        }
        if (sa.hasParam("Imprint")) {
            sa.getHostCard().addImprintedCards(milled);
        }
        table.triggerChangesZoneAll(game, sa);
    }

    @Override
    protected String getStackDescription(SpellAbility sa) {
        StringBuilder sb = new StringBuilder();
        int numCards = sa.hasParam("NumCards") ? AbilityUtils.calculateAmount(sa.getHostCard(), sa.getParam("NumCards"), sa) : 1;
        boolean optional = sa.hasParam("Optional");
        boolean eachP = sa.hasParam("Defined") && sa.getParam("Defined").equals("Player");
        String each = "Each player";
        PlayerCollection tgtPs = MillEffect.getTargetPlayers(sa);
        if (sa.hasParam("IfDesc")) {
            String ifD = sa.getParam("IfDesc");
            if (ifD.equals("True")) {
                String ifDesc = sa.getDescription();
                if (ifDesc.contains(",")) {
                    sb.append(ifDesc, 0, ifDesc.indexOf(",") + 1);
                } else {
                    sb.append("[MillEffect IfDesc parsing error]");
                }
            } else {
                sb.append(ifD);
            }
            sb.append(" ");
            each = each.toLowerCase();
        }
        sb.append(eachP ? each : Lang.joinHomogenous(tgtPs));
        sb.append(" ");
        ZoneType dest = ZoneType.smartValueOf(sa.getParam("Destination"));
        sb.append(optional ? "may " : "");
        if (dest == null || dest.equals((Object)ZoneType.Graveyard)) {
            sb.append("mill");
        } else if (dest.equals((Object)ZoneType.Ante)) {
            sb.append("ante");
        }
        sb.append((optional || tgtPs.size() > 1) && !eachP ? " " : "s ");
        sb.append(Lang.nounWithNumeralExceptOne(numCards, "card")).append(".");
        return sb.toString();
    }
}

