/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import com.google.common.collect.Maps;
import forge.game.ability.AbilityKey;
import forge.game.ability.AbilityUtils;
import forge.game.ability.SpellAbilityEffect;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.game.trigger.TriggerType;
import forge.util.Lang;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class LifeLoseEffect
extends SpellAbilityEffect {
    @Override
    protected String getStackDescription(SpellAbility sa) {
        StringBuilder sb = new StringBuilder();
        String amountStr = sa.getParam("LifeAmount");
        int amount = AbilityUtils.calculateAmount(sa.getHostCard(), amountStr, sa);
        String spellDesc = sa.getParam("SpellDescription");
        int affected = LifeLoseEffect.getTargetPlayers(sa).size();
        sb.append(Lang.joinHomogenous(LifeLoseEffect.getTargetPlayers(sa)));
        sb.append(affected > 1 ? " each lose " : " loses ");
        if (!StringUtils.isNumeric(amountStr) && spellDesc != null && spellDesc.contains("life equal to")) {
            sb.append(spellDesc.substring(spellDesc.indexOf("life equal to")));
        } else {
            sb.append(amount).append(" life.");
        }
        return sb.toString();
    }

    @Override
    public void resolve(SpellAbility sa) {
        int lifeLost = 0;
        int lifeAmount = AbilityUtils.calculateAmount(sa.getHostCard(), sa.getParam("LifeAmount"), sa);
        HashMap<Player, Integer> lossMap = Maps.newHashMap();
        for (Player p : LifeLoseEffect.getTargetPlayers(sa)) {
            if (!p.isInGame()) continue;
            int lost = p.loseLife(lifeAmount, false, false);
            if (lost > 0) {
                lossMap.put(p, lost);
            }
            lifeLost += lost;
        }
        sa.setSVar("AFLifeLost", "Number$" + lifeLost);
        if (!lossMap.isEmpty()) {
            Map<AbilityKey, Object> runParams = AbilityKey.mapFromPIMap(lossMap);
            sa.getHostCard().getGame().getTriggerHandler().runTrigger(TriggerType.LifeLostAll, runParams, false);
        }
    }
}

