/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import forge.GameCommand;
import forge.game.Game;
import forge.game.ability.SpellAbilityEffect;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.util.Lang;

public class GoadEffect
extends SpellAbilityEffect {
    @Override
    protected String getStackDescription(SpellAbility sa) {
        Player player = sa.getActivatingPlayer();
        CardCollection tgt = GoadEffect.getDefinedCardsOrTargeted(sa, "Defined");
        String tgtString = sa.getParamOrDefault("DefinedDesc", Lang.joinHomogenous(tgt));
        if (tgtString.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(player).append(" goads ").append(tgtString).append(".");
        return sb.toString();
    }

    @Override
    public void resolve(SpellAbility sa) {
        Player player = sa.getActivatingPlayer();
        Game game = player.getGame();
        final long timestamp = game.getNextTimestamp();
        boolean remember = sa.hasParam("RememberGoaded");
        boolean ungoad = sa.hasParam("NoLonger");
        String duration = sa.getParamOrDefault("Duration", "UntilYourNextTurn");
        for (final Card tgtC : GoadEffect.getDefinedCardsOrTargeted(sa)) {
            if (!tgtC.isInPlay()) continue;
            if (ungoad) {
                tgtC.unGoad();
                continue;
            }
            tgtC.addGoad(timestamp, player);
            if (!duration.equals("Permanent")) {
                GameCommand until = new GameCommand(){
                    private static final long serialVersionUID = -1731759226844770852L;

                    @Override
                    public void run() {
                        tgtC.removeGoad(timestamp);
                    }
                };
                GoadEffect.addUntilCommand(sa, until, duration, player);
            }
            if (!remember || !tgtC.isGoaded()) continue;
            sa.getHostCard().addRemembered(tgtC);
        }
    }
}

