/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import com.google.common.collect.Lists;
import forge.game.Game;
import forge.game.ability.SpellAbilityEffect;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardCollectionView;
import forge.game.card.CardLists;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.game.zone.ZoneType;
import forge.util.Aggregates;
import forge.util.Localizer;
import forge.util.MyRandom;
import java.util.ArrayList;

public class FlipOntoBattlefieldEffect
extends SpellAbilityEffect {
    @Override
    public void resolve(SpellAbility sa) {
        float chanceToFlip = 0.85f;
        int maxFlipTimes = 2;
        float chanceToHit = 0.7f;
        float chanceToHitTwoCards = 0.2f;
        Card host = sa.getHostCard();
        Player p = sa.getActivatingPlayer();
        Game game = host.getGame();
        boolean flippedOnce = false;
        CardCollectionView tgtBox = p.getController().chooseCardsForEffect(game.getCardsIn(ZoneType.Battlefield), sa, Localizer.getInstance().getMessage("lblChooseDesiredLocation", new Object[0]), 1, 1, sa.hasParam("AllowRandom"), null);
        Card tgtLoc = (Card)tgtBox.getFirst();
        Card lhsNeighbor = this.getNeighboringCard(tgtLoc, -1);
        Card rhsNeighbor = this.getNeighboringCard(tgtLoc, 1);
        CardCollection randChoices = new CardCollection();
        randChoices.add(tgtLoc);
        if (lhsNeighbor != null) {
            randChoices.add(lhsNeighbor);
        } else if (rhsNeighbor != null) {
            randChoices.add(rhsNeighbor);
        }
        boolean bl = flippedOnce = MyRandom.getRandom().nextFloat() <= 0.85f;
        if (!flippedOnce) {
            sa.setSVar("TimesFlipped", "0");
            game.getAction().notifyOfValue(sa, host, Localizer.getInstance().getMessage("lblDidNotFlipOver", new Object[0]), null);
            return;
        }
        int flippedTimes = MyRandom.getRandom().nextInt(2) + 1;
        sa.setSVar("TimesFlipped", String.valueOf(flippedTimes));
        game.getAction().notifyOfValue(sa, host, Localizer.getInstance().getMessage("lblFlippedOver", flippedTimes), null);
        CardCollection hit = new CardCollection();
        float outcome = MyRandom.getRandom().nextFloat();
        if (outcome <= 0.2f) {
            hit.addAll(Aggregates.random(randChoices, randChoices.size() > 1 ? 2 : 1));
            if (hit.size() == 2) {
                game.getAction().notifyOfValue(sa, host, Localizer.getInstance().getMessage("lblLandedOnTwoCards", hit.getFirst(), hit.getLast()), null);
            } else {
                game.getAction().notifyOfValue(sa, host, Localizer.getInstance().getMessage("lblLandedOnOneCard", hit.getFirst()), null);
            }
        } else if (outcome <= 0.7f) {
            hit.add(Aggregates.random(randChoices));
            game.getAction().notifyOfValue(sa, host, Localizer.getInstance().getMessage("lblLandedOnOneCard", hit.getFirst()), null);
        } else {
            game.getAction().notifyOfValue(sa, host, Localizer.getInstance().getMessage("lblDidNotLandOnCards", new Object[0]), null);
        }
        host.addRemembered(hit);
    }

    @Override
    protected String getStackDescription(SpellAbility sa) {
        StringBuilder sb = new StringBuilder();
        Card host = sa.getHostCard();
        sb.append("Flip ");
        sb.append(host.toString());
        sb.append(" onto the battlefield from a height of at least one foot.");
        return sb.toString();
    }

    private Card getNeighboringCard(Card c, int direction) {
        Player controller = c.getController();
        ArrayList attachments = Lists.newArrayList();
        ArrayList<Card> cardsOTB = Lists.newArrayList(CardLists.filter((Iterable<Card>)controller.getCardsIn(ZoneType.Battlefield), card -> {
            if (card.isAttachedToEntity(c)) {
                attachments.add(card);
                return true;
            }
            if (c.isCreature()) {
                return card.isCreature();
            }
            if (c.isPlaneswalker() || c.isArtifact() || c.isEnchantment() && !c.isAura()) {
                return card.isPlaneswalker() || card.isArtifact() || c.isEnchantment() && !c.isAura();
            }
            if (c.isLand()) {
                return card.isLand();
            }
            if (c.isAttachedToEntity()) {
                return card.isAttachedToEntity(c.getEntityAttachedTo()) || c.equals(card.getAttachedTo());
            }
            return card.sharesCardTypeWith(c);
        }));
        float hitAttachment = 0.5f;
        if (!attachments.isEmpty() && direction < 0 && MyRandom.getRandom().nextFloat() <= hitAttachment) {
            return (Card)Aggregates.random(attachments);
        }
        int loc = cardsOTB.indexOf(c);
        if (direction < 0 && loc > 0) {
            return cardsOTB.get(loc - 1);
        }
        if (loc < cardsOTB.size() - 1) {
            return cardsOTB.get(loc + 1);
        }
        return c;
    }
}

