/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import com.google.common.collect.Lists;
import forge.game.GameObject;
import forge.game.ability.AbilityKey;
import forge.game.ability.AbilityUtils;
import forge.game.ability.SpellAbilityEffect;
import forge.game.card.Card;
import forge.game.event.GameEventFlipCoin;
import forge.game.player.Player;
import forge.game.player.PlayerCollection;
import forge.game.player.PlayerController;
import forge.game.spellability.SpellAbility;
import forge.game.trigger.TriggerType;
import forge.util.Localizer;
import forge.util.MyRandom;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class FlipCoinEffect
extends SpellAbilityEffect {
    public static boolean[] BOTH_CHOICES = new boolean[]{false, true};

    @Override
    protected String getStackDescription(SpellAbility sa) {
        Card host = sa.getHostCard();
        Player player = host.getController();
        List<GameObject> tgts = FlipCoinEffect.getTargets(sa);
        StringBuilder sb = new StringBuilder();
        sb.append(player).append(" flips a coin.");
        if (tgts != null && !tgts.isEmpty()) {
            sb.append(" Targeting: ").append(tgts).append(".");
        }
        return sb.toString();
    }

    @Override
    public void resolve(SpellAbility sa) {
        PlayerCollection caller;
        Card host = sa.getHostCard();
        Player player = host.getController();
        int flipMultiplier = 1;
        PlayerCollection playersToFlip = AbilityUtils.getDefinedPlayers(host, sa.getParam("Flipper"), sa);
        if (playersToFlip.isEmpty()) {
            playersToFlip.add(sa.getActivatingPlayer());
        }
        if ((caller = AbilityUtils.getDefinedPlayers(host, sa.getParam("Caller"), sa)).isEmpty()) {
            caller.add(player);
        }
        boolean noCall = sa.hasParam("NoCall");
        boolean forEachPlayer = sa.hasParam("ForEachPlayer");
        String varName = sa.getParamOrDefault("SaveNumFlipsToSVar", "X");
        boolean victory = false;
        int amount = 1;
        if (sa.hasParam("Amount")) {
            amount = AbilityUtils.calculateAmount(host, sa.getParam("Amount"), sa);
        }
        if (!noCall && !forEachPlayer && amount == 1) {
            flipMultiplier = FlipCoinEffect.getFlipMultiplier((Player)caller.get(0));
            victory = FlipCoinEffect.flipCoinCall((Player)caller.get(0), sa, flipMultiplier, varName);
        }
        boolean rememberResult = sa.hasParam("RememberResult");
        for (Player flipper : playersToFlip) {
            int countLosses;
            int countWins;
            int i;
            if (noCall) {
                SpellAbility sub;
                flipMultiplier = FlipCoinEffect.getFlipMultiplier(flipper);
                int countHeads = 0;
                int countTails = 0;
                for (i = 0; i < amount; ++i) {
                    boolean resultIsHeads = this.flipCoinNoCall(sa, flipper, flipMultiplier, varName);
                    if (resultIsHeads) {
                        ++countHeads;
                    } else {
                        ++countTails;
                    }
                    if (!rememberResult) continue;
                    host.addFlipResult(flipper, resultIsHeads ? "Heads" : "Tails");
                }
                if (countHeads > 0 && (sub = sa.getAdditionalAbility("HeadsSubAbility")) != null) {
                    if (sa.hasParam("Amount")) {
                        sub.setSVar(varName, "Number$" + countHeads);
                    }
                    AbilityUtils.resolve(sub);
                }
                if (countTails <= 0 || (sub = sa.getAdditionalAbility("TailsSubAbility")) == null) continue;
                if (sa.hasParam("Amount")) {
                    sub.setSVar(varName, "Number$" + countTails);
                }
                AbilityUtils.resolve(sub);
                continue;
            }
            if (amount > 1) {
                SpellAbility sub;
                flipMultiplier = FlipCoinEffect.getFlipMultiplier(flipper);
                countWins = 0;
                countLosses = 0;
                for (i = 0; i < amount; ++i) {
                    boolean win = FlipCoinEffect.flipCoinCall((Player)caller.get(0), sa, flipMultiplier, varName);
                    if (win) {
                        ++countWins;
                        continue;
                    }
                    ++countLosses;
                }
                if (countWins > 0 && (sub = sa.getAdditionalAbility("WinSubAbility")) != null) {
                    sub.setSVar("Wins", "Number$" + countWins);
                    AbilityUtils.resolve(sub);
                }
                if (countLosses > 0 && (sub = sa.getAdditionalAbility("LoseSubAbility")) != null) {
                    sub.setSVar("Losses", "Number$" + countLosses);
                    AbilityUtils.resolve(sub);
                }
                if (!sa.hasParam("RememberNumber")) continue;
                String toRemember = sa.getParam("RememberNumber");
                if (toRemember.startsWith("Win")) {
                    host.addRemembered(countWins);
                    continue;
                }
                if (!toRemember.startsWith("Loss")) continue;
                host.addRemembered(countLosses);
                continue;
            }
            if (forEachPlayer) {
                ArrayList<Object> tempRemembered;
                SpellAbility sub;
                flipMultiplier = FlipCoinEffect.getFlipMultiplier(flipper);
                countWins = 0;
                countLosses = 0;
                PlayerCollection wonFor = new PlayerCollection();
                PlayerCollection lostFor = new PlayerCollection();
                for (Player p : AbilityUtils.getDefinedPlayers(host, sa.getParam("ForEachPlayer"), sa)) {
                    String info = " (" + p.getName() + ")";
                    boolean win = FlipCoinEffect.flipCoinCall((Player)caller.get(0), sa, flipMultiplier, varName, info);
                    if (win) {
                        ++countWins;
                        wonFor.add(p);
                        continue;
                    }
                    ++countLosses;
                    lostFor.add(p);
                }
                if (countWins > 0 && (sub = sa.getAdditionalAbility("WinSubAbility")) != null) {
                    tempRemembered = Lists.newArrayList(host.getRemembered());
                    host.removeRemembered(tempRemembered);
                    host.addRemembered(wonFor);
                    sub.setSVar("Wins", "Number$" + countWins);
                    AbilityUtils.resolve(sub);
                    host.removeRemembered(wonFor);
                    host.addRemembered(tempRemembered);
                }
                if (countLosses <= 0 || (sub = sa.getAdditionalAbility("LoseSubAbility")) == null) continue;
                tempRemembered = Lists.newArrayList(host.getRemembered());
                host.removeRemembered(tempRemembered);
                host.addRemembered(lostFor);
                sub.setSVar("Losses", "Number$" + countLosses);
                AbilityUtils.resolve(sub);
                host.removeRemembered(lostFor);
                host.addRemembered(tempRemembered);
                continue;
            }
            if (victory) {
                if (sa.hasParam("RememberWinner")) {
                    host.addRemembered(flipper);
                }
                if (!sa.hasAdditionalAbility("WinSubAbility")) continue;
                AbilityUtils.resolve(sa.getAdditionalAbility("WinSubAbility"));
                continue;
            }
            if (sa.hasParam("RememberLoser")) {
                host.addRemembered(flipper);
            }
            if (!sa.hasAdditionalAbility("LoseSubAbility")) continue;
            AbilityUtils.resolve(sa.getAdditionalAbility("LoseSubAbility"));
        }
    }

    public boolean flipCoinNoCall(SpellAbility sa, Player flipper, int multiplier, String varName) {
        boolean result = false;
        int numSuccesses = 0;
        do {
            HashSet<Boolean> flipResults = new HashSet<Boolean>();
            for (int i = 0; i < multiplier; ++i) {
                flipResults.add(MyRandom.getRandom().nextBoolean());
            }
            flipper.getGame().fireEvent(new GameEventFlipCoin());
            boolean bl = result = flipResults.size() == 1 ? ((Boolean)flipResults.iterator().next()).booleanValue() : flipper.getController().chooseFlipResult(sa, flipper, BOTH_CHOICES, false);
            if (result) {
                ++numSuccesses;
            }
            flipper.getGame().getAction().notifyOfValue(sa, flipper, result ? Localizer.getInstance().getMessage("lblHeads", new Object[0]) : Localizer.getInstance().getMessage("lblTails", new Object[0]), null);
        } while (sa.hasParam("FlipUntilYouLose") && result);
        if (sa.hasParam("FlipUntilYouLose") && sa.hasAdditionalAbility("LoseSubAbility")) {
            sa.getAdditionalAbility("LoseSubAbility").setSVar(varName, "Number$" + numSuccesses);
        }
        return result;
    }

    public static boolean flipCoinCall(Player caller, SpellAbility sa, int multiplier) {
        String varName = sa.getParamOrDefault("SaveNumFlipsToSVar", "X");
        return FlipCoinEffect.flipCoinCall(caller, sa, multiplier, varName, "");
    }

    public static boolean flipCoinCall(Player caller, SpellAbility sa, int multiplier, String varName) {
        return FlipCoinEffect.flipCoinCall(caller, sa, multiplier, varName, "");
    }

    public static boolean flipCoinCall(Player caller, SpellAbility sa, int multiplier, String varName, String info) {
        boolean wonFlip = false;
        int numSuccesses = 0;
        do {
            HashSet<Boolean> flipResults = new HashSet<Boolean>();
            boolean choice = caller.getController().chooseBinary(sa, sa.getHostCard().getName() + " - " + Localizer.getInstance().getMessage("lblCallCoinFlip", new Object[0]) + info, PlayerController.BinaryChoiceType.HeadsOrTails);
            for (int i = 0; i < multiplier; ++i) {
                flipResults.add(MyRandom.getRandom().nextBoolean());
            }
            caller.getGame().fireEvent(new GameEventFlipCoin());
            boolean result = flipResults.size() == 1 ? ((Boolean)flipResults.iterator().next()).booleanValue() : caller.getController().chooseFlipResult(sa, caller, BOTH_CHOICES, true);
            boolean bl = wonFlip = result == choice;
            if (wonFlip) {
                ++numSuccesses;
            }
            caller.getGame().getAction().notifyOfValue(sa, caller, wonFlip ? Localizer.getInstance().getMessage("lblWin", new Object[0]) : Localizer.getInstance().getMessage("lblLose", new Object[0]), null);
            Map<AbilityKey, Object> runParams = AbilityKey.mapFromPlayer(caller);
            runParams.put(AbilityKey.Result, wonFlip);
            caller.getGame().getTriggerHandler().runTrigger(TriggerType.FlippedCoin, runParams, false);
        } while (sa.hasParam("FlipUntilYouLose") && wonFlip);
        if (sa.hasParam("FlipUntilYouLose") && sa.hasAdditionalAbility("LoseSubAbility")) {
            sa.getAdditionalAbility("LoseSubAbility").setSVar(varName, "Number$" + numSuccesses);
        }
        return wonFlip;
    }

    public static int getFlipMultiplier(Player flipper) {
        String str = "If you would flip a coin, instead flip two coins and ignore one.";
        return 1 << flipper.getKeywords().getAmount(str);
    }
}

