/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import com.google.common.collect.Lists;
import forge.game.Game;
import forge.game.GameEntityCounterTable;
import forge.game.ability.AbilityKey;
import forge.game.ability.AbilityUtils;
import forge.game.ability.effects.DamageBaseEffect;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardCollectionView;
import forge.game.card.CardDamageMap;
import forge.game.player.Player;
import forge.game.replacement.ReplacementType;
import forge.game.spellability.SpellAbility;
import forge.game.trigger.TriggerType;
import forge.util.CardTranslation;
import forge.util.Lang;
import forge.util.Localizer;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;

public class FightEffect
extends DamageBaseEffect {
    @Override
    protected String getStackDescription(SpellAbility sa) {
        CardCollection cards;
        StringBuilder sb = new StringBuilder();
        List<Card> fighters = FightEffect.getFighters(sa);
        if (fighters.size() > 1) {
            sb.append(fighters.get(0)).append(" fights ").append(fighters.get(1)).append(".");
        } else if (fighters.size() == 1) {
            sb.append(fighters.get(0)).append(" fights.");
        }
        if (sa.hasParam("ReplaceDyingDefined") && !(cards = AbilityUtils.getDefinedCards(sa.getHostCard(), sa.getParam("ReplaceDyingDefined"), sa)).isEmpty()) {
            sb.append(" If ").append(Lang.joinHomogenous(cards, null, "or"));
            sb.append(" would die this turn, exile it instead.");
        }
        return sb.toString();
    }

    @Override
    public void resolve(SpellAbility sa) {
        Card host = sa.getHostCard();
        List<Card> fighters = FightEffect.getFighters(sa);
        Game game = host.getGame();
        if (fighters.size() < 2) {
            return;
        }
        Player controller = host.getController();
        boolean isOptional = sa.hasParam("Optional");
        if (isOptional && !controller.getController().confirmAction(sa, null, Localizer.getInstance().getMessage("lblWouldYouLikeFight", CardTranslation.getTranslatedName(fighters.get(0).getName()), CardTranslation.getTranslatedName(fighters.get(1).getName())), null)) {
            return;
        }
        this.dealDamage(sa, fighters.get(0), fighters.get(1));
        for (Card c : fighters) {
            EnumMap<AbilityKey, Object> runParams = AbilityKey.newMap();
            runParams.put(AbilityKey.Fighter, c);
            game.getTriggerHandler().runTrigger(TriggerType.Fight, runParams, false);
        }
        EnumMap<AbilityKey, Object> runParams = AbilityKey.newMap();
        runParams.put(AbilityKey.Fighters, fighters);
        game.getTriggerHandler().runTrigger(TriggerType.FightOnce, runParams, false);
    }

    private static List<Card> getFighters(SpellAbility sa) {
        ArrayList<Card> fighterList = Lists.newArrayList();
        Card fighter1 = null;
        Card fighter2 = null;
        Card host = sa.getHostCard();
        Game game = host.getGame();
        CardCollectionView tgts = null;
        if (sa.usesTargeting() && !(tgts = sa.getTargets().getTargetCards()).isEmpty()) {
            fighter1 = (Card)tgts.get(false);
        }
        if (sa.hasParam("Defined")) {
            List<Card> defined = FightEffect.getTargetCardsWithDuplicates(true, "Defined", sa);
            ArrayList<Card> newDefined = Lists.newArrayList();
            for (Card d : defined) {
                Card g2 = game.getCardState(d, null);
                if (g2 == null || !g2.equalsWithGameTimestamp(d) || !d.isInPlay() || d.isPhasedOut() || !d.isCreature()) continue;
                newDefined.add(g2);
            }
            defined = newDefined;
            if (!defined.isEmpty()) {
                if (defined.size() > 1 && fighter1 == null) {
                    fighter1 = defined.get(0);
                    fighter2 = defined.get(1);
                } else {
                    fighter2 = fighter1;
                    fighter1 = defined.get(0);
                }
            }
        } else if (tgts.size() > 1) {
            fighter2 = (Card)tgts.get(true);
        }
        if (fighter1 != null) {
            fighterList.add(fighter1);
        }
        if (fighter2 != null) {
            fighterList.add(fighter2);
        }
        return fighterList;
    }

    private void dealDamage(SpellAbility sa, Card fighterA, Card fighterB) {
        boolean usedDamageMap = true;
        CardDamageMap damageMap = sa.getDamageMap();
        CardDamageMap preventMap = sa.getPreventMap();
        GameEntityCounterTable counterTable = sa.getCounterTable();
        if (damageMap == null) {
            damageMap = new CardDamageMap();
            preventMap = new CardDamageMap();
            counterTable = new GameEntityCounterTable();
            usedDamageMap = false;
        }
        fighterA.getGame().getReplacementHandler().run(ReplacementType.AssignDealDamage, AbilityKey.mapFromAffected(fighterA));
        fighterB.getGame().getReplacementHandler().run(ReplacementType.AssignDealDamage, AbilityKey.mapFromAffected(fighterB));
        int dmg1 = fighterA.getNetPower();
        if (fighterA.equals(fighterB)) {
            damageMap.put(fighterA, fighterA, dmg1 * 2);
        } else {
            int dmg2 = fighterB.getNetPower();
            damageMap.put(fighterA, fighterB, dmg1);
            damageMap.put(fighterB, fighterA, dmg2);
            fighterB.setFoughtThisTurn(true);
        }
        fighterA.setFoughtThisTurn(true);
        if (!usedDamageMap) {
            sa.getHostCard().getGame().getAction().dealDamage(false, damageMap, preventMap, counterTable, sa);
        }
        FightEffect.replaceDying(sa);
    }
}

