/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import forge.game.Game;
import forge.game.ability.AbilityKey;
import forge.game.ability.SpellAbilityEffect;
import forge.game.card.CardCollection;
import forge.game.card.CardZoneTable;
import forge.game.player.Player;
import forge.game.player.PlayerCollection;
import forge.game.spellability.SpellAbility;
import forge.util.Localizer;
import java.util.EnumMap;

public class EndTurnEffect
extends SpellAbilityEffect {
    @Override
    public void resolve(SpellAbility sa) {
        Player ender;
        PlayerCollection enders = EndTurnEffect.getDefinedPlayersOrTargeted(sa, "Defined");
        Player player = ender = enders.isEmpty() ? sa.getActivatingPlayer() : (Player)enders.get(0);
        if (!ender.isInGame()) {
            ender = EndTurnEffect.getNewChooser(sa, sa.getActivatingPlayer(), ender);
        }
        if (sa.hasParam("Optional") && !ender.getController().confirmAction(sa, null, Localizer.getInstance().getMessage("lblDoYouWantEndTurn", new Object[0]), null)) {
            return;
        }
        Game game = ender.getGame();
        game.getTriggerHandler().clearWaitingTriggers();
        EnumMap<AbilityKey, Object> moveParams = AbilityKey.newMap();
        CardZoneTable zoneMovements = AbilityKey.addCardZoneTableParams(moveParams, sa);
        game.getAction().exile(new CardCollection(game.getStackZone().getCards()), sa, moveParams);
        zoneMovements.triggerChangesZoneAll(game, sa);
        game.getStack().clear();
        game.getStack().clearSimultaneousStack();
        game.getPhaseHandler().endCombat();
        game.getAction().checkStateEffects(true);
        game.getPhaseHandler().endTurnByEffect();
    }

    @Override
    protected String getStackDescription(SpellAbility sa) {
        return "End the turn.";
    }
}

