/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import com.google.common.collect.Maps;
import forge.game.Game;
import forge.game.ability.AbilityKey;
import forge.game.ability.SpellAbilityEffect;
import forge.game.mana.Mana;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.game.staticability.StaticAbilityUnspentMana;
import forge.game.trigger.TriggerType;
import forge.util.Lang;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DrainManaEffect
extends SpellAbilityEffect {
    @Override
    protected String getStackDescription(SpellAbility sa) {
        StringBuilder sb = new StringBuilder();
        sb.append(Lang.joinHomogenous(DrainManaEffect.getTargetPlayers(sa)));
        sb.append(" loses all unspent mana.");
        return sb.toString();
    }

    @Override
    public void resolve(SpellAbility sa) {
        Game game = sa.getHostCard().getGame();
        ArrayList<Mana> drained = new ArrayList<Mana>();
        HashMap<Player, Integer> lossMap = Maps.newHashMap();
        for (Player p : DrainManaEffect.getTargetPlayers(sa)) {
            int lost;
            if (!p.isInGame()) continue;
            List<Mana> cleared = p.getManaPool().clearPool(false);
            drained.addAll(cleared);
            if (!StaticAbilityUnspentMana.hasManaBurn(p) || (lost = p.loseLife(cleared.size(), false, true)) <= 0) continue;
            lossMap.put(p, lost);
        }
        if (!lossMap.isEmpty()) {
            Map<AbilityKey, Object> runLifeLostParams = AbilityKey.mapFromPIMap(lossMap);
            game.getTriggerHandler().runTrigger(TriggerType.LifeLostAll, runLifeLostParams, false);
        }
        if (sa.hasParam("DrainMana")) {
            sa.getActivatingPlayer().getManaPool().add(drained);
        }
        if (sa.hasParam("RememberDrainedMana")) {
            sa.getHostCard().addRemembered(drained.size());
        }
    }
}

