/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import forge.card.MagicColor;
import forge.game.CardTraitBase;
import forge.game.Game;
import forge.game.GameActionUtil;
import forge.game.GameEntityCounterTable;
import forge.game.ability.AbilityKey;
import forge.game.ability.AbilityUtils;
import forge.game.ability.SpellAbilityEffect;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardCollectionView;
import forge.game.card.CardCopyService;
import forge.game.card.CardFactoryUtil;
import forge.game.card.CardLists;
import forge.game.card.CardPredicates;
import forge.game.card.CardZoneTable;
import forge.game.card.CounterType;
import forge.game.event.GameEventCombatChanged;
import forge.game.player.DelayedReveal;
import forge.game.player.Player;
import forge.game.player.PlayerCollection;
import forge.game.player.PlayerView;
import forge.game.spellability.SpellAbility;
import forge.game.zone.ZoneType;
import forge.util.CardTranslation;
import forge.util.Lang;
import forge.util.Localizer;
import forge.util.TextUtil;
import java.util.Collections;
import java.util.EnumMap;
import org.apache.commons.lang3.StringUtils;

public class DigEffect
extends SpellAbilityEffect {
    @Override
    protected String getStackDescription(SpellAbility sa) {
        Card host = sa.getHostCard();
        StringBuilder sb = new StringBuilder();
        PlayerCollection tgtPlayers = DigEffect.getTargetPlayers(sa);
        String spellDesc = sa.getParamOrDefault("SpellDescription", "");
        if (spellDesc.contains("X card")) {
            sb.append("[").append(host.getController()).append("] ").append(spellDesc);
        } else {
            int numToDig = AbilityUtils.calculateAmount(host, sa.getParam("DigNum"), sa);
            String toChange = sa.getParamOrDefault("ChangeNum", "1");
            int numToChange = toChange.startsWith("All") ? numToDig : AbilityUtils.calculateAmount(host, sa.getParam("ChangeNum"), sa);
            String verb = " looks at ";
            if (sa.hasParam("DestinationZone") && sa.getParam("DestinationZone").equals("Exile") && numToDig == numToChange) {
                verb = " exiles ";
            } else if (sa.hasParam("Reveal") && sa.getParam("Reveal").equals("True")) {
                verb = " reveals ";
            }
            sb.append(host.getController()).append(verb).append("the top ");
            sb.append(numToDig == 1 ? "card" : Lang.getNumeral(numToDig) + " cards").append(" of ");
            if (tgtPlayers.contains(host.getController())) {
                sb.append("their ");
            } else {
                for (Player p : tgtPlayers) {
                    sb.append(Lang.getInstance().getPossesive(p.getName())).append(" ");
                }
            }
            sb.append("library.");
            if (numToDig != numToChange) {
                String destZone2;
                String destZone1 = sa.hasParam("DestinationZone") ? sa.getParam("DestinationZone").toLowerCase() : "hand";
                String string = destZone2 = sa.hasParam("DestinationZone2") ? sa.getParam("DestinationZone2").toLowerCase() : "on the bottom of their library in any order.";
                if (sa.hasParam("RestRandomOrder")) {
                    destZone2 = destZone2.replace("any", "a random");
                }
                String verb2 = "put ";
                String where = " into their hand ";
                if (destZone1.equals("exile")) {
                    verb2 = "exile ";
                    where = " ";
                } else if (destZone1.equals("battlefield")) {
                    verb2 = "put ";
                    where = " onto the battlefield ";
                }
                sb.append(" They ").append(sa.hasParam("Optional") ? "may " : "").append(verb2);
                if (sa.hasParam("ChangeValid")) {
                    String what;
                    String string2 = what = sa.hasParam("ChangeValidDesc") ? sa.getParam("ChangeValidDesc") : sa.getParam("ChangeValid");
                    if (!StringUtils.containsIgnoreCase(what, "card")) {
                        what = what + " card";
                    }
                    sb.append(Lang.nounWithNumeralExceptOne(numToChange, what)).append(" from among them").append(where);
                } else {
                    sb.append(Lang.getNumeral(numToChange)).append(" of them").append(where);
                }
                sb.append(sa.hasParam("ExileFaceDown") ? "face down " : "");
                if (sa.hasParam("WithCounters") || sa.hasParam("ExileWithCounters")) {
                    String ctr = sa.hasParam("WithCounters") ? sa.getParam("WithCounters") : sa.getParam("ExileWithCounters");
                    sb.append("with a ");
                    sb.append(CounterType.getType(ctr).getName().toLowerCase());
                    sb.append(" counter on it. They ");
                } else {
                    sb.append("and ");
                }
                sb.append("put the rest ").append(destZone2);
            }
        }
        return sb.toString();
    }

    @Override
    public void resolve(SpellAbility sa) {
        Card host = sa.getHostCard();
        Player activator = sa.getActivatingPlayer();
        Game game = activator.getGame();
        Player cont = host.getController();
        Player chooser = activator;
        int digNum = AbilityUtils.calculateAmount(host, sa.getParam("DigNum"), sa);
        ZoneType srcZone = sa.hasParam("SourceZone") ? ZoneType.smartValueOf(sa.getParam("SourceZone")) : ZoneType.Library;
        ZoneType destZone1 = sa.hasParam("DestinationZone") ? ZoneType.smartValueOf(sa.getParam("DestinationZone")) : ZoneType.Hand;
        ZoneType destZone2 = sa.hasParam("DestinationZone2") ? ZoneType.smartValueOf(sa.getParam("DestinationZone2")) : ZoneType.Library;
        int libraryPosition = sa.hasParam("LibraryPosition") ? Integer.parseInt(sa.getParam("LibraryPosition")) : -1;
        int libraryPosition2 = sa.hasParam("LibraryPosition2") ? Integer.parseInt(sa.getParam("LibraryPosition2")) : -1;
        int destZone1ChangeNum = 1;
        String changeValid = sa.getParamOrDefault("ChangeValid", "");
        boolean anyNumber = sa.hasParam("AnyNumber");
        boolean optional = sa.hasParam("Optional");
        boolean skipReorder = sa.hasParam("SkipReorder");
        boolean forceRevealToController = sa.hasParam("ForceRevealToController");
        boolean mayBeSkipped = sa.hasParam("PromptToSkipOptionalAbility");
        String optionalAbilityPrompt = sa.getParam("OptionalAbilityPrompt");
        boolean remZone1 = false;
        boolean remZone2 = false;
        if (sa.hasParam("RememberChanged")) {
            remZone1 = true;
        }
        if (sa.hasParam("RememberMovedToZone")) {
            if (sa.getParam("RememberMovedToZone").contains("1")) {
                remZone1 = true;
            }
            if (sa.getParam("RememberMovedToZone").contains("2")) {
                remZone2 = true;
            }
        }
        boolean changeAll = false;
        boolean totalCMC = sa.hasParam("WithTotalCMC");
        int totcmc = AbilityUtils.calculateAmount(host, sa.getParam("WithTotalCMC"), sa);
        if (sa.hasParam("ChangeNum")) {
            if (sa.getParam("ChangeNum").equalsIgnoreCase("All")) {
                changeAll = true;
            } else {
                destZone1ChangeNum = AbilityUtils.calculateAmount(host, sa.getParam("ChangeNum"), sa);
            }
        }
        CardZoneTable zoneMovements = new CardZoneTable(game.copyLastStateBattlefield(), game.copyLastStateGraveyard());
        GameEntityCounterTable counterTable = new GameEntityCounterTable();
        boolean combatChanged = false;
        for (Player p : DigEffect.getDefinedPlayersOrTargeted(sa)) {
            Object chosen;
            CardCollection movedCards;
            Object prompt;
            CardCollection valid;
            if (!p.isInGame()) continue;
            CardCollection top = new CardCollection();
            CardCollection rest = new CardCollection();
            CardCollection all = new CardCollection(p.getCardsIn(srcZone));
            if (sa.hasParam("FromBottom")) {
                Collections.reverse(all);
            }
            int numToDig = Math.min(digNum, all.size());
            for (int i = 0; i < numToDig; ++i) {
                top.add((Card)all.get(i));
            }
            if (top.isEmpty()) continue;
            DelayedReveal delayedReveal = null;
            boolean hasRevealed = true;
            if (sa.hasParam("Reveal") && "True".equalsIgnoreCase(sa.getParam("Reveal"))) {
                game.getAction().reveal(top, p, false);
            } else if (sa.hasParam("RevealOptional")) {
                hasRevealed = p.getController().confirmAction(sa, null, Localizer.getInstance().getMessage("lblRevealCardToOtherPlayers", new Object[0]), null);
                if (hasRevealed) {
                    game.getAction().reveal(top, p);
                }
            } else if (!sa.hasParam("NoLooking")) {
                delayedReveal = new DelayedReveal(top, srcZone, PlayerView.get(p), CardTranslation.getTranslatedName(host.getName()) + " - " + Localizer.getInstance().getMessage("lblLookingCardIn", new Object[0]) + " ");
            }
            if (sa.hasParam("RememberRevealed") && hasRevealed) {
                host.addRemembered(top);
            }
            if (sa.hasParam("ImprintRevealed") && hasRevealed) {
                host.addImprintedCards(top);
            }
            if (sa.hasParam("Choser")) {
                PlayerCollection choosers = AbilityUtils.getDefinedPlayers(host, sa.getParam("Choser"), sa);
                if (!choosers.isEmpty()) {
                    chooser = activator.getController().chooseSingleEntityForEffect(choosers, null, sa, Localizer.getInstance().getMessage("lblChooser", new Object[0]) + ":", false, p, null);
                }
                if (sa.hasParam("SetChosenPlayer")) {
                    host.setChosenPlayer(chooser);
                }
            }
            rest.addAll(top);
            if (!changeValid.isEmpty()) {
                if (changeValid.contains("ChosenType")) {
                    changeValid = changeValid.replace("ChosenType", host.getChosenType());
                }
                valid = CardLists.getValidCards((Iterable<Card>)top, changeValid, cont, host, (CardTraitBase)sa);
                if (totalCMC) {
                    valid = CardLists.getValidCards((Iterable<Card>)valid, "Card.cmcLE" + totcmc, cont, host, (CardTraitBase)sa);
                }
            } else if (totalCMC) {
                valid = CardLists.getValidCards((Iterable<Card>)top, "Card.cmcLE" + totcmc, cont, host, (CardTraitBase)sa);
            } else {
                if (p == chooser && destZone1ChangeNum > 1) {
                    delayedReveal = null;
                }
                valid = top;
            }
            if (forceRevealToController) {
                game.getAction().revealTo((CardCollectionView)top, activator);
                delayedReveal = null;
            }
            if (optional && mayBeSkipped && !valid.isEmpty()) {
                Object object = prompt = optionalAbilityPrompt != null ? optionalAbilityPrompt : Localizer.getInstance().getMessage("lblWouldYouLikeProceedWithOptionalAbility", new Object[0]) + " " + host + "?\n\n(" + sa.getDescription() + ")";
                if (!p.getController().confirmAction(sa, null, TextUtil.fastReplace((String)prompt, "CARDNAME", CardTranslation.getTranslatedName(host.getName())), null)) {
                    return;
                }
            }
            if (changeAll) {
                movedCards = new CardCollection(valid);
            } else if (sa.hasParam("RandomChange")) {
                int numChanging = Math.min(destZone1ChangeNum, valid.size());
                movedCards = CardLists.getRandomSubList(valid, numChanging);
            } else if (totalCMC) {
                movedCards = new CardCollection();
                if (p == chooser) {
                    chooser.getController().tempShowCards(top);
                }
                if (valid.isEmpty()) {
                    chooser.getController().notifyOfValue(sa, null, Localizer.getInstance().getMessage("lblNoValidCards", new Object[0]));
                }
                while (!valid.isEmpty() && (anyNumber || movedCards.size() < destZone1ChangeNum) && (chosen = (Object)chooser.getController().chooseSingleEntityForEffect(valid, delayedReveal, sa, Localizer.getInstance().getMessage("lblChooseOne", new Object[0]), anyNumber || optional, p, null)) != null) {
                    movedCards.add(chosen);
                    valid.remove(chosen);
                    valid = CardLists.getValidCards((Iterable<Card>)valid, "Card.cmcLE" + (totcmc -= ((Card)chosen).getCMC()), cont, host, (CardTraitBase)sa);
                }
                chooser.getController().endTempShowCards();
                if (!movedCards.isEmpty()) {
                    game.getAction().reveal(movedCards, chooser, true, Localizer.getInstance().getMessage("lblPlayerPickedChosen", chooser.getName(), ""));
                }
            } else if (sa.hasParam("ForEachColorPair")) {
                movedCards = new CardCollection();
                if (p == chooser) {
                    chooser.getController().tempShowCards(top);
                }
                chosen = MagicColor.COLORPAIR;
                int n = ((byte[])chosen).length;
                for (int i = 0; i < n; ++i) {
                    byte pair = chosen[i];
                    Card chosen2 = chooser.getController().chooseSingleEntityForEffect(CardLists.filter((Iterable<Card>)valid, CardPredicates.isExactlyColor(pair)), delayedReveal, sa, Localizer.getInstance().getMessage("lblChooseOne", new Object[0]), false, p, null);
                    if (chosen2 == null) continue;
                    movedCards.add(chosen2);
                }
                chooser.getController().endTempShowCards();
                if (!movedCards.isEmpty()) {
                    game.getAction().reveal(movedCards, chooser, true, Localizer.getInstance().getMessage("lblPlayerPickedChosen", chooser.getName(), ""));
                }
            } else if (sa.hasParam("WithDifferentPowers")) {
                movedCards = new CardCollection();
                while (!valid.isEmpty() && (anyNumber || movedCards.size() < destZone1ChangeNum)) {
                    String title = Localizer.getInstance().getMessage(movedCards.isEmpty() ? "lblChooseCreature" : "lblChooseCreatureWithDiffPower", new Object[0]);
                    Card choice = p.getController().chooseSingleEntityForEffect(valid, sa, title, true, null);
                    if (choice != null) {
                        movedCards.add(choice);
                        valid = CardLists.getValidCards((Iterable<Card>)valid, "Card.powerNE" + choice.getNetPower(), activator, host, (CardTraitBase)sa);
                        continue;
                    }
                    break;
                }
            } else {
                if (sa.hasParam("PrimaryPrompt")) {
                    prompt = sa.getParam("PrimaryPrompt");
                } else {
                    prompt = Localizer.getInstance().getMessage("lblChooseCardsPutIntoZone", destZone1.getTranslatedName());
                    if (destZone1.equals((Object)ZoneType.Library)) {
                        if (!destZone2.equals((Object)ZoneType.Library) && destZone1ChangeNum == 1) {
                            prompt = libraryPosition == 0 ? Localizer.getInstance().getMessage("lblChooseACardToLeaveTargetLibraryTop", p.getName()) : Localizer.getInstance().getMessage("lblChooseACardLeaveTarget", p.getName(), destZone1.getTranslatedName());
                        } else if (libraryPosition == -1) {
                            prompt = Localizer.getInstance().getMessage("lblChooseCardPutOnTargetLibraryBottom", p.getName());
                        } else if (libraryPosition == 0) {
                            prompt = Localizer.getInstance().getMessage("lblChooseCardPutOnTargetLibraryTop", p.getName());
                        }
                    }
                }
                movedCards = new CardCollection();
                if (valid.isEmpty()) {
                    chooser.getController().notifyOfValue(sa, null, Localizer.getInstance().getMessage("lblNoValidCards", new Object[0]));
                } else {
                    int min2;
                    if (p == chooser) {
                        chooser.getController().tempShowCards(top);
                    }
                    int max = anyNumber ? valid.size() : Math.min(valid.size(), destZone1ChangeNum);
                    int n = min2 = anyNumber || optional ? 0 : max;
                    if (max > 0) {
                        movedCards.addAll(chooser.getController().chooseEntitiesForEffect(valid, min2, max, delayedReveal, sa, (String)prompt, p, null));
                    }
                    chooser.getController().endTempShowCards();
                }
                if (!(changeValid.isEmpty() || sa.hasParam("ExileFaceDown") || sa.hasParam("NoReveal"))) {
                    game.getAction().reveal(movedCards, chooser, true, Localizer.getInstance().getMessage("lblPlayerPickedCardFrom", chooser.getName()));
                }
            }
            if (sa.hasParam("ForgetOtherRemembered")) {
                host.clearRemembered();
            }
            Collections.reverse(movedCards);
            if (destZone1.equals((Object)ZoneType.Battlefield) || destZone1.equals((Object)ZoneType.Library)) {
                movedCards = sa.hasParam("GainControl") ? (CardCollection)activator.getController().orderMoveToZoneList(rest, destZone2, sa) : (CardCollection)GameActionUtil.orderCardsByTheirOwners(game, movedCards, destZone1, sa);
            }
            prompt = movedCards.iterator();
            while (prompt.hasNext()) {
                Card c = (Card)prompt.next();
                EnumMap<AbilityKey, Object> moveParams = AbilityKey.newMap();
                AbilityKey.addCardZoneTableParams(moveParams, zoneMovements);
                if (destZone1.isDeck()) {
                    c = game.getAction().moveTo(destZone1, c, libraryPosition, sa, AbilityKey.newMap());
                } else {
                    if (destZone1.equals((Object)ZoneType.Exile) && !c.canExiledBy(sa, true)) continue;
                    if (sa.hasParam("Tapped")) {
                        c.setTapped(true);
                    }
                    if (sa.hasParam("FaceDown")) {
                        c.turnFaceDown(true);
                        CardFactoryUtil.setFaceDownState(c, sa);
                    }
                    if (destZone1.equals((Object)ZoneType.Battlefield)) {
                        moveParams.put(AbilityKey.SimultaneousETB, (Object)movedCards);
                        if (sa.hasParam("GainControl")) {
                            c.setController(activator, game.getNextTimestamp());
                        }
                        if (sa.hasParam("WithCounters")) {
                            int numCtr = AbilityUtils.calculateAmount(host, sa.getParamOrDefault("WithCountersAmount", "1"), sa);
                            GameEntityCounterTable table = new GameEntityCounterTable();
                            table.put(activator, c, CounterType.getType(sa.getParam("WithCounters")), numCtr);
                            moveParams.put(AbilityKey.CounterTable, (Object)table);
                        }
                    }
                    if (sa.hasAdditionalAbility("AnimateSubAbility")) {
                        moveParams.put(AbilityKey.CardLKI, (Object)CardCopyService.getLKICopy(c));
                        SpellAbility animate = sa.getAdditionalAbility("AnimateSubAbility");
                        host.addRemembered(c);
                        AbilityUtils.resolve(animate);
                        host.removeRemembered(c);
                        animate.setSVar("unanimateTimestamp", String.valueOf(game.getTimestamp()));
                    }
                    c = game.getAction().moveTo(c.getController().getZone(destZone1), c, sa, moveParams);
                    if (destZone1.equals((Object)ZoneType.Battlefield)) {
                        if (DigEffect.addToCombat(c, sa, "Attacking", "Blocking")) {
                            combatChanged = true;
                        }
                    } else if (destZone1.equals((Object)ZoneType.Exile)) {
                        if (sa.hasParam("ExileWithCounters")) {
                            c.addCounter(CounterType.getType(sa.getParam("ExileWithCounters")), 1, activator, counterTable);
                        }
                        DigEffect.handleExiledWith(c, sa);
                    }
                }
                if (sa.hasParam("ExileFaceDown")) {
                    c.turnFaceDown(true);
                }
                if (sa.hasParam("WithMayLook")) {
                    c.addMayLookFaceDownExile(activator);
                }
                if (sa.hasParam("Imprint")) {
                    host.addImprintedCard(c);
                }
                if (sa.hasParam("ForgetOtherRemembered")) {
                    host.clearRemembered();
                }
                if (remZone1) {
                    host.addRemembered(c);
                }
                rest.remove(c);
            }
            if (rest.isEmpty() || sa.hasParam("DestZone2Optional") && !p.getController().confirmAction(sa, null, Localizer.getInstance().getMessage("lblDoYouWantPutCardToZone", destZone2.getTranslatedName()), null)) continue;
            if (destZone2.isDeck() || destZone2 == ZoneType.Graveyard) {
                CardCollection afterOrder = rest;
                if (sa.hasParam("RestRandomOrder")) {
                    CardLists.shuffle(afterOrder);
                } else if (!skipReorder && rest.size() > 1) {
                    afterOrder = destZone2 == ZoneType.Graveyard ? (CardCollection)GameActionUtil.orderCardsByTheirOwners(game, rest, destZone2, sa) : (CardCollection)chooser.getController().orderMoveToZoneList(rest, destZone2, sa);
                }
                for (Card c : afterOrder) {
                    EnumMap<AbilityKey, Object> moveParams = AbilityKey.newMap();
                    AbilityKey.addCardZoneTableParams(moveParams, zoneMovements);
                    Card m4 = game.getAction().moveTo(destZone2, c, libraryPosition2, sa, moveParams);
                    if (!remZone2) continue;
                    host.addRemembered(m4);
                }
                continue;
            }
            for (Card c : rest) {
                EnumMap<AbilityKey, Object> moveParams = AbilityKey.newMap();
                AbilityKey.addCardZoneTableParams(moveParams, zoneMovements);
                if (destZone2 == ZoneType.Exile && !c.canExiledBy(sa, true)) continue;
                c = game.getAction().moveTo(destZone2, c, sa, moveParams);
                if (destZone2 != ZoneType.Exile) continue;
                if (sa.hasParam("ExileWithCounters")) {
                    c.addCounter(CounterType.getType(sa.getParam("ExileWithCounters")), 1, activator, counterTable);
                }
                DigEffect.handleExiledWith(c, sa);
                if (!remZone2) continue;
                host.addRemembered(c);
            }
        }
        if (combatChanged) {
            game.updateCombatForView();
            game.fireEvent(new GameEventCombatChanged());
        }
        zoneMovements.triggerChangesZoneAll(game, sa);
        counterTable.replaceCounterEffect(game, sa, true);
    }
}

