/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import forge.game.Game;
import forge.game.GameActionUtil;
import forge.game.ability.AbilityKey;
import forge.game.ability.SpellAbilityEffect;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardCollectionView;
import forge.game.card.CardUtil;
import forge.game.card.CardZoneTable;
import forge.game.spellability.SpellAbility;
import forge.game.zone.ZoneType;
import forge.util.Lang;
import java.util.EnumMap;
import java.util.Map;

public class DestroyEffect
extends SpellAbilityEffect {
    @Override
    protected String getStackDescription(SpellAbility sa) {
        boolean noRegen = sa.hasParam("NoRegen");
        StringBuilder sb = new StringBuilder();
        CardCollection tgtCards = DestroyEffect.getTargetCards(sa);
        if (tgtCards.isEmpty()) {
            return sa.getParamOrDefault("SpellDescription", "");
        }
        boolean justOne = tgtCards.size() == 1;
        sb.append("Destroy ").append(Lang.joinHomogenous(tgtCards));
        if (sa.hasParam("Radiance")) {
            String thing = sa.getParamOrDefault("ValidTgts", "thing");
            sb.append(" and each other ").append(thing).append(" that shares a color with ");
            sb.append(justOne ? "it" : "them");
        }
        if (noRegen) {
            sb.append(". ").append(justOne ? "It" : "They").append(" can't be regenerated");
        }
        sb.append(".");
        return sb.toString();
    }

    @Override
    public void resolve(SpellAbility sa) {
        Card host = sa.getHostCard();
        Game game = host.getGame();
        if (sa.hasParam("RememberDestroyed")) {
            host.clearRemembered();
        }
        CardCollectionView untargetedCards = CardUtil.getRadiance(sa);
        CardCollectionView tgtCards = DestroyEffect.getTargetCards(sa);
        tgtCards = GameActionUtil.orderCardsByTheirOwners(game, tgtCards, ZoneType.Graveyard, sa);
        untargetedCards = GameActionUtil.orderCardsByTheirOwners(game, untargetedCards, ZoneType.Graveyard, sa);
        EnumMap<AbilityKey, Object> params = AbilityKey.newMap();
        CardZoneTable zoneMovements = AbilityKey.addCardZoneTableParams(params, sa);
        for (Card tgtC : tgtCards) {
            Card gameCard;
            if (!tgtC.isInPlay() || (gameCard = game.getCardState(tgtC, null)) == null || !tgtC.equalsWithGameTimestamp(gameCard)) continue;
            this.internalDestroy(gameCard, sa, params, zoneMovements);
        }
        for (Card unTgtC : untargetedCards) {
            if (!unTgtC.isInPlay()) continue;
            this.internalDestroy(unTgtC, sa, params, zoneMovements);
        }
        zoneMovements.triggerChangesZoneAll(game, sa);
    }

    protected void internalDestroy(Card gameCard, SpellAbility sa, Map<AbilityKey, Object> params, CardZoneTable zoneMovements) {
        boolean destroyed;
        Card host = sa.getHostCard();
        Game game = host.getGame();
        boolean remDestroyed = sa.hasParam("RememberDestroyed");
        boolean noRegen = sa.hasParam("NoRegen");
        boolean alwaysRem = sa.hasParam("AlwaysRemember");
        SpellAbility cause = sa;
        if (sa.isReplacementAbility()) {
            cause = (SpellAbility)sa.getReplacingObject(AbilityKey.Cause);
        }
        if ((destroyed = game.getAction().destroy(gameCard, cause, !noRegen, params)) && remDestroyed) {
            host.addRemembered(gameCard);
        }
        if ((destroyed || alwaysRem) && sa.hasParam("RememberLKI")) {
            host.addRemembered(zoneMovements.getLastStateBattlefield().get(gameCard));
        }
    }
}

