/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import forge.game.CardTraitBase;
import forge.game.Game;
import forge.game.GameEntity;
import forge.game.GameEntityCounterTable;
import forge.game.ability.AbilityUtils;
import forge.game.ability.effects.DamageBaseEffect;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardCollectionView;
import forge.game.card.CardDamageMap;
import forge.game.card.CardLists;
import forge.game.spellability.SpellAbility;
import forge.game.zone.ZoneType;
import forge.util.Lang;

public class DamageEachEffect
extends DamageBaseEffect {
    @Override
    protected String getStackDescription(SpellAbility sa) {
        StringBuilder sb = new StringBuilder();
        int iDmg = AbilityUtils.calculateAmount(sa.getHostCard(), sa.getParam("NumDmg"), sa);
        String desc = sa.getParamOrDefault("ValidCards", "");
        if (sa.hasParam("ValidDescription")) {
            desc = sa.getParam("ValidDescription");
        }
        String dmg = "";
        dmg = sa.hasParam("DamageDesc") ? sa.getParam("DamageDesc") : dmg + iDmg + " damage";
        sb.append("Each ").append(desc).append(" deals ").append(dmg).append(" to ");
        sb.append(Lang.joinHomogenous(DamageEachEffect.getTargetEntities(sa))).append(".");
        return sb.toString();
    }

    @Override
    public void resolve(SpellAbility sa) {
        CardCollectionView sources;
        Card card = sa.getHostCard();
        Game game = card.getGame();
        String num = sa.getParamOrDefault("NumDmg", "X");
        if (sa.hasParam("DefinedDamagers")) {
            sources = AbilityUtils.getDefinedCards(card, sa.getParam("DefinedDamagers"), sa);
        } else {
            sources = game.getCardsIn(ZoneType.Battlefield);
            if (sa.hasParam("ValidCards")) {
                sources = CardLists.getValidCards((Iterable<Card>)sources, sa.getParam("ValidCards"), sa.getActivatingPlayer(), card, (CardTraitBase)sa);
            }
        }
        boolean usedDamageMap = true;
        CardDamageMap damageMap = sa.getDamageMap();
        CardDamageMap preventMap = sa.getPreventMap();
        GameEntityCounterTable counterTable = sa.getCounterTable();
        if (damageMap == null) {
            damageMap = new CardDamageMap();
            preventMap = new CardDamageMap();
            counterTable = new GameEntityCounterTable();
            usedDamageMap = false;
        }
        if (sa.hasParam("EachToItself")) {
            for (Card source : sources) {
                Card sourceLKI = game.getChangeZoneLKIInfo(source);
                int dmg = AbilityUtils.calculateAmount(source, num, sa);
                damageMap.put(sourceLKI, source, dmg);
            }
        } else if (sa.hasParam("ToEachOther")) {
            CardCollection targets = AbilityUtils.getDefinedCards(card, sa.getParam("ToEachOther"), sa);
            for (Card damager : targets) {
                for (Card c : targets) {
                    if (c.equals(damager)) continue;
                    Card sourceLKI = game.getChangeZoneLKIInfo(damager);
                    int dmg = AbilityUtils.calculateAmount(damager, num, sa);
                    damageMap.put(sourceLKI, c, dmg);
                }
            }
        } else {
            for (GameEntity ge : DamageEachEffect.getTargetEntities(sa)) {
                for (Card source : sources) {
                    Card sourceLKI = game.getChangeZoneLKIInfo(source);
                    int dmg = AbilityUtils.calculateAmount(source, num, sa);
                    if (ge instanceof Card) {
                        Card c = (Card)ge;
                        if (!c.isInPlay() || c.isPhasedOut()) continue;
                        damageMap.put(sourceLKI, c, dmg);
                        continue;
                    }
                    damageMap.put(sourceLKI, ge, dmg);
                }
            }
        }
        if (!usedDamageMap) {
            game.getAction().dealDamage(false, damageMap, preventMap, counterTable, sa);
        }
        DamageEachEffect.replaceDying(sa);
    }
}

