/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import forge.game.CardTraitBase;
import forge.game.Game;
import forge.game.GameEntity;
import forge.game.GameEntityCounterTable;
import forge.game.GameObject;
import forge.game.ability.AbilityKey;
import forge.game.ability.AbilityUtils;
import forge.game.ability.effects.DamageBaseEffect;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardDamageMap;
import forge.game.card.CardLists;
import forge.game.card.CardUtil;
import forge.game.keyword.Keyword;
import forge.game.player.Player;
import forge.game.player.PlayerCollection;
import forge.game.replacement.ReplacementType;
import forge.game.spellability.SpellAbility;
import forge.game.zone.ZoneType;
import forge.util.Aggregates;
import forge.util.Lang;
import forge.util.Localizer;
import forge.util.collect.FCollection;
import java.util.List;
import java.util.Map;

public class DamageDealEffect
extends DamageBaseEffect {
    @Override
    protected String getStackDescription(SpellAbility spellAbility) {
        StringBuilder stringBuilder = new StringBuilder();
        String damage = spellAbility.getParam("NumDmg");
        int dmg = AbilityUtils.calculateAmount(spellAbility.getHostCard(), damage, spellAbility);
        List<GameObject> targets = DamageDealEffect.getTargets(spellAbility);
        CardCollection definedSources = AbilityUtils.getDefinedCards(spellAbility.getHostCard(), spellAbility.getParam("DamageSource"), spellAbility);
        if (targets.isEmpty() || definedSources.isEmpty()) {
            return "";
        }
        stringBuilder.append(((Card)definedSources.get(0)).toString()).append(" deals").append(" ").append(dmg).append(" damage ");
        if (spellAbility.usesTargeting()) {
            Integer v;
            int i;
            if (spellAbility.hasParam("DivideEvenly")) {
                stringBuilder.append("divided evenly (rounded down) to \n");
            } else if (spellAbility.isDividedAsYouChoose()) {
                stringBuilder.append("divided to \n");
            } else {
                stringBuilder.append("to ");
            }
            CardCollection targetCards = DamageDealEffect.getTargetCards(spellAbility);
            PlayerCollection players = DamageDealEffect.getTargetPlayers(spellAbility);
            int targetCount = targetCards.size() + players.size();
            for (i = 0; i < targetCards.size(); ++i) {
                Card targetCard = (Card)targetCards.get(i);
                stringBuilder.append(targetCard);
                v = spellAbility.getDividedValue(targetCard);
                if (v != null) {
                    stringBuilder.append(" (").append(v).append(" damage)");
                }
                if (i == targetCount - 2) {
                    stringBuilder.append(" and ");
                    continue;
                }
                if (i + 1 >= targetCount) continue;
                stringBuilder.append(", ");
            }
            for (i = 0; i < players.size(); ++i) {
                Player targetPlayer = (Player)players.get(i);
                stringBuilder.append(targetPlayer);
                v = spellAbility.getDividedValue(targetPlayer);
                if (v != null) {
                    stringBuilder.append(" (").append(v).append(" damage)");
                }
                if (i == players.size() - 2) {
                    stringBuilder.append(" and ");
                    continue;
                }
                if (i + 1 >= players.size()) continue;
                stringBuilder.append(", ");
            }
        } else {
            if (spellAbility.hasParam("DivideEvenly")) {
                stringBuilder.append("divided evenly (rounded down) ");
            } else if (spellAbility.isDividedAsYouChoose()) {
                stringBuilder.append("divided as you choose ");
            }
            stringBuilder.append("to ").append(Lang.joinHomogenous(targets));
        }
        if (spellAbility.hasParam("Radiance")) {
            stringBuilder.append(" and each other ").append(spellAbility.getParam("ValidTgts")).append(" that shares a color with ");
            if (targets.size() > 1) {
                stringBuilder.append("them");
            } else {
                stringBuilder.append("it");
            }
        }
        stringBuilder.append(".");
        if (spellAbility.hasParam("ReplaceDyingDefined")) {
            String[] sentences;
            String statement = "If that creature would die this turn, exile it instead.";
            for (String s2 : sentences = spellAbility.getParamOrDefault("SpellDescription", "").split("\\.")) {
                if (!s2.contains("would die")) continue;
                statement = s2;
                break;
            }
            stringBuilder.append(" ").append(statement);
        }
        return stringBuilder.toString();
    }

    @Override
    public void resolve(SpellAbility sa) {
        String evenly;
        Player decider;
        Card hostCard = sa.getHostCard();
        Game game = hostCard.getGame();
        CardCollection definedSources = AbilityUtils.getDefinedCards(hostCard, sa.getParam("DamageSource"), sa);
        if (definedSources == null || definedSources.isEmpty()) {
            return;
        }
        for (Card source : definedSources) {
            game.getReplacementHandler().run(ReplacementType.AssignDealDamage, AbilityKey.mapFromAffected(source));
        }
        int dmg = AbilityUtils.calculateAmount(hostCard, sa.getParam("NumDmg"), sa);
        boolean removeDamage = sa.hasParam("Remove");
        boolean divideOnResolution = sa.hasParam("DividerOnResolution");
        List<Object> tgts = Lists.newArrayList();
        if (sa.hasParam("CardChoices") || sa.hasParam("PlayerChoices")) {
            int n;
            Player activator = sa.getActivatingPlayer();
            FCollection<GameEntity> choices = new FCollection<GameEntity>();
            if (sa.hasParam("CardChoices")) {
                choices.addAll(CardLists.getValidCards((Iterable<Card>)game.getCardsIn(ZoneType.Battlefield), sa.getParam("CardChoices"), activator, hostCard, (CardTraitBase)sa));
            }
            if (sa.hasParam("PlayerChoices")) {
                choices.addAll(AbilityUtils.getDefinedPlayers(hostCard, sa.getParam("PlayerChoices"), sa));
            }
            int n2 = n = sa.hasParam("ChoiceAmount") ? AbilityUtils.calculateAmount(hostCard, sa.getParam("ChoiceAmount"), sa) : 1;
            if (sa.hasParam("Random")) {
                for (int i = 0; i < n; ++i) {
                    GameEntity random = (GameEntity)Aggregates.random(choices);
                    tgts.add(random);
                    choices.remove(random);
                    hostCard.addRemembered(random);
                }
            } else {
                String prompt = sa.hasParam("ChoicePrompt") ? sa.getParam("ChoicePrompt") : Localizer.getInstance().getMessage("lblChooseEntityDmg", new Object[0]);
                tgts.addAll(activator.getController().chooseEntitiesForEffect(choices, n, n, null, sa, prompt, null, null));
            }
        } else {
            tgts = DamageDealEffect.getTargetEntities(sa);
        }
        if (sa.hasParam("OptionalDecider") && (decider = (Player)Iterables.getFirst(AbilityUtils.getDefinedPlayers(hostCard, sa.getParam("OptionalDecider"), sa), null)) != null && !decider.getController().confirmAction(sa, null, Localizer.getInstance().getMessage("lblDoyouWantDealTargetDamageToTarget", String.valueOf(dmg), tgts.toString()), null)) {
            return;
        }
        if (sa.hasParam("DivideEvenly") && (evenly = sa.getParam("DivideEvenly")).equals("RoundedDown")) {
            dmg = tgts.isEmpty() ? 0 : dmg / tgts.size();
        }
        CardCollection untargetedCards = CardUtil.getRadiance(sa);
        boolean usedDamageMap = true;
        CardDamageMap damageMap = sa.getDamageMap();
        CardDamageMap preventMap = sa.getPreventMap();
        GameEntityCounterTable counterTable = sa.getCounterTable();
        if (damageMap == null) {
            damageMap = new CardDamageMap();
            preventMap = new CardDamageMap();
            counterTable = new GameEntityCounterTable();
            usedDamageMap = false;
        }
        if (sa.hasParam("DamageMap")) {
            sa.setDamageMap(damageMap);
            sa.setPreventMap(preventMap);
            sa.setCounterTable(counterTable);
            usedDamageMap = true;
        }
        for (Card source : definedSources) {
            Card sourceLKI = hostCard.getGame().getChangeZoneLKIInfo(source);
            if (divideOnResolution) {
                PlayerCollection players = AbilityUtils.getDefinedPlayers(hostCard, sa.getParam("DividerOnResolution"), sa);
                if (players.isEmpty()) {
                    return;
                }
                CardCollection cardCollection = new CardCollection(Iterables.filter(tgts, Card.class));
                Player assigningPlayer = (Player)players.get(0);
                Map<Card, Integer> map = assigningPlayer.getController().assignCombatDamage(sourceLKI, cardCollection, null, dmg, null, true);
                for (Map.Entry<Card, Integer> dt : map.entrySet()) {
                    damageMap.put(sourceLKI, dt.getKey(), dt.getValue());
                }
                if (!usedDamageMap) {
                    game.getAction().dealDamage(false, damageMap, preventMap, counterTable, sa);
                }
                DamageDealEffect.replaceDying(sa);
                return;
            }
            if (sa.hasParam("RelativeTarget")) {
                tgts = AbilityUtils.getDefinedEntities(source, sa.getParam("Defined"), (CardTraitBase)sa);
            }
            for (GameEntity gameEntity : tgts) {
                if (!removeDamage && (dmg = sa.usesTargeting() && sa.isDividedAsYouChoose() ? sa.getDividedValue(gameEntity) : dmg) <= 0) continue;
                if (gameEntity instanceof Card) {
                    Card c = (Card)gameEntity;
                    Card gc = game.getCardState(c, null);
                    if (gc == null || !c.equalsWithGameTimestamp(gc) || !gc.isInPlay() || c.isPhasedOut()) continue;
                    this.internalDamageDeal(sa, sourceLKI, gc, dmg, damageMap);
                    continue;
                }
                if (!(gameEntity instanceof Player)) continue;
                Player p = (Player)gameEntity;
                damageMap.put(sourceLKI, p, dmg);
            }
            for (Card card : untargetedCards) {
                if (!card.isInPlay()) continue;
                this.internalDamageDeal(sa, sourceLKI, card, dmg, damageMap);
            }
        }
        if (!usedDamageMap) {
            game.getAction().dealDamage(false, damageMap, preventMap, counterTable, sa);
        }
        DamageDealEffect.replaceDying(sa);
    }

    protected void internalDamageDeal(SpellAbility sa, Card sourceLKI, Card c, int dmg, CardDamageMap damageMap) {
        Card hostCard = sa.getHostCard();
        Player activationPlayer = sa.getActivatingPlayer();
        int excess = 0;
        int dmgToTarget = 0;
        if (sa.hasParam("ExcessDamage")) {
            int lethal = c.getExcessDamageValue(sourceLKI.hasKeyword(Keyword.DEATHTOUCH));
            dmgToTarget = Math.min(lethal, dmg);
            excess = dmg - dmgToTarget;
        }
        if (sa.hasParam("Remove")) {
            c.setDamage(0);
            c.setHasBeenDealtDeathtouchDamage(false);
            c.clearAssignedDamage();
        } else if (sa.hasParam("ExcessDamage") && (!sa.hasParam("ExcessDamageCondition") || sourceLKI.isValid(sa.getParam("ExcessDamageCondition").split(","), activationPlayer, hostCard, (CardTraitBase)sa))) {
            damageMap.put(sourceLKI, c, dmgToTarget);
            FCollection<GameEntity> list = AbilityUtils.getDefinedEntities(hostCard, sa.getParam("ExcessDamage"), (CardTraitBase)sa);
            if (!list.isEmpty()) {
                damageMap.put(sourceLKI, (GameEntity)list.get(0), excess);
            }
            if (sa.hasParam("RememberRedirectedExcess")) {
                hostCard.addRemembered(excess);
            }
        } else {
            damageMap.put(sourceLKI, c, dmg);
        }
    }
}

