/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import forge.game.Game;
import forge.game.GameEntityCounterTable;
import forge.game.ability.AbilityUtils;
import forge.game.ability.effects.DamageBaseEffect;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardCollectionView;
import forge.game.card.CardDamageMap;
import forge.game.card.CardLists;
import forge.game.player.Player;
import forge.game.spellability.AbilitySub;
import forge.game.spellability.SpellAbility;
import forge.game.zone.ZoneType;

public class DamageAllEffect
extends DamageBaseEffect {
    @Override
    protected String getStackDescription(SpellAbility sa) {
        StringBuilder sb = new StringBuilder();
        String desc = sa.getParamOrDefault("ValidDescription", sa.getParamOrDefault("ValidCards", "something"));
        String damage = sa.getParam("NumDmg");
        int dmg = AbilityUtils.calculateAmount(sa.getHostCard(), damage, sa);
        String definedStr = sa.getParam("DamageSource");
        CardCollection definedSources = AbilityUtils.getDefinedCards(sa.getHostCard(), definedStr, sa);
        if (!definedSources.isEmpty() && (definedSources.get(0) != sa.getHostCard() || sa instanceof AbilitySub)) {
            sb.append(((Card)definedSources.get(0)).toString()).append(" deals");
        } else if ("ParentTarget".equals(definedStr)) {
            sb.append("Target creature deals");
        } else {
            sb.append("Deals");
        }
        sb.append(" ").append(dmg).append(" damage to ").append(desc).append(desc.endsWith(".") ? "" : ".");
        return sb.toString();
    }

    @Override
    public void resolve(SpellAbility sa) {
        Card source = sa.getHostCard();
        CardCollection definedSources = AbilityUtils.getDefinedCards(source, sa.getParam("DamageSource"), sa);
        Card card = (Card)definedSources.get(0);
        Card sourceLKI = card.getGame().getChangeZoneLKIInfo(card);
        Game game = sa.getActivatingPlayer().getGame();
        int dmg = AbilityUtils.calculateAmount(source, sa.getParam("NumDmg"), sa);
        Player targetPlayer = sa.getTargets().getFirstTargetedPlayer();
        String players = sa.getParam("ValidPlayers");
        CardCollectionView list = sa.hasParam("ValidCards") ? game.getCardsIn(ZoneType.Battlefield) : CardCollection.EMPTY;
        if (targetPlayer != null) {
            list = CardLists.filterControlledBy((Iterable<Card>)list, targetPlayer);
        }
        list = AbilityUtils.filterListByType(list, sa.getParam("ValidCards"), sa);
        boolean usedDamageMap = true;
        CardDamageMap damageMap = sa.getDamageMap();
        CardDamageMap preventMap = sa.getPreventMap();
        GameEntityCounterTable counterTable = sa.getCounterTable();
        if (damageMap == null) {
            damageMap = new CardDamageMap();
            preventMap = new CardDamageMap();
            counterTable = new GameEntityCounterTable();
            usedDamageMap = false;
        }
        for (Card c : list) {
            damageMap.put(sourceLKI, c, dmg);
        }
        if (players != null) {
            for (Player p : AbilityUtils.getDefinedPlayers(card, players, sa)) {
                damageMap.put(sourceLKI, p, dmg);
            }
        }
        if (!usedDamageMap) {
            game.getAction().dealDamage(false, damageMap, preventMap, counterTable, sa);
        }
        DamageAllEffect.replaceDying(sa);
    }
}

