/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import com.google.common.base.Optional;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import forge.game.CardTraitBase;
import forge.game.Game;
import forge.game.GameEntity;
import forge.game.GameEntityCounterTable;
import forge.game.ability.AbilityFactory;
import forge.game.ability.AbilityKey;
import forge.game.ability.AbilityUtils;
import forge.game.ability.SpellAbilityEffect;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardCollectionView;
import forge.game.card.CardCopyService;
import forge.game.card.CardFactoryUtil;
import forge.game.card.CardLists;
import forge.game.card.CounterEnumType;
import forge.game.card.CounterType;
import forge.game.event.GameEventRandomLog;
import forge.game.keyword.Keyword;
import forge.game.player.Player;
import forge.game.player.PlayerActionConfirmMode;
import forge.game.player.PlayerCollection;
import forge.game.player.PlayerController;
import forge.game.spellability.SpellAbility;
import forge.game.staticability.StaticAbilityAdapt;
import forge.game.trigger.Trigger;
import forge.game.trigger.TriggerHandler;
import forge.game.trigger.TriggerType;
import forge.game.zone.ZoneType;
import forge.util.Aggregates;
import forge.util.CardTranslation;
import forge.util.Lang;
import forge.util.Localizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class CountersPutEffect
extends SpellAbilityEffect {
    @Override
    protected String getStackDescription(SpellAbility sa) {
        CardCollection targetCards;
        StringBuilder stringBuilder = new StringBuilder();
        Card card = sa.getHostCard();
        String who = sa.getActivatingPlayer().getName();
        boolean pronoun = false;
        if (sa.hasParam("IfDesc")) {
            String ifD = sa.getParam("IfDesc");
            if (ifD.equals("True")) {
                String ifDesc = sa.getDescription();
                if (ifDesc.contains(",")) {
                    if (ifDesc.contains(" you ")) {
                        ifDesc = ifDesc.replaceFirst(" you ", " " + who + " ");
                        pronoun = true;
                        if (ifDesc.contains(" you ")) {
                            ifDesc = ifDesc.replaceAll(" you ", " they ");
                        }
                        if (ifDesc.contains(" your ")) {
                            ifDesc = ifDesc.replaceAll(" your ", " their ");
                        }
                    }
                    stringBuilder.append(ifDesc, 0, ifDesc.indexOf(",") + 1);
                } else {
                    stringBuilder.append("[CountersPutEffect IfDesc parsing error]");
                }
            } else {
                stringBuilder.append(ifD);
            }
            stringBuilder.append(" ");
        }
        stringBuilder.append(pronoun ? "they" : who).append(" ");
        String typeName = sa.hasParam("CounterType") ? CounterType.getType(sa.getParam("CounterType")).getName().toLowerCase() : "";
        List<String> playerCounters = Arrays.asList("energy", "experience", "poison", "ticket");
        if (playerCounters.contains(typeName)) {
            stringBuilder.append(pronoun ? "get " : "gets ");
            stringBuilder.append(Lang.nounWithNumeralExceptOne(AbilityUtils.calculateAmount(card, sa.getParamOrDefault("CounterNum", "1"), sa), typeName + " counter"));
            stringBuilder.append(".");
            return stringBuilder.toString();
        }
        String desc = sa.getDescription();
        boolean forEach = desc.contains("for each");
        if (sa.hasParam("CounterTypes")) {
            if (desc.contains("Put ") && desc.contains(" on ")) {
                desc = desc.substring(desc.indexOf("Put "), desc.indexOf(" on ") + 4).replaceFirst("Put ", "puts ");
            }
            stringBuilder.append(desc).append(Lang.joinHomogenous(CountersPutEffect.getTargets(sa))).append(".");
            return stringBuilder.toString();
        }
        if (sa.usesTargeting() && (targetCards = CountersPutEffect.getTargetCards(sa)).isEmpty()) {
            return stringBuilder.toString();
        }
        int amount = AbilityUtils.calculateAmount(card, sa.getParamOrDefault("CounterNum", "1"), sa);
        if (sa.hasParam("Bolster")) {
            stringBuilder.append("bolsters ").append(amount).append(".");
            return stringBuilder.toString();
        }
        boolean divAsChoose = sa.isDividedAsYouChoose();
        boolean divRandom = sa.hasParam("DividedRandomly");
        if (divAsChoose) {
            stringBuilder.append(pronoun ? "distribute " : "distributes ");
        } else if (divRandom) {
            stringBuilder.append(pronoun ? "randomly distribute " : "randomly distributes ");
        } else {
            stringBuilder.append(pronoun ? "put " : "puts ");
        }
        if (sa.hasParam("UpTo")) {
            stringBuilder.append("up to ");
        }
        stringBuilder.append(Lang.nounWithNumeralExceptOne(amount, typeName + " counter"));
        stringBuilder.append(divAsChoose || divRandom ? " among " : " on ");
        if (sa.hasParam("Defined") && sa.getParam("Defined").contains(" & ")) {
            String[] def = sa.getParam("Defined").split(" & ");
            for (int i = 0; i < def.length; ++i) {
                stringBuilder.append(AbilityUtils.getDefinedEntities(card, def[i], (CardTraitBase)sa).toString().replaceAll("[\\[\\]]", ""));
                if (i + 1 >= def.length) continue;
                stringBuilder.append(" and ");
                stringBuilder.append(Lang.nounWithNumeralExceptOne(amount, typeName + " counter")).append(" on ");
            }
        } else if (sa.usesTargeting()) {
            CardCollection targetCards2 = CountersPutEffect.getTargetCards(sa);
            for (int i = 0; i < targetCards2.size(); ++i) {
                Card targetCard = (Card)targetCards2.get(i);
                stringBuilder.append(targetCard);
                Integer v = sa.getDividedValue(targetCard);
                if (v != null) {
                    stringBuilder.append(" (").append(v).append(v == 1 ? " counter)" : " counters)");
                }
                if (i == targetCards2.size() - 2) {
                    stringBuilder.append(" and ");
                    continue;
                }
                if (i + 1 >= targetCards2.size()) continue;
                stringBuilder.append(", ");
            }
        } else if (sa.hasParam("Choices")) {
            int n = AbilityUtils.calculateAmount(card, sa.getParamOrDefault("ChoiceAmount", "1"), sa);
            String what = sa.getParamOrDefault("ChoicesDesc", sa.getParam("Choices"));
            stringBuilder.append(Lang.nounWithNumeralExceptOne(n, what));
        } else {
            CardCollection targetCards3 = CountersPutEffect.getTargetCards(sa);
            Iterator it = targetCards3.iterator();
            while (it.hasNext()) {
                Card targetCard = (Card)it.next();
                if (targetCard.isFaceDown()) {
                    stringBuilder.append("Morph");
                } else {
                    stringBuilder.append(targetCard);
                }
                if (!it.hasNext()) continue;
                stringBuilder.append(", ");
            }
        }
        stringBuilder.append(forEach ? desc.substring(desc.indexOf(" for each")) : ".");
        return stringBuilder.toString();
    }

    /*
     * WARNING - void declaration
     */
    protected void resolvePerType(SpellAbility sa, Player placer, CounterType counterType, int counterAmount, GameEntityCounterTable table, boolean stopForTypes) {
        Card tgtCard;
        Object choices;
        Card card = sa.getHostCard();
        Game game = card.getGame();
        Player activator = sa.getActivatingPlayer();
        PlayerController pc = activator.getController();
        boolean etbcounter = sa.hasParam("ETB");
        boolean existingCounter = sa.hasParam("CounterType") && sa.getParam("CounterType").equals("ExistingCounter");
        boolean eachExistingCounter = sa.hasParam("EachExistingCounter");
        boolean putOnEachOther = sa.hasParam("PutOnEachOther");
        boolean putOnDefined = sa.hasParam("PutOnDefined");
        if (sa.hasParam("Optional") && !pc.confirmAction(sa, null, Localizer.getInstance().getMessage("lblDoYouWantPutCounter", new Object[0]), null)) {
            return;
        }
        ArrayList<GameEntity> tgtObjects = Lists.newArrayList();
        int divrem = 0;
        if (sa.hasParam("Bolster")) {
            CardCollection creatsYouCtrl = activator.getCreaturesInPlay();
            CardCollection leastToughness = new CardCollection((Iterable<Card>)Aggregates.listWithMin(creatsYouCtrl, Card::getNetToughness));
            HashMap<String, Object> params = Maps.newHashMap();
            params.put("CounterType", counterType);
            Iterables.addAll(tgtObjects, activator.getController().chooseCardsForEffect(leastToughness, sa, Localizer.getInstance().getMessage("lblChooseACreatureWithLeastToughness", new Object[0]), 1, 1, false, params));
        } else if (sa.hasParam("Choices") && (counterType != null || putOnEachOther || putOnDefined)) {
            ZoneType choiceZone = ZoneType.Battlefield;
            if (sa.hasParam("ChoiceZone")) {
                choiceZone = ZoneType.smartValueOf(sa.getParam("ChoiceZone"));
            }
            Player chooser = activator;
            if (sa.hasParam("Chooser")) {
                PlayerCollection choosers = AbilityUtils.getDefinedPlayers(card, sa.getParam("Chooser"), sa);
                if (choosers.isEmpty()) {
                    return;
                }
                chooser = (Player)choosers.get(0);
            }
            int n = AbilityUtils.calculateAmount(card, sa.getParamOrDefault("ChoiceAmount", "1"), sa);
            int m4 = AbilityUtils.calculateAmount(card, sa.getParamOrDefault("MinChoiceAmount", sa.getParamOrDefault("ChoiceAmount", "1")), sa);
            if (n <= 0) {
                return;
            }
            choices = CardLists.getValidCards((Iterable<Card>)game.getCardsIn(choiceZone), sa.getParam("Choices"), activator, card, (CardTraitBase)sa);
            String title = Localizer.getInstance().getMessage("lblChooseaCard", new Object[0]) + " ";
            if (sa.hasParam("ChoiceTitle")) {
                title = sa.getParam("ChoiceTitle");
            }
            if ((sa.hasParam("ChoiceTitle") || sa.hasParam("SpecifyCounter")) && counterType != null) {
                title = title + " (" + counterType.getName() + ")";
            } else if (putOnEachOther || putOnDefined) {
                title = title + Localizer.getInstance().getMessage("lblWithKindCounter", new Object[0]);
                if (putOnEachOther) {
                    title = title + " " + Localizer.getInstance().getMessage("lblEachOther", new Object[0]);
                }
            }
            HashMap<String, Object> hashMap = Maps.newHashMap();
            if (counterType != null) {
                hashMap.put("CounterType", counterType);
            }
            if (sa.hasParam("DividedRandomly")) {
                tgtObjects.addAll((Collection<GameEntity>)choices);
            } else {
                Iterables.addAll(tgtObjects, chooser.getController().chooseCardsForEffect((CardCollectionView)choices, sa, title, m4, n, sa.hasParam("ChoiceOptional"), hashMap));
            }
        } else {
            tgtObjects.addAll(CountersPutEffect.getDefinedEntitiesOrTargeted(sa, "Defined"));
        }
        int counterRemain = counterAmount;
        if (sa.hasParam("DividedRandomly")) {
            CardCollection targets = new CardCollection();
            for (GameEntity obj : tgtObjects) {
                if (obj instanceof Card) {
                    tgtCard = (Card)obj;
                    Card gameCard = game.getCardState(tgtCard, null);
                    if (gameCard == null || !tgtCard.equalsWithGameTimestamp(gameCard)) {
                        tgtObjects.remove(obj);
                        continue;
                    }
                    targets.add(gameCard);
                    continue;
                }
                tgtObjects.remove(obj);
            }
            if (tgtObjects.size() == 0) {
                return;
            }
            HashMap<Object, Integer> randomMap = Maps.newHashMap();
            for (int i = 0; i < counterRemain; ++i) {
                Card found = Aggregates.random(targets);
                found.addCounter(counterType, 1, placer, table);
                if (randomMap.containsKey(found)) {
                    int oN = (Integer)randomMap.get(found);
                    int n = oN + 1;
                    randomMap.replace(found, oN, n);
                    continue;
                }
                randomMap.put(found, 1);
            }
            game.fireEvent(new GameEventRandomLog(this.logOutput(randomMap, card)));
        } else {
            for (GameEntity obj : tgtObjects) {
                HashMap<String, Object> params;
                Object types;
                GameEntityCounterTable etbTable;
                Card gameCard = null;
                if (obj instanceof Card && ((gameCard = game.getCardState(tgtCard = (Card)obj, null)) == null || !tgtCard.equalsWithGameTimestamp(gameCard))) continue;
                if (sa.hasParam("ChooseDifferent")) {
                    int num = Integer.parseInt(sa.getParam("ChooseDifferent"));
                    ArrayList<CounterType> typesToAdd = Lists.newArrayList();
                    String string = sa.getParam("CounterType");
                    for (int i = 0; i < num; ++i) {
                        void var24_40;
                        CounterType ct = this.chooseTypeFromList(sa, (String)var24_40, obj, pc);
                        typesToAdd.add(ct);
                        String string2 = var24_40.replace(ct.getName(), "");
                    }
                    for (CounterType ct : typesToAdd) {
                        if (obj instanceof Player) {
                            ((Player)obj).addCounter(ct, counterAmount, placer, table);
                        }
                        if (!(obj instanceof Card)) continue;
                        if (etbcounter) {
                            etbTable = (GameEntityCounterTable)sa.getReplacingObject(AbilityKey.CounterTable);
                            etbTable.put(placer, gameCard, ct, counterAmount);
                            continue;
                        }
                        gameCard.addCounter(ct, counterAmount, placer, table);
                    }
                    continue;
                }
                if (stopForTypes && sa.hasParam("CounterTypes")) {
                    ArrayList<CounterType> typesToAdd = Lists.newArrayList();
                    types = sa.getParam("CounterTypes");
                    if (((String)types).contains("ChosenFromList")) {
                        typesToAdd.add(this.chooseTypeFromList(sa, sa.getParam("TypeList"), obj, pc));
                        types = ((String)types).replace("ChosenFromList", "");
                    }
                    for (String type : ((String)types).split(",")) {
                        if (type.contains("EachType")) {
                            CardCollection counterCards = CardLists.getValidCards((Iterable<Card>)game.getCardsIn(ZoneType.Battlefield), type.split("_")[1], activator, card, (CardTraitBase)sa);
                            ArrayList<CounterType> counterTypes = Lists.newArrayList();
                            for (Card c : counterCards) {
                                for (Map.Entry<CounterType, Integer> map : c.getCounters().entrySet()) {
                                    if (counterTypes.contains(map.getKey())) continue;
                                    counterTypes.add(map.getKey());
                                }
                            }
                            for (CounterType ct : counterTypes) {
                                if (sa.hasParam("AltChoiceForEach")) {
                                    String typeChoices = sa.getParam("AltChoiceForEach") + "," + ct.toString();
                                    ct = this.chooseTypeFromList(sa, typeChoices, obj, pc);
                                }
                                this.resolvePerType(sa, placer, ct, counterAmount, table, false);
                            }
                            continue;
                        }
                        typesToAdd.add(CounterType.getType(type));
                    }
                    int n = counterAmount;
                    for (CounterType ct : typesToAdd) {
                        if (sa.hasParam("SplitAmount")) {
                            void var24_44;
                            if (typesToAdd.size() - typesToAdd.indexOf(ct) > 1) {
                                HashMap<String, Object> params2 = Maps.newHashMap();
                                params2.put("Target", obj);
                                params2.put("CounterType", counterType);
                                counterAmount = pc.chooseNumber(sa, ct.toString() + ": " + Localizer.getInstance().getMessage("lblHowManyCounters", new Object[0]), 0, (int)var24_44, params2);
                                if (counterAmount == 0) continue;
                                var24_44 -= counterAmount;
                            } else {
                                counterAmount = var24_44;
                            }
                        }
                        if (obj instanceof Player) {
                            ((Player)obj).addCounter(ct, counterAmount, placer, table);
                        }
                        if (!(obj instanceof Card)) continue;
                        if (etbcounter) {
                            etbTable = (GameEntityCounterTable)sa.getReplacingObject(AbilityKey.CounterTable);
                            etbTable.put(placer, gameCard, ct, counterAmount);
                            continue;
                        }
                        gameCard.addCounter(ct, counterAmount, placer, table);
                    }
                    continue;
                }
                if (existingCounter) {
                    choices = Lists.newArrayList();
                    for (CounterType counterType2 : obj.getCounters().keySet()) {
                        if (!obj.canReceiveCounters(counterType2) && !putOnEachOther) continue;
                        choices.add(counterType2);
                    }
                    if (eachExistingCounter) {
                        types = choices.iterator();
                        while (types.hasNext()) {
                            CounterType counterType3 = (CounterType)types.next();
                            if (obj instanceof Player) {
                                ((Player)obj).addCounter(counterType3, counterAmount, placer, table);
                            }
                            if (!(obj instanceof Card)) continue;
                            gameCard.addCounter(counterType3, counterAmount, placer, table);
                        }
                        continue;
                    }
                    if (choices.isEmpty()) continue;
                    if (choices.size() == 1) {
                        counterType = (CounterType)choices.get(0);
                    } else {
                        params = Maps.newHashMap();
                        params.put("Target", obj);
                        String string = Localizer.getInstance().getMessage("lblSelectCounterTypeAddTo", new Object[0]) + " " + (putOnEachOther ? Localizer.getInstance().getMessage("lblEachOther", new Object[0]) : obj);
                        counterType = pc.chooseCounterType((List<CounterType>)choices, sa, string, params);
                    }
                    if (putOnEachOther) {
                        CardCollection others = CardLists.getValidCards((Iterable<Card>)game.getCardsIn(ZoneType.Battlefield), sa.getParam("PutOnEachOther"), activator, card, (CardTraitBase)sa);
                        for (Card other : others) {
                            if (other.equals(obj)) continue;
                            Card otherGCard = game.getCardState(other, null);
                            otherGCard.addCounter(counterType, counterAmount, placer, table);
                        }
                        continue;
                    }
                    if (putOnDefined) {
                        CardCollection defs = AbilityUtils.getDefinedCards(card, sa.getParam("PutOnDefined"), sa);
                        for (Card c : defs) {
                            Card gCard = game.getCardState(c, null);
                            if (sa.hasParam("OnlyNewKind") && gCard.getCounters(counterType) >= 1) continue;
                            gCard.addCounter(counterType, counterAmount, placer, table);
                        }
                        continue;
                    }
                }
                if (sa.hasParam("EachFromSource")) {
                    for (Card c : AbilityUtils.getDefinedCards(card, sa.getParam("EachFromSource"), sa)) {
                        for (Map.Entry<CounterType, Integer> cti : c.getCounters().entrySet()) {
                            if (gameCard == null) continue;
                            if (!sa.hasParam("CounterNum")) {
                                counterAmount = cti.getValue();
                            }
                            if (etbcounter) {
                                GameEntityCounterTable etbTable2 = (GameEntityCounterTable)sa.getReplacingObject(AbilityKey.CounterTable);
                                etbTable2.put(placer, gameCard, cti.getKey(), counterAmount);
                                continue;
                            }
                            gameCard.addCounter(cti.getKey(), counterAmount, placer, table);
                        }
                    }
                    continue;
                }
                if ((sa.hasParam("CounterTypePerDefined") || sa.hasParam("UniqueType")) && (counterType = this.chooseTypeFromList(sa, sa.getParam("CounterType"), obj, pc)) == null) continue;
                if (obj instanceof Card) {
                    if (sa.hasParam("CounterNumPerDefined")) {
                        counterAmount = AbilityUtils.calculateAmount(gameCard, sa.getParam("CounterNumPerDefined"), sa);
                    }
                    int n = counterAmount = sa.usesTargeting() && sa.isDividedAsYouChoose() ? sa.getDividedValue(gameCard) : counterAmount;
                    if (sa.hasParam("UpTo")) {
                        int min2 = AbilityUtils.calculateAmount(card, sa.getParamOrDefault("UpToMin", "0"), sa);
                        params = Maps.newHashMap();
                        params.put("Target", obj);
                        params.put("CounterType", counterType);
                        counterAmount = pc.chooseNumber(sa, Localizer.getInstance().getMessage("lblHowManyCounters", new Object[0]), min2, counterAmount, params);
                    }
                    if (sa.isDividedAsYouChoose() && !sa.usesTargeting()) {
                        HashMap<String, Object> params3 = Maps.newHashMap();
                        params3.put("Target", obj);
                        params3.put("CounterType", counterType);
                        counterAmount = ++divrem == tgtObjects.size() || counterRemain == 1 ? counterRemain : pc.chooseNumber(sa, Localizer.getInstance().getMessage("lblHowManyCountersThis", CardTranslation.getTranslatedName(gameCard.getName())), 1, counterRemain, params3);
                    }
                    if (sa.hasParam("Adapt") && gameCard.getCounters(CounterEnumType.P1P1) != 0 && !StaticAbilityAdapt.anyWithAdapt(sa, gameCard)) continue;
                    if (sa.isKeyword(Keyword.TRIBUTE)) {
                        Card noTributeLKI = CardCopyService.getLKICopy(gameCard);
                        noTributeLKI.setLastKnownZone(activator.getZone(ZoneType.Battlefield));
                        game.getTracker().freeze();
                        CardCollection preList = new CardCollection(noTributeLKI);
                        game.getAction().checkStaticAbilities(false, Sets.newHashSet(noTributeLKI), preList);
                        boolean bl = !noTributeLKI.canReceiveCounters(counterType);
                        game.getAction().checkStaticAbilities(false);
                        game.getTracker().clearDelayed();
                        game.getTracker().unfreeze();
                        if (bl) continue;
                        HashMap<String, Object> params4 = Maps.newHashMap();
                        params4.put("CounterType", counterType);
                        params4.put("Amount", counterAmount);
                        params4.put("Target", gameCard);
                        String message = Localizer.getInstance().getMessage("lblDoYouWantPutTargetP1P1CountersOnCard", String.valueOf(counterAmount), CardTranslation.getTranslatedName(gameCard.getName()));
                        placer = pc.chooseSingleEntityForEffect(activator.getOpponents(), sa, Localizer.getInstance().getMessage("lblChooseAnOpponent", new Object[0]), params4);
                        if (!placer.getController().confirmAction(sa, PlayerActionConfirmMode.Tribute, message, null)) continue;
                        gameCard.setTributed(true);
                    }
                    if (etbcounter) {
                        GameEntityCounterTable etbTable3 = (GameEntityCounterTable)sa.getReplacingObject(AbilityKey.CounterTable);
                        etbTable3.put(placer, gameCard, counterType, counterAmount);
                    } else {
                        gameCard.addCounter(counterType, counterAmount, placer, table);
                    }
                    if (sa.hasParam("Monstrosity")) {
                        gameCard.setMonstrous(true);
                        Map<AbilityKey, Object> runParams = AbilityKey.mapFromCard(gameCard);
                        runParams.put(AbilityKey.MonstrosityAmount, counterAmount);
                        game.getTriggerHandler().runTrigger(TriggerType.BecomeMonstrous, runParams, false);
                    }
                    if (sa.isKeyword(Keyword.RENOWN)) {
                        gameCard.setRenowned(true);
                        game.getTriggerHandler().runTrigger(TriggerType.BecomeRenowned, AbilityKey.mapFromCard(gameCard), false);
                    }
                    if (sa.hasParam("Adapt")) {
                        game.getTriggerHandler().runTrigger(TriggerType.Adapt, AbilityKey.mapFromCard(gameCard), false);
                    }
                    if (sa.isKeyword(Keyword.MENTOR)) {
                        Map<AbilityKey, Object> runParams = AbilityKey.mapFromCard(gameCard);
                        runParams.put(AbilityKey.Source, sa.getHostCard());
                        game.getTriggerHandler().runTrigger(TriggerType.Mentored, runParams, false);
                    }
                    game.updateLastStateForCard(gameCard);
                    if (!sa.isDividedAsYouChoose() || sa.usesTargeting()) continue;
                    counterRemain -= counterAmount;
                    continue;
                }
                if (!(obj instanceof Player)) continue;
                Player pl = (Player)obj;
                pl.addCounter(counterType, counterAmount, placer, table);
            }
        }
    }

    @Override
    public void resolve(SpellAbility sa) {
        Card card = sa.getHostCard();
        Game game = card.getGame();
        Player activator = sa.getActivatingPlayer();
        String amount = sa.getParamOrDefault("CounterNum", "1");
        boolean rememberAmount = sa.hasParam("RememberAmount");
        Player placer = activator;
        if (sa.hasParam("Placer")) {
            String pstr = sa.getParam("Placer");
            placer = (Player)AbilityUtils.getDefinedPlayers(card, pstr, sa).get(false);
        }
        int counterAmount = AbilityUtils.calculateAmount(card, amount, sa);
        GameEntityCounterTable table = new GameEntityCounterTable();
        if (sa.hasParam("TriggeredCounterMap")) {
            Integer counterMapValue = null;
            if (sa.hasParam("CounterMapValues")) {
                counterMapValue = Integer.valueOf(sa.getParam("CounterMapValues"));
            }
            Map counterMap = (Map)sa.getTriggeringObject(AbilityKey.CounterMap);
            for (Map.Entry e : counterMap.entrySet()) {
                this.resolvePerType(sa, placer, (CounterType)e.getKey(), counterMapValue == null ? (Integer)e.getValue() : counterMapValue, table, false);
            }
        } else if (sa.hasParam("SharedKeywords")) {
            List<String> keywords = Arrays.asList(sa.getParam("SharedKeywords").split(" & "));
            if (sa.hasParam("SharedKeywordsDefined")) {
                CardCollection def = CountersPutEffect.getDefinedCardsOrTargeted(sa, "SharedKeywordsDefined");
                keywords = CardFactoryUtil.getSharedKeywords(keywords, def);
            } else {
                String[] stringArray;
                List<ZoneType> zones = ZoneType.listValueOf(sa.getParam("SharedKeywordsZone"));
                if (sa.hasParam("SharedRestrictions")) {
                    stringArray = sa.getParam("SharedRestrictions").split(",");
                } else {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = "Card";
                }
                String[] restrictions = stringArray;
                keywords = CardFactoryUtil.sharedKeywords(keywords, restrictions, (Iterable<ZoneType>)zones, card, sa);
            }
            for (String k : keywords) {
                this.resolvePerType(sa, placer, CounterType.getType(k), counterAmount, table, false);
            }
        } else {
            CounterType counterType = null;
            if (!(sa.hasParam("EachExistingCounter") || sa.hasParam("EachFromSource") || sa.hasParam("UniqueType") || sa.hasParam("CounterTypePerDefined") || sa.hasParam("CounterTypes") || sa.hasParam("ChooseDifferent") || sa.hasParam("PutOnEachOther") || sa.hasParam("PutOnDefined"))) {
                try {
                    counterType = this.chooseTypeFromList(sa, sa.getParam("CounterType"), null, placer.getController());
                }
                catch (Exception e) {
                    System.out.println("Counter type doesn't match, nor does an SVar exist with the type name.");
                    return;
                }
            }
            this.resolvePerType(sa, placer, counterType, counterAmount, table, true);
        }
        table.replaceCounterEffect(game, sa, true);
        int totalAdded = table.totalValues();
        if (totalAdded > 0 && rememberAmount) {
            card.addRemembered(totalAdded);
        }
        if (sa.hasParam("RemovePhase")) {
            for (Map.Entry e : table.row(Optional.of(placer)).entrySet()) {
                for (Map.Entry ce : ((Map)e.getValue()).entrySet()) {
                    this.addRemovePhaseTrigger(card, sa, sa.getParam("RemovePhase"), (GameEntity)e.getKey(), (CounterType)ce.getKey(), (Integer)ce.getValue());
                }
            }
        }
        if (sa.hasParam("RememberCards")) {
            card.addRemembered(table.columnKeySet());
        }
    }

    protected void addRemovePhaseTrigger(Card host, SpellAbility sa, String phase, GameEntity tgt, CounterType ct, int added) {
        boolean intrinsic = sa.isIntrinsic();
        StringBuilder delTrig = new StringBuilder("Mode$ Phase | Phase$ ");
        delTrig.append(phase);
        delTrig.append(" | TriggerDescription$ For each ").append(ct.getName()).append(" counter you put on a creature this way, remove a ").append(ct.getName()).append(" counter from that creature at the beginning of the next");
        if ("Cleanup".equals(phase)) {
            delTrig.append("cleanup step");
        } else if ("End of Turn".equals(phase)) {
            delTrig.append("next end step");
        }
        String trigSA = "DB$ RemoveCounter | Defined$ DelayTriggerRemembered | CounterNum$ 1 | CounterType$ " + ct;
        for (int i = 0; i < added; ++i) {
            Trigger trig = TriggerHandler.parseTrigger(delTrig.toString(), host, intrinsic);
            trig.addRemembered(tgt);
            SpellAbility newSa = AbilityFactory.getAbility(trigSA, host);
            newSa.setIntrinsic(intrinsic);
            trig.setOverridingAbility(newSa);
            trig.setSpawningAbility(sa.copy(host, true));
            sa.getActivatingPlayer().getGame().getTriggerHandler().registerDelayedTrigger(trig);
        }
    }

    protected CounterType chooseTypeFromList(SpellAbility sa, String list, GameEntity obj, PlayerController pc) {
        ArrayList<CounterType> choices = Lists.newArrayList();
        for (String s2 : list.split(",")) {
            CounterType type;
            if (s2.isEmpty() || sa.hasParam("UniqueType") && obj.getCounters(CounterType.getType(s2)) != 0 || choices.contains(type = CounterType.getType(s2))) continue;
            choices.add(type);
        }
        if (sa.hasParam("RandomType")) {
            return (CounterType)Aggregates.random(choices);
        }
        HashMap<String, Object> params = Maps.newHashMap();
        params.put("Target", obj);
        StringBuilder sb = new StringBuilder();
        if (obj != null) {
            sb.append(Localizer.getInstance().getMessage("lblSelectCounterTypeAddTo", new Object[0])).append(" ").append(obj);
        } else {
            sb.append(Localizer.getInstance().getMessage("lblSelectCounterType", new Object[0]));
        }
        return pc.chooseCounterType(choices, sa, sb.toString(), params);
    }

    protected String logOutput(Map<Object, Integer> randomMap, Card card) {
        StringBuilder randomLog = new StringBuilder();
        randomLog.append(card.getName()).append(" randomly distributed ");
        if (randomMap.entrySet().size() == 0) {
            randomLog.append("no counters.");
        } else {
            randomLog.append("counters: ");
            int count = 0;
            for (Map.Entry<Object, Integer> e : randomMap.entrySet()) {
                randomLog.append(e.getKey()).append(" (").append(e.getValue()).append(" counter");
                randomLog.append(e.getValue() != 1 ? "s" : "").append(")");
                randomLog.append(++count == randomMap.entrySet().size() ? "" : ", ");
            }
        }
        return randomLog.toString();
    }
}

