/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import forge.game.Game;
import forge.game.GameEntity;
import forge.game.GameEntityCounterTable;
import forge.game.ability.AbilityKey;
import forge.game.ability.AbilityUtils;
import forge.game.ability.SpellAbilityEffect;
import forge.game.card.Card;
import forge.game.card.CardLists;
import forge.game.card.CardPredicates;
import forge.game.card.CounterType;
import forge.game.player.Player;
import forge.game.player.PlayerController;
import forge.game.player.PlayerPredicates;
import forge.game.replacement.ReplacementType;
import forge.game.spellability.SpellAbility;
import forge.game.trigger.TriggerType;
import forge.game.zone.ZoneType;
import forge.util.Localizer;
import forge.util.collect.FCollection;
import java.util.List;
import java.util.Map;

public class CountersProliferateEffect
extends SpellAbilityEffect {
    @Override
    protected String getStackDescription(SpellAbility sa) {
        StringBuilder sb = new StringBuilder();
        sb.append("Proliferate.");
        sb.append(" (Choose any number of permanents and/or players,");
        sb.append(" then give each another counter of each kind already there.)");
        return sb.toString();
    }

    @Override
    public void resolve(SpellAbility sa) {
        Player p = sa.getActivatingPlayer();
        Card host = sa.getHostCard();
        Game game = host.getGame();
        int num = sa.hasParam("Amount") ? AbilityUtils.calculateAmount(host, sa.getParam("Amount"), sa) : 1;
        Map<AbilityKey, Object> repParams = AbilityKey.mapFromAffected(p);
        repParams.put(AbilityKey.Source, sa);
        repParams.put(AbilityKey.Num, num);
        switch (game.getReplacementHandler().run(ReplacementType.Proliferate, repParams)) {
            case NotReplaced: {
                break;
            }
            case Updated: {
                num = (Integer)repParams.get((Object)AbilityKey.Num);
                break;
            }
            default: {
                return;
            }
        }
        PlayerController pc = p.getController();
        for (int i = 0; i < num; ++i) {
            FCollection<GameEntity> list = new FCollection<GameEntity>();
            list.addAll(game.getPlayers().filter(PlayerPredicates.hasCounters()));
            list.addAll(CardLists.filter((Iterable<Card>)game.getCardsIn(ZoneType.Battlefield), CardPredicates.hasCounters()));
            List result = pc.chooseEntitiesForEffect(list, 0, list.size(), null, sa, Localizer.getInstance().getMessage("lblChooseProliferateTarget", new Object[0]), p, null);
            GameEntityCounterTable table = new GameEntityCounterTable();
            for (GameEntity ge : result) {
                for (CounterType ct : ge.getCounters().keySet()) {
                    ge.addCounter(ct, 1, p, table);
                }
            }
            table.replaceCounterEffect(game, sa, true);
            game.getTriggerHandler().runTrigger(TriggerType.Proliferate, AbilityKey.mapFromPlayer(p), false);
        }
    }
}

