/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import forge.game.Game;
import forge.game.ability.AbilityUtils;
import forge.game.ability.SpellAbilityEffect;
import forge.game.player.Player;
import forge.game.player.PlayerCollection;
import forge.game.spellability.SpellAbility;
import forge.util.Lang;
import forge.util.TextUtil;

public class ControlPlayerEffect
extends SpellAbilityEffect {
    @Override
    protected String getStackDescription(SpellAbility sa) {
        PlayerCollection tgtPlayers = ControlPlayerEffect.getTargetPlayers(sa);
        return TextUtil.concatWithSpace(sa.getActivatingPlayer().toString(), "controls", Lang.joinHomogenous(tgtPlayers), "during their next turn");
    }

    @Override
    public void resolve(SpellAbility sa) {
        Player activator = sa.getActivatingPlayer();
        Game game = activator.getGame();
        Player controller = sa.hasParam("Controller") ? (Player)AbilityUtils.getDefinedPlayers(sa.getHostCard(), sa.getParam("Controller"), sa).get(false) : activator;
        for (Player pTarget : ControlPlayerEffect.getTargetPlayers(sa)) {
            game.getCleanup().addUntil(pTarget, () -> {
                if (!controller.isInGame()) {
                    return;
                }
                long ts = game.getNextTimestamp();
                pTarget.addController(ts, controller);
                game.getCleanup().addUntil(() -> pTarget.removeController(ts));
            });
        }
    }
}

