/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import com.google.common.collect.Lists;
import forge.game.Game;
import forge.game.ability.AbilityUtils;
import forge.game.ability.SpellAbilityEffect;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.util.CardTranslation;
import forge.util.Localizer;
import java.util.ArrayList;

public class ControlExchangeEffect
extends SpellAbilityEffect {
    @Override
    protected String getStackDescription(SpellAbility sa) {
        Card object1 = null;
        Card object2 = null;
        ArrayList<Card> tgts = null;
        if (sa.usesTargeting() && (tgts = Lists.newArrayList(sa.getTargets().getTargetCards())).size() > 0) {
            object1 = (Card)tgts.get(0);
        }
        if (sa.hasParam("Defined")) {
            CardCollection cards = AbilityUtils.getDefinedCards(sa.getHostCard(), sa.getParam("Defined"), sa);
            Card card = object2 = cards.isEmpty() ? null : (Card)cards.get(0);
            if (cards.size() > 1 && !sa.usesTargeting()) {
                object1 = (Card)cards.get(1);
            }
        } else if (tgts.size() > 1) {
            object2 = (Card)tgts.get(1);
        }
        if (object1 == null || object2 == null) {
            return "";
        }
        return object1 + " exchanges controller with " + object2;
    }

    @Override
    public void resolve(SpellAbility sa) {
        Card host = sa.getHostCard();
        Game game = host.getGame();
        Card object1 = null;
        Card object2 = null;
        ArrayList<Card> tgts = null;
        if (sa.usesTargeting() && (tgts = Lists.newArrayList(sa.getTargets().getTargetCards())).size() > 0) {
            object1 = (Card)tgts.get(0);
        }
        if (sa.hasParam("Defined")) {
            CardCollection cards = AbilityUtils.getDefinedCards(host, sa.getParam("Defined"), sa);
            Card card = object2 = cards.isEmpty() ? null : (Card)cards.get(0);
            if (cards.size() > 1 && !sa.usesTargeting()) {
                object1 = (Card)cards.get(1);
            }
        } else if (tgts.size() > 1) {
            object2 = (Card)tgts.get(1);
        }
        if (object1 == null || object2 == null || !object1.isInPlay() || !object2.isInPlay()) {
            return;
        }
        Player player1 = object1.getController();
        Player player2 = object2.getController();
        if (!object2.canBeControlledBy(player1) || !object1.canBeControlledBy(player2)) {
            return;
        }
        if (sa.hasParam("Optional") && !sa.getActivatingPlayer().getController().confirmAction(sa, null, Localizer.getInstance().getMessage("lblExchangeControl", CardTranslation.getTranslatedName(object1.getName()), CardTranslation.getTranslatedName(object2.getName())), null)) {
            return;
        }
        long tStamp = game.getNextTimestamp();
        object2.addTempController(player1, tStamp);
        object1.addTempController(player2, tStamp);
        if (sa.hasParam("RememberExchanged")) {
            host.addRemembered(object1);
            host.addRemembered(object2);
        }
    }
}

