/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import forge.GameCommand;
import forge.StaticData;
import forge.game.CardTraitBase;
import forge.game.Game;
import forge.game.ability.AbilityUtils;
import forge.game.ability.SpellAbilityEffect;
import forge.game.ability.effects.TokenEffectBase;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardFactory;
import forge.game.card.CardLists;
import forge.game.card.CardPredicates;
import forge.game.event.GameEventCardStatsChanged;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.game.zone.ZoneType;
import forge.util.CardTranslation;
import forge.util.Localizer;
import forge.util.collect.FCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class CloneEffect
extends SpellAbilityEffect {
    @Override
    protected String getStackDescription(SpellAbility sa) {
        Card host;
        StringBuilder sb = new StringBuilder();
        Card tgtCard = host = sa.getHostCard();
        Card cardToCopy = host;
        if (sa.hasParam("Defined")) {
            CardCollection cloneSources = AbilityUtils.getDefinedCards(host, sa.getParam("Defined"), sa);
            if (!cloneSources.isEmpty()) {
                cardToCopy = (Card)cloneSources.get(0);
            }
        } else if (sa.usesTargeting()) {
            cardToCopy = sa.getTargetCard();
        }
        CardCollection cloneTargets = AbilityUtils.getDefinedCards(host, sa.getParam("CloneTarget"), sa);
        if (!cloneTargets.isEmpty()) {
            tgtCard = (Card)cloneTargets.get(0);
        }
        sb.append(tgtCard);
        sb.append(" becomes a copy of ").append(cardToCopy).append(".");
        return sb.toString();
    }

    @Override
    public void resolve(SpellAbility sa) {
        if (!CloneEffect.checkValidDuration(sa.getParam("Duration"), sa)) {
            return;
        }
        Card host = sa.getHostCard();
        Player activator = sa.getActivatingPlayer();
        List<Card> cloneTargets = new ArrayList<Card>();
        final Game game = activator.getGame();
        ArrayList<String> pumpKeywords = Lists.newArrayList();
        if (sa.hasParam("PumpKeywords")) {
            pumpKeywords.addAll(Arrays.asList(sa.getParam("PumpKeywords").split(" & ")));
        }
        Card cardToCopy = null;
        if (sa.hasParam("Choices")) {
            ZoneType choiceZone = ZoneType.Battlefield;
            if (sa.hasParam("ChoiceZone")) {
                choiceZone = ZoneType.smartValueOf(sa.getParam("ChoiceZone"));
            }
            CardCollection choices = new CardCollection(game.getCardsIn(choiceZone));
            if (sa.isReplacementAbility()) {
                if (choiceZone.equals((Object)ZoneType.Battlefield)) {
                    choices.retainAll(sa.getLastStateBattlefield());
                } else if (choiceZone.equals((Object)ZoneType.Graveyard)) {
                    choices.retainAll(sa.getLastStateGraveyard());
                }
            }
            choices = CardLists.getValidCards((Iterable<Card>)choices, sa.getParam("Choices"), activator, host, (CardTraitBase)sa);
            boolean choiceOpt = sa.hasParam("ChoiceOptional");
            String title = sa.hasParam("ChoiceTitle") ? sa.getParam("ChoiceTitle") : Localizer.getInstance().getMessage("lblChooseaCard", new Object[0]) + " ";
            cardToCopy = activator.getController().chooseSingleEntityForEffect(choices, sa, title, choiceOpt, null);
        } else if (sa.hasParam("Defined")) {
            CardCollection cloneSources = AbilityUtils.getDefinedCards(host, sa.getParam("Defined"), sa);
            if (!cloneSources.isEmpty()) {
                cardToCopy = (Card)cloneSources.get(0);
            }
        } else if (sa.usesTargeting()) {
            cardToCopy = sa.getTargetCard();
        } else if (sa.hasParam("CopyFromChosenName")) {
            String name = host.getNamedCard();
            cardToCopy = Card.fromPaperCard(StaticData.instance().getCommonCards().getUniqueByName(name), activator);
        }
        if (cardToCopy == null) {
            return;
        }
        boolean optional = sa.hasParam("Optional");
        if (optional && !host.getController().getController().confirmAction(sa, null, Localizer.getInstance().getMessage("lblDoYouWantCopy", CardTranslation.getTranslatedName(cardToCopy.getName())), null)) {
            return;
        }
        if (sa.hasParam("CloneTarget")) {
            cloneTargets = AbilityUtils.getDefinedCards(host, sa.getParam("CloneTarget"), sa);
            if (cloneTargets.isEmpty()) {
                return;
            }
        } else if (sa.hasParam("Choices") && sa.usesTargeting()) {
            cloneTargets.add(sa.getTargetCard());
        } else {
            cloneTargets.add(host);
        }
        if (cloneTargets.contains(cardToCopy) && sa.hasParam("ExcludeChosen")) {
            cloneTargets.remove(cardToCopy);
        }
        for (Card tgtCard : cloneTargets) {
            if (sa.hasParam("CloneZone") && !tgtCard.isInZone(ZoneType.smartValueOf(sa.getParam("CloneZone"))) || tgtCard.isPhasedOut()) continue;
            game.getTriggerHandler().clearActiveTriggers(tgtCard, null);
            final long ts = game.getNextTimestamp();
            tgtCard.addCloneState(CardFactory.getCloneStates(cardToCopy, tgtCard, sa), ts);
            tgtCard.updateRooms();
            if (sa.hasParam("IntoPlayTapped")) {
                tgtCard.setTapped(true);
            }
            if (!pumpKeywords.isEmpty()) {
                tgtCard.addChangedCardKeywords(pumpKeywords, Lists.newArrayList(), false, ts, null);
                TokenEffectBase.addPumpUntil(sa, tgtCard, ts);
            }
            tgtCard.updateStateForView();
            if (host.equals(tgtCard) && !sa.hasParam("ImprintRememberedNoCleanup")) {
                tgtCard.clearImprintedCards();
                tgtCard.clearRemembered();
            }
            if (sa.hasParam("Duration")) {
                final Card cloneCard = tgtCard;
                final CardCollection clonedImprinted = new CardCollection(tgtCard.getImprintedCards());
                final FCollection<Object> clonedRemembered = new FCollection<Object>(tgtCard.getRemembered());
                GameCommand unclone = new GameCommand(){
                    private static final long serialVersionUID = -78375985476256279L;

                    @Override
                    public void run() {
                        if (cloneCard.removeCloneState(ts)) {
                            cloneCard.clearImprintedCards();
                            cloneCard.clearRemembered();
                            cloneCard.addImprintedCards(Iterables.filter(clonedImprinted, CardPredicates.ownerLives()));
                            cloneCard.addRemembered(Iterables.filter(clonedRemembered, Player.class));
                            cloneCard.addRemembered(Iterables.filter(Iterables.filter(clonedRemembered, Card.class), CardPredicates.ownerLives()));
                            cloneCard.updateStateForView();
                            game.fireEvent(new GameEventCardStatsChanged(cloneCard));
                        }
                    }
                };
                CloneEffect.addUntilCommand(sa, unclone);
            }
            tgtCard.clearRemembered();
            tgtCard.clearImprintedCards();
            if (sa.hasParam("RememberCloneOrigin")) {
                tgtCard.addRemembered(cardToCopy);
            }
            game.fireEvent(new GameEventCardStatsChanged(tgtCard));
        }
    }
}

