/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import forge.game.GameAction;
import forge.game.GameLogEntryType;
import forge.game.ability.AbilityKey;
import forge.game.ability.AbilityUtils;
import forge.game.ability.SpellAbilityEffect;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.game.trigger.TriggerType;
import forge.game.zone.PlayerZone;
import forge.game.zone.ZoneType;
import forge.util.Localizer;
import java.util.Map;

public class ClashEffect
extends SpellAbilityEffect {
    @Override
    protected String getStackDescription(SpellAbility sa) {
        return sa.getHostCard().getName() + " - Clash with an opponent.";
    }

    @Override
    public void resolve(SpellAbility sa) {
        SpellAbility sub;
        Player opponent;
        Player winner;
        Card source = sa.getHostCard();
        Player player = source.getController();
        if (player.equals(winner = ClashEffect.clashWithOpponent(sa, opponent = sa.hasParam("Defined") ? (Player)AbilityUtils.getDefinedPlayers(source, sa.getParam("Defined"), sa).getFirst() : sa.getActivatingPlayer().getController().chooseSingleEntityForEffect(player.getOpponents(), sa, Localizer.getInstance().getMessage("lblChooseOpponent", new Object[0]), null)))) {
            sub = sa.getAdditionalAbility("WinSubAbility");
            if (sub != null) {
                AbilityUtils.resolve(sub);
            }
        } else {
            sub = sa.getAdditionalAbility("OtherwiseSubAbility");
            if (sub != null) {
                AbilityUtils.resolve(sub);
            }
        }
        Map<AbilityKey, Object> runParams = AbilityKey.mapFromPlayer(player);
        runParams.put(AbilityKey.Won, player.equals(winner) ? "True" : "False");
        source.getGame().getTriggerHandler().runTrigger(TriggerType.Clashed, runParams, false);
        Map<AbilityKey, Object> runParams2 = AbilityKey.mapFromPlayer(opponent);
        runParams2.put(AbilityKey.Won, opponent.equals(winner) ? "True" : "False");
        source.getGame().getTriggerHandler().runTrigger(TriggerType.Clashed, runParams2, false);
    }

    private static Player clashWithOpponent(SpellAbility sa, Player opponent) {
        Card source = sa.getHostCard();
        Player player = source.getController();
        ZoneType lib = ZoneType.Library;
        if (sa.hasParam("RememberClasher")) {
            source.addRemembered(opponent);
        }
        PlayerZone pLib = player.getZone(lib);
        PlayerZone oLib = opponent.getZone(lib);
        if (pLib.isEmpty() && oLib.isEmpty()) {
            return null;
        }
        StringBuilder reveal = new StringBuilder();
        Card pCard = null;
        Card oCard = null;
        CardCollection toReveal = new CardCollection();
        int pCMC = -1;
        int oCMC = -1;
        if (!pLib.isEmpty()) {
            pCard = pLib.get(0);
            pCMC = pCard.getCMC();
            toReveal.add(pCard);
            reveal.append(player).append(" " + Localizer.getInstance().getMessage("lblReveals", new Object[0]) + ": ").append(pCard.getName()).append(". " + Localizer.getInstance().getMessage("lblCMC", new Object[0]) + "= ").append(pCMC);
            reveal.append("\n");
        }
        if (!oLib.isEmpty()) {
            oCard = oLib.get(0);
            oCMC = oCard.getCMC();
            toReveal.add(oCard);
            reveal.append(opponent).append(" " + Localizer.getInstance().getMessage("lblReveals", new Object[0]) + ": ").append(oCard.getName()).append(". " + Localizer.getInstance().getMessage("lblCMC", new Object[0]) + "= ").append(oCMC);
            reveal.append("\n");
        }
        Player winner = null;
        if (pCMC == oCMC) {
            reveal.append(Localizer.getInstance().getMessage("lblNoWinner", new Object[0]));
        } else {
            winner = pCMC > oCMC ? player : opponent;
            reveal.append(winner + " " + Localizer.getInstance().getMessage("lblWinsClash", new Object[0]) + ".");
        }
        player.getGame().getAction().revealTo(toReveal, player.getGame().getPlayers(), reveal.toString(), false);
        ClashEffect.clashMoveToTopOrBottom(player, pCard, sa);
        ClashEffect.clashMoveToTopOrBottom(opponent, oCard, sa);
        return winner;
    }

    private static void clashMoveToTopOrBottom(Player p, Card c, SpellAbility sa) {
        if (c == null) {
            return;
        }
        GameAction action = p.getGame().getAction();
        boolean putOnTop = p.getController().willPutCardOnTop(c);
        String location = putOnTop ? "top" : "bottom";
        String clashOutcome = p.getName() + " clashed and put " + c.getName() + " to the " + location + " of library.";
        if (putOnTop) {
            action.moveToLibrary(c, sa);
        } else {
            action.moveToBottomOfLibrary(c, sa);
        }
        p.getGame().getGameLog().add(GameLogEntryType.STACK_RESOLVE, clashOutcome);
    }
}

