/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import forge.card.CardType;
import forge.game.ability.AbilityUtils;
import forge.game.ability.SpellAbilityEffect;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardCollectionView;
import forge.game.card.CardFactoryUtil;
import forge.game.player.Player;
import forge.game.player.PlayerCollection;
import forge.game.spellability.SpellAbility;
import forge.game.zone.ZoneType;
import forge.util.Aggregates;
import forge.util.Lang;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;

public class ChooseTypeEffect
extends SpellAbilityEffect {
    @Override
    protected String getStackDescription(SpellAbility sa) {
        StringBuilder sb = new StringBuilder();
        if (!sa.usesTargeting()) {
            sb.append(Lang.joinHomogenous(ChooseTypeEffect.getTargetPlayers(sa)));
            sb.append(" chooses a ").append(sa.getParam("Type").toLowerCase()).append(" type.");
        } else {
            sb.append("Please improve the stack description.");
        }
        return sb.toString();
    }

    @Override
    public void resolve(SpellAbility sa) {
        Card card = sa.getHostCard();
        String type = sa.getParam("Type");
        ArrayList<String> invalidTypes = sa.hasParam("InvalidTypes") ? Arrays.asList(sa.getParam("InvalidTypes").split(",")) : new ArrayList<String>();
        ArrayList<String> validTypes = new ArrayList<String>();
        PlayerCollection tgtPlayers = ChooseTypeEffect.getTargetPlayers(sa);
        boolean secret = sa.hasParam("Secretly");
        if (sa.hasParam("ValidTypes")) {
            validTypes.addAll(Arrays.asList(sa.getParam("ValidTypes").split(",")));
        }
        if (validTypes.isEmpty()) {
            switch (type) {
                case "Card": {
                    validTypes.addAll(CardType.getAllCardTypes());
                    break;
                }
                case "Creature": {
                    if (sa.hasParam("TypesFromDefined")) {
                        for (Card c : AbilityUtils.getDefinedCards(card, sa.getParam("TypesFromDefined"), sa)) {
                            validTypes.addAll(c.getType().getCreatureTypes());
                        }
                        break;
                    }
                    if (sa.hasParam("MostPrevalentInDefinedZone")) {
                        String[] info = sa.getParam("MostPrevalentInDefinedZone").split("_");
                        Player definedP = (Player)AbilityUtils.getDefinedPlayers(sa.getHostCard(), info[0], sa).get(false);
                        ZoneType z = info.length > 1 ? ZoneType.smartValueOf(info[1]) : ZoneType.Battlefield;
                        CardCollectionView zoneCards = definedP.getCardsIn(z);
                        for (String s2 : CardFactoryUtil.getMostProminentCreatureType(zoneCards)) {
                            validTypes.add(s2);
                        }
                        break;
                    }
                    validTypes.addAll(CardType.getAllCreatureTypes());
                    break;
                }
                case "Basic Land": {
                    validTypes.addAll(CardType.getBasicTypes());
                    break;
                }
                case "Nonbasic Land": {
                    validTypes.addAll(CardType.getNonBasicTypes());
                    break;
                }
                case "Land": {
                    validTypes.addAll(CardType.getAllLandTypes());
                    break;
                }
                case "Planeswalker": {
                    validTypes.addAll(CardType.getAllWalkerTypes());
                    break;
                }
                case "CreatureInTargetedDeck": {
                    for (Player p : tgtPlayers) {
                        for (Card c : p.getAllCards()) {
                            if (c.getType().getCreatureTypes() == null) continue;
                            for (String s2 : c.getType().getCreatureTypes()) {
                                if (validTypes.contains(s2)) continue;
                                validTypes.add(s2);
                            }
                        }
                    }
                    break;
                }
                case "Shared": {
                    CardCollection def;
                    if (!sa.hasParam("TypesFromDefined") || (def = AbilityUtils.getDefinedCards(card, sa.getParam("TypesFromDefined"), sa)).size() < 2) break;
                    Card card1 = (Card)def.get(false);
                    def.remove(0);
                    for (CardType.CoreType ct : card1.getType().getCoreTypes()) {
                        boolean shared = true;
                        for (Card c : def) {
                            if (c.getType().hasType(ct)) continue;
                            shared = false;
                            break;
                        }
                        if (!shared) continue;
                        validTypes.add(ct.name());
                    }
                    break;
                }
            }
        }
        validTypes.removeAll(invalidTypes);
        if (sa.hasParam("Note") && card.hasAnyNotedType()) {
            for (String noted : card.getNotedTypes()) {
                validTypes.remove(noted);
            }
        }
        if (!validTypes.isEmpty() || !sa.hasParam("Note")) {
            if (!validTypes.isEmpty()) {
                Iterator iterator = tgtPlayers.iterator();
                while (iterator.hasNext()) {
                    String choice;
                    Player p;
                    Player noNotify = p = (Player)iterator.next();
                    if (sa.hasParam("AtRandom")) {
                        choice = (String)Aggregates.random(validTypes);
                        noNotify = null;
                    } else {
                        choice = p.getController().chooseSomeType(type, sa, validTypes, invalidTypes);
                    }
                    if (!secret) {
                        p.getGame().getAction().notifyOfValue(sa, p, choice, noNotify);
                    }
                    if (sa.hasParam("Note")) {
                        card.addNotedType(choice);
                        if (!sa.hasParam("ChooseNoted")) continue;
                    }
                    if (sa.hasParam("ChooseType2")) {
                        card.setChosenType2(choice);
                        continue;
                    }
                    if (secret) {
                        card.setSecretChosenType(choice);
                        continue;
                    }
                    card.setChosenType(choice);
                }
            } else {
                throw new InvalidParameterException(sa.getHostCard() + "'s ability resulted in no types to choose from");
            }
        }
    }
}

