/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import forge.StaticData;
import forge.card.CardFacePredicates;
import forge.card.CardRules;
import forge.card.CardSplitType;
import forge.card.ICardFace;
import forge.game.CardTraitBase;
import forge.game.ability.AbilityUtils;
import forge.game.ability.SpellAbilityEffect;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardLists;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.util.Aggregates;
import forge.util.Lang;
import forge.util.Localizer;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.commons.lang3.StringUtils;

public class ChooseCardNameEffect
extends SpellAbilityEffect {
    @Override
    protected String getStackDescription(SpellAbility sa) {
        StringBuilder sb = new StringBuilder();
        sb.append(Lang.joinHomogenous(ChooseCardNameEffect.getTargetPlayers(sa)));
        sb.append("names a card.");
        return sb.toString();
    }

    @Override
    public void resolve(SpellAbility sa) {
        Card host = sa.getHostCard();
        String valid = "Card";
        String validDesc = null;
        String message = null;
        if (sa.hasParam("ValidCards")) {
            valid = sa.getParam("ValidCards");
            validDesc = sa.getParam("ValidDescription");
        }
        boolean randomChoice = sa.hasParam("AtRandom");
        boolean chooseFromDefined = sa.hasParam("ChooseFromDefinedCards");
        boolean chooseFromList = sa.hasParam("ChooseFromList");
        if (!randomChoice) {
            message = sa.hasParam("SelectPrompt") ? sa.getParam("SelectPrompt") : (null == validDesc ? Localizer.getInstance().getMessage("lblChooseACardName", new Object[0]) : Localizer.getInstance().getMessage("lblChooseASpecificCard", validDesc));
        }
        for (Player p : ChooseCardNameEffect.getTargetPlayers(sa)) {
            ArrayList<ICardFace> faces;
            if (!p.isInGame()) continue;
            String chosen = "";
            if (chooseFromDefined) {
                CardCollection choices = AbilityUtils.getDefinedCards(host, sa.getParam("ChooseFromDefinedCards"), sa);
                choices = CardLists.getValidCards((Iterable<Card>)choices, valid, host.getController(), host, (CardTraitBase)sa);
                faces = new ArrayList();
                for (Card c : choices) {
                    CardRules rules = c.getRules();
                    if (faces.contains(rules.getMainPart())) continue;
                    faces.add(rules.getMainPart());
                    if (rules.getSplitType() != CardSplitType.Split) continue;
                    faces.add(rules.getOtherPart());
                }
                Collections.sort(faces);
                chosen = p.getController().chooseCardName(sa, faces, message);
            } else if (chooseFromList) {
                String[] names = sa.getParam("ChooseFromList").split(",");
                faces = new ArrayList<ICardFace>();
                for (String string : names) {
                    String string2 = string.replace(";", ",");
                    if (sa.hasParam("ExcludeChosen") && host.getNamedCards().contains(string2)) continue;
                    faces.add(StaticData.instance().getCommonCards().getFaceByName(string2));
                }
                chosen = randomChoice ? ((ICardFace)Aggregates.random(faces)).getName() : p.getController().chooseCardName(sa, faces, message);
            } else {
                Predicate<ICardFace> cpp = Predicates.alwaysTrue();
                if (sa.hasParam("ValidCards")) {
                    if (valid.contains("cmcEQ") && !StringUtils.isNumeric(valid.split("cmcEQ")[1])) {
                        String s2 = valid.split("cmcEQ")[1];
                        valid = valid.replace(s2, String.valueOf(AbilityUtils.calculateAmount(host, s2, sa)));
                    }
                    if (valid.contains("ManaCost=")) {
                        String s2;
                        if (valid.contains("ManaCost=Equipped")) {
                            s2 = host.getEquipping().getManaCost().getShortString();
                            valid = valid.replace("=Equipped", s2);
                        } else if (valid.contains("ManaCost=Imprinted")) {
                            s2 = ((Card)host.getImprintedCards().getFirst()).getManaCost().getShortString();
                            valid = valid.replace("=Imprinted", s2);
                        }
                    }
                    cpp = CardFacePredicates.valid(valid);
                }
                if (randomChoice) {
                    Iterable<ICardFace> cards = Iterables.filter(StaticData.instance().getCommonCards().getAllFaces(), cpp);
                    chosen = Aggregates.random(cards).getName();
                } else {
                    chosen = p.getController().chooseCardName(sa, cpp, valid, message);
                }
            }
            if (!chosen.isEmpty()) {
                host.addNamedCard(chosen);
            }
            if (randomChoice) continue;
            p.setNamedCard(chosen);
        }
    }
}

