/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import com.google.common.collect.Lists;
import forge.game.Game;
import forge.game.ability.AbilityKey;
import forge.game.ability.AbilityUtils;
import forge.game.ability.SpellAbilityEffect;
import forge.game.card.Card;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.game.trigger.Trigger;
import forge.game.trigger.TriggerType;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public class ChaosEnsuesEffect
extends SpellAbilityEffect {
    @Override
    public void resolve(SpellAbility sa) {
        Card host = sa.getHostCard();
        Player activator = sa.getActivatingPlayer();
        Game game = activator.getGame();
        if (game.getActivePlanes() == null) {
            return;
        }
        Map<AbilityKey, Object> runParams = AbilityKey.mapFromPlayer(activator);
        HashMap<Integer, EnumSet> tweakedTrigs = new HashMap<Integer, EnumSet>();
        ArrayList<Card> affected = Lists.newArrayList();
        if (sa.hasParam("Defined")) {
            for (Card card : AbilityUtils.getDefinedCards(host, sa.getParam("Defined"), sa)) {
                for (Trigger t2 : card.getTriggers()) {
                    if (t2.getMode() != TriggerType.ChaosEnsues) continue;
                    EnumSet zones = (EnumSet)t2.getActiveZone();
                    tweakedTrigs.put(t2.getId(), zones);
                    zones.add(card.getZone().getZoneType());
                    t2.setActiveZone(zones);
                    affected.add(card);
                    game.getTriggerHandler().registerOneTrigger(t2);
                }
            }
            runParams.put(AbilityKey.Affected, affected);
            if (affected.isEmpty()) {
                return;
            }
        }
        game.getTriggerHandler().runTrigger(TriggerType.ChaosEnsues, runParams, false);
        for (Map.Entry entry : tweakedTrigs.entrySet()) {
            for (Card c : affected) {
                for (Trigger t3 : c.getTriggers()) {
                    if (t3.getId() != ((Integer)entry.getKey()).intValue()) continue;
                    EnumSet zones = (EnumSet)entry.getValue();
                    t3.setActiveZone(zones);
                }
            }
        }
    }
}

