/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import forge.card.CardStateName;
import forge.card.CardType;
import forge.game.CardTraitBase;
import forge.game.Game;
import forge.game.GameActionUtil;
import forge.game.GameEntity;
import forge.game.GameEntityCounterTable;
import forge.game.GameLogEntryType;
import forge.game.ability.AbilityKey;
import forge.game.ability.AbilityUtils;
import forge.game.ability.SpellAbilityEffect;
import forge.game.ability.effects.CountersNoteEffect;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardCollectionView;
import forge.game.card.CardCopyService;
import forge.game.card.CardFactoryUtil;
import forge.game.card.CardLists;
import forge.game.card.CardPredicates;
import forge.game.card.CardView;
import forge.game.card.CardZoneTable;
import forge.game.card.CounterType;
import forge.game.event.GameEventCombatChanged;
import forge.game.player.DelayedReveal;
import forge.game.player.Player;
import forge.game.player.PlayerActionConfirmMode;
import forge.game.player.PlayerCollection;
import forge.game.player.PlayerView;
import forge.game.replacement.ReplacementEffect;
import forge.game.replacement.ReplacementType;
import forge.game.spellability.SpellAbility;
import forge.game.spellability.SpellAbilityStackInstance;
import forge.game.trigger.TriggerType;
import forge.game.zone.Zone;
import forge.game.zone.ZoneType;
import forge.util.Aggregates;
import forge.util.CardTranslation;
import forge.util.Expressions;
import forge.util.Lang;
import forge.util.Localizer;
import forge.util.MessageUtil;
import forge.util.TextUtil;
import forge.util.collect.FCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class ChangeZoneEffect
extends SpellAbilityEffect {
    @Override
    protected String getStackDescription(SpellAbility sa) {
        if (sa.isHidden()) {
            return ChangeZoneEffect.changeHiddenOriginStackDescription(sa);
        }
        return ChangeZoneEffect.changeKnownOriginStackDescription(sa);
    }

    private static String changeHiddenOriginStackDescription(SpellAbility sa) {
        StringBuilder sb = new StringBuilder();
        Card host = sa.getHostCard();
        if (sa.hasParam("Optional")) {
            sb.append("(OPTIONAL) ");
        }
        List<Player> fetchers = null;
        if (sa.hasParam("DefinedPlayer")) {
            fetchers = AbilityUtils.getDefinedPlayers(host, sa.getParam("DefinedPlayer"), sa);
        }
        if (fetchers == null && sa.usesTargeting()) {
            fetchers = Lists.newArrayList(sa.getTargets().getTargetPlayers());
        }
        if (fetchers == null) {
            fetchers = Lists.newArrayList(host.getController());
        }
        String fetcherNames = Lang.joinHomogenous(fetchers, GameEntity::getName);
        List choosers = Lists.newArrayList();
        if (sa.hasParam("Chooser")) {
            choosers = AbilityUtils.getDefinedPlayers(host, sa.getParam("Chooser"), sa);
        }
        if (choosers.isEmpty()) {
            choosers.add(sa.getActivatingPlayer());
        }
        boolean oneChooser = choosers.size() == 1;
        String chooserNames = Lang.joinHomogenous(choosers);
        String fetchPlayer = fetcherNames;
        if (chooserNames.equals(fetcherNames)) {
            fetchPlayer = "their";
        }
        String origin = "";
        if (sa.hasParam("Origin")) {
            origin = sa.getParam("Origin");
        }
        String destination = sa.getParam("Destination");
        String type = "card";
        boolean defined = false;
        if (sa.hasParam("ChangeTypeDesc")) {
            type = sa.getParam("ChangeTypeDesc");
            if (type.contains("{")) {
                StringBuilder typesb = new StringBuilder();
                SpellAbilityEffect.tokenizeString(sa, typesb, type);
                type = typesb.toString();
            }
        } else if (sa.usesTargeting() || sa.hasParam("Defined")) {
            CardCollection tgts = ChangeZoneEffect.getDefinedCardsOrTargeted(sa, "Defined");
            type = Lang.joinHomogenous(tgts);
            defined = true;
        } else if (sa.hasParam("ChangeType") && !sa.getParam("ChangeType").equals("Card")) {
            String ct = sa.getParam("ChangeType");
            type = CardType.CoreType.isValidEnum(ct) ? ct.toLowerCase() : ct;
        }
        String cardTag = type.contains("card") ? "" : " card";
        int num = sa.hasParam("ChangeNum") ? AbilityUtils.calculateAmount(host, sa.getParam("ChangeNum"), sa) : 1;
        boolean tapped = sa.hasParam("Tapped");
        boolean attacking = sa.hasParam("Attacking");
        if (sa.isNinjutsu()) {
            tapped = true;
            attacking = true;
        }
        if (origin.equals("Library") && sa.hasParam("Defined")) {
            if (destination.equals("Exile")) {
                sb.append("Exile the top card of your library");
                if (sa.hasParam("ExileFaceDown")) {
                    sb.append(" face down");
                }
                sb.append(".");
            } else if (destination.equals("Ante")) {
                sb.append("Add the top card of your library to the ante.");
            }
        } else if (origin.equals("Library")) {
            boolean originAlt = sa.hasParam("OriginAlternative");
            sb.append(chooserNames).append(" search").append(!oneChooser ? " " : "es ");
            sb.append(fetchPlayer).append(fetchPlayer.equals(chooserNames) ? "'s " : " ").append("library");
            if (originAlt) {
                sb.append(sa.getParam("OriginAlternative").contains("Hand") ? ", hand, and/or graveyard for " : " and/or graveyard for ");
            } else {
                sb.append(" for ");
            }
            sb.append(Lang.nounWithNumeralExceptOne(num, type + cardTag)).append(", ");
            if (!sa.hasParam("NoReveal") && ZoneType.smartValueOf(destination) != null && ZoneType.smartValueOf(destination).isHidden()) {
                if (choosers.size() == 1) {
                    sb.append(num > 1 ? "reveals them, " : "reveals it, ");
                } else {
                    sb.append(num > 1 ? "reveal them, " : "reveal it, ");
                }
            }
            if (destination.equals("Exile")) {
                if (num == 1) {
                    sb.append("exiles it");
                } else {
                    sb.append("exiles them");
                }
            } else {
                if (num == 1) {
                    sb.append("puts it ");
                } else {
                    sb.append("puts them ");
                }
                if (destination.equals("Battlefield")) {
                    sb.append("onto the battlefield");
                    if (tapped) {
                        sb.append(" tapped").append(attacking ? " and" : "");
                    }
                    sb.append(attacking ? " attacking" : "");
                    if (sa.hasParam("GainControl")) {
                        sb.append(" under ").append(chooserNames).append("'s control");
                    }
                }
                if (destination.equals("Hand")) {
                    if (num == 1) {
                        sb.append("into their hand");
                    } else {
                        sb.append("into their owner's hand");
                    }
                }
                if (destination.equals("Graveyard")) {
                    if (num == 1) {
                        sb.append("into its owner's graveyard");
                    } else {
                        sb.append("into their owner's graveyard");
                    }
                }
            }
            sb.append(", then shuffles").append(originAlt ? " if they searched their library." : ".");
        } else if (origin.equals("Sideboard")) {
            sb.append(chooserNames);
            if (sa.hasParam("Reveal")) {
                sb.append(" may reveal ").append(num).append(" ").append(type).append(" from outside the game and put ");
                if (num == 1) {
                    sb.append("it ");
                } else {
                    sb.append("them ");
                }
                sb.append("into their ").append(destination.toLowerCase()).append(".");
            } else {
                if (sa.hasParam("Mandatory")) {
                    sb.append(" put").append(!oneChooser ? " " : "s ");
                } else {
                    sb.append(" may put ");
                }
                sb.append(num).append(" ").append(type).append(" from outside the game into their ");
                sb.append(destination.toLowerCase()).append(".");
            }
        } else if (origin.equals("Hand")) {
            sb.append(chooserNames);
            if (!chooserNames.equals(fetcherNames)) {
                sb.append(" looks at ").append(fetcherNames).append("'s hand and ");
                sb.append(destination.equals("Exile") ? "exiles " : "puts ");
                sb.append(num).append(" of those ").append(type).append(" card(s)");
            } else {
                String verb;
                String string = verb = destination.equals("Exile") ? " exiles " : " puts ";
                if (!oneChooser) {
                    verb = verb.replace("s", "");
                }
                sb.append(verb);
                if (defined) {
                    sb.append(type);
                } else if (StringUtils.containsIgnoreCase(type, "Card")) {
                    sb.append(Lang.nounWithNumeralExceptOne(num, type));
                } else {
                    sb.append(Lang.nounWithNumeralExceptOne(num, type + " card"));
                }
                sb.append(" from ").append(fetchPlayer).append(" hand");
            }
            if (destination.equals("Battlefield")) {
                sb.append(" onto the battlefield");
                if (tapped) {
                    sb.append(" tapped").append(attacking ? " and" : "");
                }
                sb.append(attacking ? " attacking" : "");
                if (sa.hasParam("GainControl")) {
                    sb.append(" under ").append(chooserNames).append("'s control");
                }
            }
            if (destination.equals("Library")) {
                int libraryPos;
                int n = libraryPos = sa.hasParam("LibraryPosition") ? AbilityUtils.calculateAmount(host, sa.getParam("LibraryPosition"), sa) : 0;
                if (libraryPos == 0) {
                    sb.append(" on top");
                }
                if (libraryPos == -1) {
                    sb.append(" on the bottom");
                }
                sb.append(" of ").append(fetchPlayer);
                if (!fetchPlayer.equals("their")) {
                    sb.append("'s");
                }
                sb.append(" library");
            }
            sb.append(".");
        } else if (origin.equals("Battlefield")) {
            sb.append("Return ").append(num).append(" ").append(type).append(" card(s) ");
            sb.append(" to your ").append(destination).append(".");
        } else if (origin.equals("Graveyard")) {
            String verb;
            boolean changeNumDesc = sa.hasParam("ChangeNumDesc");
            boolean mandatory = sa.hasParam("Mandatory");
            String changed = changeNumDesc ? sa.getParam("ChangeNumDesc") + " " + type + cardTag : (!mandatory ? Lang.nounWithNumeral(num, type + cardTag) : Lang.nounWithNumeralExceptOne(num, type + cardTag));
            boolean toField = destination.equals("Battlefield");
            boolean toHand = destination.equals("Hand");
            String string = verb = destination.equals("Exile") ? " exiles " : " returns ";
            if (!oneChooser) {
                verb = verb.replace("s", "");
            }
            sb.append(chooserNames).append(verb).append(mandatory || changeNumDesc ? "" : "up to ");
            sb.append(changed);
            sb.append(" from their graveyard").append(choosers.size() > 1 ? "s" : "");
            if (!destination.equals("Exile")) {
                sb.append(toField ? " to the " : (toHand ? " to their " : " into their "));
                sb.append(destination.toLowerCase());
            }
            if (sa.hasParam("WithCountersType")) {
                CounterType cType = CounterType.getType(sa.getParam("WithCountersType"));
                if (cType != null) {
                    sb.append(" with an additional ").append(cType.getName()).append(" counter on it");
                } else {
                    sb.append(" [ChangeZoneEffect WithCountersType error]");
                }
            }
            sb.append(".");
        } else if (origin.equals("Exile")) {
            sb.append(chooserNames).append(" puts ").append(Lang.nounWithNumeralExceptOne(num, type + cardTag));
            sb.append(" into their ").append(destination.toLowerCase()).append(".");
        }
        return sb.toString();
    }

    private static String changeKnownOriginStackDescription(SpellAbility sa) {
        StringBuilder sb = new StringBuilder();
        Card host = sa.getHostCard();
        ZoneType destination = ZoneType.smartValueOf(sa.getParam("Destination"));
        ZoneType origin = null;
        if (sa.hasParam("Origin")) {
            origin = ZoneType.listValueOf(sa.getParam("Origin")).get(0);
        }
        StringBuilder sbTargets = new StringBuilder();
        CardCollection tgts = sa.usesTargeting() ? ChangeZoneEffect.getCardsfromTargets(sa) : sa.knownDetermineDefined(sa.getParam("Defined"));
        sbTargets.append(" ").append(sa.getParamOrDefault("DefinedDesc", Lang.joinHomogenous(tgts)));
        String targetname = sbTargets.toString();
        String pronoun = Iterables.size(tgts) > 1 ? " their " : " its ";
        String fromGraveyard = " from the graveyard";
        if (destination.equals((Object)ZoneType.Battlefield)) {
            boolean attacking = sa.hasParam("Attacking");
            if (ZoneType.Graveyard.equals((Object)origin)) {
                sb.append("Return").append(targetname).append(" from the graveyard").append(" to the battlefield");
            } else {
                sb.append("Put").append(targetname).append(" onto the battlefield");
            }
            if (sa.hasParam("Tapped")) {
                sb.append(" tapped").append(attacking ? " and" : "");
            }
            sb.append(attacking ? " attacking" : "");
            if (sa.hasParam("GainControl")) {
                sb.append(" under your control");
            }
            sb.append(".");
        }
        if (destination.equals((Object)ZoneType.Hand)) {
            if (ZoneType.Graveyard.equals((Object)origin)) {
                sb.append("Return").append(targetname).append(" from the graveyard").append(" to");
            } else if (ZoneType.Battlefield.equals((Object)origin)) {
                sb.append("Return").append(targetname).append(" to");
            } else {
                sb.append("Put").append(targetname).append(" in");
            }
            sb.append(pronoun).append("owner's hand.");
        }
        if (destination.equals((Object)ZoneType.Library)) {
            if (sa.hasParam("Shuffle")) {
                sb.append("Shuffle").append(targetname);
                sb.append(" into").append(pronoun).append("owner's library.");
            } else {
                int libraryPosition;
                sb.append("Put").append(targetname);
                if (ZoneType.Graveyard.equals((Object)origin)) {
                    sb.append(" from the graveyard");
                }
                int n = libraryPosition = sa.hasParam("LibraryPosition") ? AbilityUtils.calculateAmount(host, sa.getParam("LibraryPosition"), sa) : 0;
                if (libraryPosition == -1) {
                    sb.append(" on the bottom of").append(pronoun).append("owner's library.");
                } else if (libraryPosition == 0) {
                    sb.append(" on top of").append(pronoun).append("owner's library.");
                } else {
                    sb.append(" ").append(libraryPosition + 1).append(" from the top of");
                    sb.append(pronoun).append("owner's library.");
                }
            }
        }
        if (destination.equals((Object)ZoneType.Exile)) {
            sb.append("Exile").append(targetname);
            if (ZoneType.Graveyard.equals((Object)origin)) {
                sb.append(" from the graveyard");
            }
            sb.append(".");
        }
        if (destination.equals((Object)ZoneType.Ante)) {
            sb.append("Ante").append(targetname);
            sb.append(".");
        }
        if (destination.equals((Object)ZoneType.Graveyard)) {
            sb.append("Put").append(targetname);
            if (origin != null) {
                sb.append(" from ").append((Object)origin);
            }
            sb.append(" into").append(pronoun).append("owner's graveyard.");
        }
        return sb.toString();
    }

    @Override
    public void resolve(SpellAbility sa) {
        if (!ChangeZoneEffect.checkValidDuration(sa.getParam("Duration"), sa)) {
            return;
        }
        if (sa.isHidden() && !sa.isNinjutsu()) {
            this.changeHiddenOriginResolve(sa);
        } else {
            this.changeKnownOriginResolve(sa);
        }
    }

    private void changeKnownOriginResolve(SpellAbility sa) {
        Object random;
        int libraryPosition;
        Object tgtCards = ChangeZoneEffect.getTargetCards(sa);
        Player activator = sa.getActivatingPlayer();
        Card hostCard = sa.getHostCard();
        Game game = activator.getGame();
        CardCollection commandCards = new CardCollection();
        ZoneType destination = ZoneType.smartValueOf(sa.getParam("Destination"));
        ArrayList<ZoneType> origin = Lists.newArrayList();
        if (sa.hasParam("Origin")) {
            origin.addAll(ZoneType.listValueOf(sa.getParam("Origin")));
        }
        int n = libraryPosition = sa.hasParam("LibraryPosition") ? AbilityUtils.calculateAmount(hostCard, sa.getParam("LibraryPosition"), sa) : 0;
        if (sa.hasParam("DestinationAlternative")) {
            Pair<ZoneType, Integer> pair = this.handleAltDest(sa, hostCard, destination, libraryPosition, activator);
            destination = pair.getKey();
            libraryPosition = pair.getValue();
        }
        GameEntityCounterTable counterTable = new GameEntityCounterTable();
        CardZoneTable triggerList = CardZoneTable.getSimultaneousInstance(sa);
        CardCollectionView lastStateBattlefield = triggerList.getLastStateBattlefield();
        for (SpellAbility tgtSA : ChangeZoneEffect.getTargetSpells(sa)) {
            SpellAbilityStackInstance si;
            if (!tgtSA.isSpell() || (si = game.getStack().getInstanceMatchingSpellAbilityID(tgtSA)) == null) continue;
            this.removeFromStack(tgtSA, sa, si, game, triggerList, counterTable);
        }
        String remember = sa.getParam("RememberChanged");
        String forget = sa.getParam("ForgetChanged");
        String imprint = sa.getParam("Imprint");
        if (sa.hasParam("Unimprint")) {
            hostCard.clearImprintedCards();
        }
        if (sa.hasParam("ForgetOtherRemembered")) {
            hostCard.clearRemembered();
        }
        boolean optional = sa.hasParam("Optional");
        boolean shuffle = sa.hasParam("Shuffle") && "True".equals(sa.getParam("Shuffle"));
        boolean combatChanged = false;
        if (sa.hasParam("ShuffleNonMandatory") && !activator.getController().confirmAction(sa, null, Localizer.getInstance().getMessage("lblDoyouWantShuffleTheLibrary", new Object[0]), null)) {
            return;
        }
        Player chooser = activator;
        if (sa.hasParam("Chooser")) {
            chooser = (Player)AbilityUtils.getDefinedPlayers(hostCard, sa.getParam("Chooser"), sa).get(false);
        }
        if (destination.isDeck() && !shuffle && tgtCards.size() > 1) {
            if (sa.hasParam("RandomOrder")) {
                random = new CardCollection((Iterable<Card>)tgtCards);
                CardLists.shuffle((List<Card>)random);
                tgtCards = random;
            } else {
                tgtCards = sa.hasParam("Chooser") ? chooser.getController().orderMoveToZoneList((CardCollectionView)tgtCards, destination, sa) : GameActionUtil.orderCardsByTheirOwners(game, (CardCollectionView)tgtCards, destination, sa);
            }
        }
        random = tgtCards.iterator();
        while (random.hasNext()) {
            int cAmount;
            CounterType cType;
            Zone originZone;
            Card tgtC = (Card)random.next();
            Card gameCard = game.getCardState(tgtC, null);
            if (gameCard == null || !tgtC.equalsWithGameTimestamp(gameCard) || gameCard.isPhasedOut()) continue;
            if (sa.hasParam("RememberLKI")) {
                hostCard.addRemembered(CardCopyService.getLKICopy(gameCard));
            }
            String prompt = TextUtil.concatWithSpace(Localizer.getInstance().getMessage("lblDoYouWantMoveTargetFromOriToDest", CardTranslation.getTranslatedName(gameCard.getName()), Lang.joinHomogenous(origin, ZoneType::getTranslatedName), destination.getTranslatedName()));
            if (optional && !chooser.getController().confirmAction(sa, null, prompt, null) || (originZone = game.getZoneOf(gameCard)) == null || !origin.isEmpty() && !origin.contains((Object)originZone.getZoneType())) continue;
            Card movedCard = null;
            EnumMap<AbilityKey, Object> moveParams = AbilityKey.newMap();
            AbilityKey.addCardZoneTableParams(moveParams, triggerList);
            if (destination.equals((Object)ZoneType.Library)) {
                if (sa.hasParam("Fizzle") && (gameCard.isInZone(ZoneType.Exile) || gameCard.isInZone(ZoneType.Hand) || gameCard.isInZone(ZoneType.Stack))) {
                    game.getStack().remove(gameCard);
                }
                movedCard = game.getAction().moveToLibrary(gameCard, libraryPosition, sa, moveParams);
            } else if (destination.equals((Object)ZoneType.Battlefield)) {
                GameEntity attachedTo;
                FCollection list;
                moveParams.put(AbilityKey.SimultaneousETB, tgtCards);
                if (sa.isReplacementAbility()) {
                    ReplacementEffect re = sa.getReplacementEffect();
                    moveParams.put(AbilityKey.ReplacementEffect, (Object)re);
                    if (ReplacementType.Moved.equals((Object)re.getMode()) && sa.getReplacingObject(AbilityKey.CardLKI) != null) {
                        moveParams.put(AbilityKey.CardLKI, sa.getReplacingObject(AbilityKey.CardLKI));
                    }
                }
                if (sa.hasParam("Tapped") || sa.isNinjutsu()) {
                    gameCard.setTapped(true);
                }
                if (sa.hasParam("Transformed")) {
                    if (!gameCard.isTransformable()) continue;
                    if (!moveParams.containsKey((Object)AbilityKey.CardLKI)) {
                        moveParams.put(AbilityKey.CardLKI, (Object)CardCopyService.getLKICopy(gameCard));
                    }
                    gameCard.changeCardState("Transform", null, sa);
                }
                if (sa.hasParam("WithCountersType")) {
                    cType = CounterType.getType(sa.getParam("WithCountersType"));
                    cAmount = AbilityUtils.calculateAmount(hostCard, sa.getParamOrDefault("WithCountersAmount", "1"), sa);
                    GameEntityCounterTable table = new GameEntityCounterTable();
                    table.put(activator, gameCard, cType, cAmount);
                    moveParams.put(AbilityKey.CounterTable, (Object)table);
                } else if (sa.hasParam("WithNotedCounters")) {
                    CountersNoteEffect.loadCounters(gameCard, hostCard, chooser, sa, moveParams);
                }
                if (sa.hasParam("GainControl")) {
                    Player newController;
                    String g2 = sa.getParam("GainControl");
                    Player player = newController = g2.equals("True") ? activator : (Player)AbilityUtils.getDefinedPlayers(hostCard, g2, sa).get(false);
                    if (newController != null) {
                        if (newController != gameCard.getController()) {
                            gameCard.runChangeControllerCommands();
                        }
                        gameCard.setController(newController, game.getNextTimestamp());
                    }
                }
                if (sa.hasParam("AttachedTo")) {
                    list = AbilityUtils.getDefinedCards(hostCard, sa.getParam("AttachedTo"), sa);
                    if (list.isEmpty()) {
                        list = CardLists.getValidCards((Iterable<Card>)lastStateBattlefield, sa.getParam("AttachedTo"), hostCard.getController(), hostCard, (CardTraitBase)sa);
                    }
                    if (!list.isEmpty()) {
                        list = CardLists.filter((Iterable<Card>)list, CardPredicates.canBeAttached(gameCard, sa));
                    }
                    if (!list.isEmpty()) {
                        HashMap<String, Object> params = Maps.newHashMap();
                        params.put("Attach", gameCard);
                        attachedTo = (Card)activator.getController().chooseSingleEntityForEffect(list, sa, Localizer.getInstance().getMessage("lblSelectACardAttachSourceTo", gameCard.toString()), params);
                        gameCard.attachToEntity(game.getCardState((Card)attachedTo), sa, true);
                    } else if (gameCard.isAura()) continue;
                }
                if (sa.hasParam("AttachedToPlayer")) {
                    list = AbilityUtils.getDefinedPlayers(hostCard, sa.getParam("AttachedToPlayer"), sa);
                    if (list.isEmpty()) continue;
                    HashMap<String, Object> params = Maps.newHashMap();
                    params.put("Attach", gameCard);
                    attachedTo = (Player)activator.getController().chooseSingleEntityForEffect(list, sa, Localizer.getInstance().getMessage("lblSelectAPlayerAttachSourceTo", gameCard.toString()), params);
                    gameCard.attachToEntity(attachedTo, sa);
                }
                if (sa.hasAdditionalAbility("AnimateSubAbility")) {
                    if (!moveParams.containsKey((Object)AbilityKey.CardLKI)) {
                        moveParams.put(AbilityKey.CardLKI, (Object)CardCopyService.getLKICopy(gameCard));
                    }
                    SpellAbility animate = sa.getAdditionalAbility("AnimateSubAbility");
                    hostCard.addRemembered(gameCard);
                    AbilityUtils.resolve(animate);
                    hostCard.removeRemembered(gameCard);
                    animate.setSVar("unanimateTimestamp", String.valueOf(game.getTimestamp()));
                }
                if (sa.hasParam("FaceDown")) {
                    gameCard.turnFaceDown(true);
                    CardFactoryUtil.setFaceDownState(gameCard, sa);
                }
                if ((movedCard = game.getAction().moveTo(gameCard.getController().getZone(destination), gameCard, sa, moveParams)).getZone().equals(originZone)) continue;
                if (sa.hasParam("Unearth") && movedCard.isInPlay()) {
                    movedCard.setUnearthed(true);
                    movedCard.addChangedCardKeywords(Lists.newArrayList("Haste"), null, false, game.getNextTimestamp(), null, true);
                    ChangeZoneEffect.registerDelayedTrigger(sa, "Exile", Lists.newArrayList(movedCard));
                    ChangeZoneEffect.addLeaveBattlefieldReplacement(movedCard, sa, "Exile");
                }
                if (sa.hasParam("LeaveBattlefield")) {
                    ChangeZoneEffect.addLeaveBattlefieldReplacement(movedCard, sa, sa.getParam("LeaveBattlefield"));
                }
                if (ChangeZoneEffect.addToCombat(movedCard, sa, "Attacking", "Blocking")) {
                    combatChanged = true;
                }
                if (sa.isNinjutsu()) {
                    Card returned = (Card)sa.getPaidList("Returned", true).getFirst();
                    GameEntity defender = game.getCombat().getDefenderByAttacker(returned);
                    game.getCombat().addAttacker(movedCard, defender);
                    game.getCombat().getBandOfAttacker(movedCard).setBlocked(false);
                    combatChanged = true;
                }
                if (sa.hasParam("AttachAfter") && movedCard.isAttachment()) {
                    list = AbilityUtils.getDefinedCards(hostCard, sa.getParam("AttachAfter"), sa);
                    if (list.isEmpty()) {
                        list = CardLists.getValidCards((Iterable<Card>)game.getCardsIn(ZoneType.Battlefield), sa.getParam("AttachAfter"), hostCard.getController(), hostCard, (CardTraitBase)sa);
                    }
                    if (!list.isEmpty()) {
                        String title = Localizer.getInstance().getMessage("lblSelectACardAttachSourceTo", CardTranslation.getTranslatedName(gameCard.getName()));
                        HashMap<String, Object> params = Maps.newHashMap();
                        params.put("Attach", gameCard);
                        Card attachedTo2 = (Card)chooser.getController().chooseSingleEntityForEffect(list, sa, title, params);
                        movedCard.attachToEntity(attachedTo2, sa);
                    }
                }
            } else {
                if (destination.equals((Object)ZoneType.Exile)) {
                    if (!gameCard.canExiledBy(sa, true)) continue;
                    ChangeZoneEffect.handleExiledWith(gameCard, sa);
                }
                movedCard = game.getAction().moveTo(destination, gameCard, libraryPosition, sa, moveParams);
                if (destination.equals((Object)ZoneType.Exile) && lastStateBattlefield.contains(gameCard) && hostCard.equals(gameCard)) {
                    ChangeZoneEffect.handleExiledWith(movedCard, sa, lastStateBattlefield.get(gameCard));
                }
                if (ZoneType.Hand.equals((Object)destination) && ZoneType.Command.equals((Object)originZone.getZoneType())) {
                    StringBuilder sb = new StringBuilder();
                    sb.append(movedCard.getName()).append(" has moved from Command Zone to ").append(activator).append("'s hand.");
                    game.getGameLog().add(GameLogEntryType.ZONE_CHANGE, sb.toString());
                    commandCards.add(movedCard);
                }
                if (sa.hasParam("Fizzle") && (gameCard.isInZone(ZoneType.Exile) || gameCard.isInZone(ZoneType.Hand) || gameCard.isInZone(ZoneType.Stack) || gameCard.isInZone(ZoneType.Command))) {
                    game.getStack().remove(gameCard);
                }
                if (sa.hasParam("WithCountersType")) {
                    cType = CounterType.getType(sa.getParam("WithCountersType"));
                    cAmount = AbilityUtils.calculateAmount(hostCard, sa.getParamOrDefault("WithCountersAmount", "1"), sa);
                    movedCard.addCounter(cType, cAmount, activator, counterTable);
                }
                if (sa.hasParam("ExileFaceDown") || sa.hasParam("FaceDown")) {
                    movedCard.turnFaceDown(true);
                }
                if (sa.hasParam("Foretold")) {
                    movedCard.setForetold(true);
                    if (sa.hasParam("ForetoldCost")) {
                        movedCard.setForetoldCostByEffect(true);
                    }
                    movedCard.addMayLookTemp(activator);
                }
                if (sa.hasParam("TrackDiscarded")) {
                    movedCard.setDiscarded(true);
                }
            }
            if (movedCard.getZone().equals(originZone)) continue;
            Card meld = null;
            if (gameCard.getMeldedWith() != null) {
                meld = game.getCardState(gameCard.getMeldedWith(), null);
                if (sa.hasParam("WithCountersType")) {
                    CounterType cType2 = CounterType.getType(sa.getParam("WithCountersType"));
                    int cAmount2 = AbilityUtils.calculateAmount(hostCard, sa.getParamOrDefault("WithCountersAmount", "1"), sa);
                    meld.addCounter(cType2, cAmount2, activator, counterTable);
                }
            }
            if (gameCard.hasMergedCard()) {
                for (Card c : gameCard.getMergedCards()) {
                    if (c == gameCard || !sa.hasParam("WithCountersType")) continue;
                    CounterType cType3 = CounterType.getType(sa.getParam("WithCountersType"));
                    int cAmount3 = AbilityUtils.calculateAmount(hostCard, sa.getParamOrDefault("WithCountersAmount", "1"), sa);
                    c.addCounter(cType3, cAmount3, activator, counterTable);
                }
            }
            if (remember != null) {
                hostCard.addRemembered(movedCard);
                if (meld != null) {
                    hostCard.addRemembered(meld);
                }
                if (gameCard.hasMergedCard()) {
                    for (Card c : gameCard.getMergedCards()) {
                        if (c == gameCard) continue;
                        hostCard.addRemembered(c);
                    }
                }
            }
            if (forget != null) {
                hostCard.removeRemembered(movedCard);
            }
            if (imprint == null) continue;
            hostCard.addImprintedCard(movedCard);
            if (!gameCard.hasMergedCard()) continue;
            for (Card c : gameCard.getMergedCards()) {
                if (c == gameCard) continue;
                hostCard.addImprintedCard(c);
            }
            if (!sa.hasParam("ImprintLast")) continue;
            Card lastCard = null;
            for (Card c : movedCard.getOwner().getCardsIn(destination)) {
                if (!hostCard.hasImprintedCard(c)) continue;
                hostCard.removeImprintedCard(c);
                lastCard = c;
            }
            hostCard.addImprintedCard(lastCard);
        }
        if (combatChanged) {
            game.updateCombatForView();
            game.fireEvent(new GameEventCombatChanged());
        }
        if (!commandCards.isEmpty()) {
            game.getAction().reveal(commandCards, activator, true, "Revealed cards in ");
        }
        triggerList.triggerChangesZoneAll(game, sa);
        counterTable.replaceCounterEffect(game, sa, true);
        if (sa.hasParam("AtEOT") && !triggerList.isEmpty()) {
            ChangeZoneEffect.registerDelayedTrigger(sa, sa.getParam("AtEOT"), triggerList.allCards());
        }
        if ("UntilHostLeavesPlay".equals(sa.getParam("Duration"))) {
            ChangeZoneEffect.addUntilCommand(sa, ChangeZoneEffect.untilHostLeavesPlayCommand(triggerList, sa));
        }
        if (destination.equals((Object)ZoneType.Exile)) {
            ChangeZoneEffect.handleExiledWith(triggerList.allCards(), sa);
        }
        if (destination.equals((Object)ZoneType.Library) && shuffle) {
            PlayerCollection pl = new PlayerCollection();
            if (sa.hasParam("TargetsWithDefinedController")) {
                pl.addAll(AbilityUtils.getDefinedPlayers(hostCard, sa.getParam("TargetsWithDefinedController"), sa));
            } else {
                Iterator iterator = tgtCards.iterator();
                while (iterator.hasNext()) {
                    Card tgtC = (Card)iterator.next();
                    pl.add(tgtC.getOwner());
                }
                if (pl.isEmpty()) {
                    pl.add(activator);
                }
            }
            for (Player p : pl) {
                p.shuffle(sa);
            }
        }
    }

    private void changeHiddenOriginResolve(SpellAbility sa) {
        PlayerCollection choosers;
        List<Player> fetchers = sa.hasParam("DefinedPlayer") ? AbilityUtils.getDefinedPlayers(sa.getHostCard(), sa.getParam("DefinedPlayer"), sa) : Lists.newArrayList(sa.getActivatingPlayer());
        Player chooser = null;
        if (sa.hasParam("Chooser") && !(choosers = AbilityUtils.getDefinedPlayers(sa.getHostCard(), sa.getParam("Chooser"), sa)).isEmpty()) {
            chooser = sa.getActivatingPlayer().getController().chooseSingleEntityForEffect(choosers, null, sa, Localizer.getInstance().getMessage("lblChooser", new Object[0]) + ":", false, null, null);
        }
        this.changeZonePlayerInvariant(chooser, sa, fetchers);
    }

    private void changeZonePlayerInvariant(Player chooser, SpellAbility sa, List<Player> fetchers) {
        Card source = sa.getHostCard();
        Game game = source.getGame();
        boolean chooseFromDef = sa.hasParam("ChooseFromDefined");
        boolean defined = sa.hasParam("Defined") || chooseFromDef;
        String changeType = sa.getParamOrDefault("ChangeType", "");
        boolean mandatory = sa.hasParam("Mandatory");
        HashMap<Player, HiddenOriginChoices> HiddenOriginChoicesMap = Maps.newHashMap();
        for (Player player : fetchers) {
            boolean bl;
            boolean bl2;
            boolean bl3;
            CardCollection fetchList;
            Player decider = chooser;
            if (decider == null) {
                decider = player;
            }
            if (sa.usesTargeting()) {
                ArrayList<Player> players = Lists.newArrayList(sa.getTargets().getTargetPlayers());
                Player player2 = player = sa.hasParam("DefinedPlayer") ? player : (Player)players.get(0);
                if (players.contains(player) && !player.canBeTargetedBy(sa)) {
                    return;
                }
            }
            List<Object> origin = Lists.newArrayList();
            if (sa.hasParam("Origin")) {
                origin = ZoneType.listValueOf(sa.getParam("Origin"));
            }
            ZoneType destination = ZoneType.smartValueOf(sa.getParam("Destination"));
            if (sa.hasParam("OriginAlternative")) {
                List<ZoneType> alt = ZoneType.listValueOf(sa.getParam("OriginAlternative"));
                CardCollectionView altFetchList = AbilityUtils.filterListByType(player.getCardsIn(alt), sa.getParam("ChangeType"), sa);
                StringBuilder sb = new StringBuilder();
                sb.append(Localizer.getInstance().getMessage("lblSearchLibrary", new Object[0])).append(" ");
                sb.append(altFetchList.size()).append(" ").append(Localizer.getInstance().getMessage("lblCardMatchSearchingTypeInAlternateZones", new Object[0]));
                if (!decider.getController().confirmAction(sa, PlayerActionConfirmMode.ChangeZoneFromAltSource, sb.toString(), null)) {
                    origin.clear();
                }
                while (!alt.isEmpty() && origin.size() + alt.size() != 1) {
                    ZoneType z = alt.get(0);
                    String string2 = Localizer.getInstance().getMessage("lblSearchPlayerZoneConfirm", "{player's}", z.getTranslatedName().toLowerCase());
                    string2 = MessageUtil.formatMessage(string2, decider, (Object)player);
                    if (decider.getController().confirmAction(sa, PlayerActionConfirmMode.ChangeZoneFromAltSource, string2, null)) {
                        origin.add((Object)z);
                    }
                    alt.remove(0);
                }
                if (origin.isEmpty()) {
                    origin = alt;
                }
                for (ZoneType zoneType : origin) {
                    if (!zoneType.isKnown() || !Iterables.any(altFetchList, CardPredicates.inZone(zoneType))) continue;
                    mandatory = true;
                }
            }
            if (sa.hasParam("Optional")) {
                String prompt = sa.hasParam("OptionalPrompt") ? sa.getParam("OptionalPrompt") : (defined ? Localizer.getInstance().getMessage("lblPutThatCardFromPlayerOriginToDestination", "{player's}", Lang.joinHomogenous(origin, ZoneType::getTranslatedName).toLowerCase(), destination.getTranslatedName().toLowerCase()) : Localizer.getInstance().getMessage("lblSearchPlayerZoneConfirm", "{player's}", Lang.joinHomogenous(origin, ZoneType::getTranslatedName).toLowerCase()));
                String message = MessageUtil.formatMessage(prompt, decider, (Object)player);
                if (!decider.getController().confirmAction(sa, PlayerActionConfirmMode.ChangeZoneGeneral, message, null)) continue;
            }
            if (player.isControlled()) {
                origin.remove((Object)ZoneType.Sideboard);
            }
            int libraryPos = sa.hasParam("LibraryPosition") ? AbilityUtils.calculateAmount(source, sa.getParam("LibraryPosition"), sa) : 0;
            int changeNum = sa.hasParam("ChangeNum") ? AbilityUtils.calculateAmount(source, sa.getParam("ChangeNum"), sa) : 1;
            boolean shuffleMandatory = true;
            boolean bl4 = false;
            if (defined) {
                String param = chooseFromDef ? "ChooseFromDefined" : "Defined";
                fetchList = AbilityUtils.getDefinedCards(source, sa.getParam(param), sa);
                if (!sa.hasParam("ChangeNum")) {
                    changeNum = fetchList.size();
                }
            } else if (!(origin.contains((Object)ZoneType.Library) || origin.contains((Object)ZoneType.Hand) || sa.hasParam("DefinedPlayer"))) {
                fetchList = new CardCollection(player.getGame().getCardsIn(origin));
            } else {
                fetchList = new CardCollection(player.getCardsIn(origin));
                if (origin.contains((Object)ZoneType.Library) && !sa.hasParam("NoLooking")) {
                    boolean bl5 = true;
                    if (decider.hasKeyword("LimitSearchLibrary")) {
                        fetchList.removeAll(player.getCardsIn(ZoneType.Library));
                        int fetchNum = Math.min(player.getCardsIn(ZoneType.Library).size(), 4);
                        if (fetchNum == 0) {
                            boolean bl6 = false;
                        } else {
                            fetchList.addAll(player.getCardsIn(ZoneType.Library, fetchNum));
                        }
                    }
                    if (!decider.canSearchLibraryWith(sa, player)) {
                        fetchList.removeAll(player.getCardsIn(ZoneType.Library));
                        shuffleMandatory = !sa.hasParam("ShuffleNonMandatory");
                        bl3 = false;
                    }
                }
            }
            DelayedReveal delayedReveal = null;
            if (!defined && !sa.hasParam("AlreadyRevealed")) {
                if (origin.contains((Object)ZoneType.Library) && bl3) {
                    int fetchNum = Math.min(player.getCardsIn(ZoneType.Library).size(), 4);
                    CardCollectionView shown = !decider.hasKeyword("LimitSearchLibrary") ? player.getCardsIn(ZoneType.Library) : player.getCardsIn(ZoneType.Library, fetchNum);
                    delayedReveal = new DelayedReveal(shown, ZoneType.Library, PlayerView.get(player), CardTranslation.getTranslatedName(source.getName()) + " - " + Localizer.getInstance().getMessage("lblLookingCardIn", new Object[0]) + " ");
                } else if (origin.contains((Object)ZoneType.Hand) && player.isOpponentOf(decider)) {
                    delayedReveal = new DelayedReveal(player.getCardsIn(ZoneType.Hand), ZoneType.Hand, PlayerView.get(player), CardTranslation.getTranslatedName(source.getName()) + " - " + Localizer.getInstance().getMessage("lblLookingCardIn", new Object[0]) + " ");
                }
            }
            Long controlTimestamp = null;
            if (!bl3 && sa.hasParam("Searched")) {
                bl2 = true;
            }
            if (bl2) {
                if (decider.equals(player)) {
                    Map.Entry<Long, Player> searchControlPlayer = player.getControlledWhileSearching();
                    if (searchControlPlayer != null) {
                        controlTimestamp = searchControlPlayer.getKey();
                        player.addController(controlTimestamp, searchControlPlayer.getValue());
                    }
                    decider.incLibrarySearched();
                    this.handleCastWhileSearching(fetchList, decider);
                }
                Map<AbilityKey, Object> runParams = AbilityKey.mapFromPlayer(decider);
                runParams.put(AbilityKey.Target, Lists.newArrayList(player));
                decider.getGame().getTriggerHandler().runTrigger(TriggerType.SearchedLibrary, runParams, false);
            }
            if (bl2 && sa.hasParam("Searched")) {
                bl = false;
            }
            if (!(defined || changeType.isEmpty() || changeType.startsWith("EACH"))) {
                fetchList = (CardCollection)AbilityUtils.filterListByType(fetchList, sa.getParam("ChangeType"), sa);
            }
            fetchList.sort();
            if (sa.hasParam("NoShuffle") || "False".equals(sa.getParam("Shuffle"))) {
                shuffleMandatory = false;
            }
            if (sa.hasParam("Unimprint")) {
                source.clearImprintedCards();
            }
            if (sa.hasParam("ForgetOtherRemembered")) {
                source.clearRemembered();
            }
            String selectPrompt = sa.hasParam("SelectPrompt") ? sa.getParam("SelectPrompt") : MessageUtil.formatMessage(Localizer.getInstance().getMessage("lblSelectCardFromPlayerZone", "{player's}", Lang.joinHomogenous(origin, ZoneType::getTranslatedName).toLowerCase()), decider, (Object)player);
            String totalcmc = sa.getParam("WithTotalCMC");
            String totalpower = sa.getParam("WithTotalPower");
            String totalCardTypes = sa.getParam("WithTotalCardTypes");
            int totcmc = AbilityUtils.calculateAmount(source, totalcmc, sa);
            int totpower = AbilityUtils.calculateAmount(source, totalpower, sa);
            int totCardTypes = AbilityUtils.calculateAmount(source, totalCardTypes, sa);
            CardCollection chosenCards = new CardCollection();
            if (changeType.startsWith("EACH")) {
                String[] eachTypes;
                for (String thisType : eachTypes = changeType.substring(5).split(" & ")) {
                    for (int i = 0; i < changeNum && destination != null; ++i) {
                        Card c;
                        CardCollection thisList = (CardCollection)AbilityUtils.filterListByType(fetchList, thisType, sa);
                        if (!chosenCards.isEmpty()) {
                            thisList.removeAll(chosenCards);
                        }
                        if ((c = decider.getController().chooseSingleCardForZoneChange(destination, origin, sa, thisList, delayedReveal, selectPrompt, !mandatory, decider)) == null) continue;
                        chosenCards.add(c);
                    }
                }
            } else if (changeNum > 1 && ChangeZoneEffect.allowMultiSelect(decider, sa)) {
                List<Card> selectedCards;
                if (!sa.hasParam("SelectPrompt")) {
                    selectPrompt = fetchList.size() > changeNum ? MessageUtil.formatMessage(Localizer.getInstance().getMessage("lblSelectUpToNumCardFromPlayerZone", String.valueOf(changeNum), "{player's}", Lang.joinHomogenous(origin, ZoneType::getTranslatedName).toLowerCase()), decider, (Object)player) : MessageUtil.formatMessage(Localizer.getInstance().getMessage("lblSelectCardsFromPlayerZone", "{player's}", Lang.joinHomogenous(origin, ZoneType::getTranslatedName).toLowerCase()), decider, (Object)player);
                }
                while ((selectedCards = decider.getController().chooseCardsForZoneChange(destination, origin, sa, fetchList, 0, changeNum, delayedReveal, selectPrompt, decider)) != null && selectedCards.size() > changeNum) {
                }
                if (selectedCards != null) {
                    chosenCards.addAll(selectedCards);
                }
            } else {
                for (int i = 0; i < changeNum && destination != null; ++i) {
                    Card c2;
                    if (sa.hasParam("DifferentNames")) {
                        for (Card c2 : chosenCards) {
                            fetchList = CardLists.filter((Iterable<Card>)fetchList, Predicates.not(CardPredicates.sharesNameWith(c2)));
                        }
                    }
                    if (sa.hasParam("DifferentCMC")) {
                        for (Card c2 : chosenCards) {
                            fetchList = CardLists.filter((Iterable<Card>)fetchList, Predicates.not(CardPredicates.sharesCMCWith(c2)));
                        }
                    }
                    if (sa.hasParam("DifferentPower")) {
                        for (Card c2 : chosenCards) {
                            fetchList = CardLists.filter((Iterable<Card>)fetchList, Predicates.not(Predicates.compose(Predicates.equalTo(c2.getNetPower()), Card::getNetPower)));
                        }
                    }
                    if (sa.hasParam("ShareLandType")) {
                        for (Card c2 : chosenCards) {
                            fetchList = CardLists.filter((Iterable<Card>)fetchList, CardPredicates.sharesLandTypeWith(c2));
                        }
                    }
                    if (totalcmc != null && totcmc >= 0) {
                        fetchList = CardLists.getValidCards((Iterable<Card>)fetchList, "Card.cmcLE" + totcmc, source.getController(), source, (CardTraitBase)sa);
                    }
                    if (totalpower != null && totpower >= 0) {
                        fetchList = CardLists.getValidCards((Iterable<Card>)fetchList, "Card.powerLE" + totpower, source.getController(), source, (CardTraitBase)sa);
                    }
                    boolean shouldReveal = i == 0;
                    c2 = null;
                    if (sa.hasParam("AtRandom")) {
                        if (shouldReveal && delayedReveal != null) {
                            decider.getController().reveal(delayedReveal.getCards(), delayedReveal.getZone(), delayedReveal.getOwner(), delayedReveal.getMessagePrefix());
                        }
                        c2 = Aggregates.random(fetchList);
                    } else if (defined && !chooseFromDef) {
                        c2 = Iterables.getFirst(fetchList, null);
                    } else if (totalCardTypes != null) {
                        String title = selectPrompt;
                        title = title + "\nCard types left: " + Math.max(totCardTypes, 0);
                        c2 = decider.getController().chooseSingleCardForZoneChange(destination, origin, sa, fetchList, shouldReveal ? delayedReveal : null, title, !mandatory, decider);
                    } else {
                        String title = selectPrompt;
                        if (changeNum > 1) {
                            title = title + " (" + (i + 1) + " / " + changeNum + ")";
                        }
                        c2 = decider.getController().chooseSingleCardForZoneChange(destination, origin, sa, fetchList, shouldReveal ? delayedReveal : null, title, !mandatory, decider);
                    }
                    if (c2 == null) {
                        int num = Math.min(fetchList.size(), changeNum - i);
                        String message = Localizer.getInstance().getMessage("lblCancelSearchUpToSelectNumCards", String.valueOf(num));
                        if (fetchList.isEmpty() || sa.hasParam("SkipCancelPrompt") || decider.getController().confirmAction(sa, PlayerActionConfirmMode.ChangeZoneGeneral, message, null)) break;
                        --i;
                        continue;
                    }
                    fetchList.remove(c2);
                    if (delayedReveal != null) {
                        delayedReveal.remove(CardView.get(c2));
                    }
                    chosenCards.add(c2);
                    if (totalcmc != null) {
                        totcmc -= c2.getCMC();
                    }
                    if (totalpower != null) {
                        totpower -= c2.getCurrentPower();
                    }
                    if (totalCardTypes == null) continue;
                    totCardTypes -= Iterables.size(c2.getType().getCoreTypes());
                }
                if (totalCardTypes != null && totCardTypes > 0) {
                    chosenCards.clear();
                }
            }
            if (sa.hasParam("ShuffleChangedPile")) {
                CardLists.shuffle(chosenCards);
            }
            if (sa.hasParam("DestinationAlternative")) {
                Pair<ZoneType, Integer> pair = this.handleAltDest(sa, source, destination, libraryPos, decider);
                destination = pair.getKey();
                libraryPos = pair.getValue();
            }
            if (origin.contains((Object)ZoneType.Library) && destination == ZoneType.Library && shuffleMandatory) {
                player.shuffle(sa);
            }
            if (sa.hasParam("Reorder")) {
                chosenCards = new CardCollection(decider.getController().orderMoveToZoneList(chosenCards, destination, sa));
            }
            if (controlTimestamp != null) {
                player.removeController(controlTimestamp);
            }
            HiddenOriginChoices choices = new HiddenOriginChoices();
            choices.searchedLibrary = bl;
            choices.shuffleMandatory = shuffleMandatory;
            choices.chosenCards = chosenCards;
            choices.libraryPos = libraryPos;
            choices.origin = origin;
            choices.destination = destination;
            HiddenOriginChoicesMap.put(player, choices);
        }
        boolean remember = sa.hasParam("RememberChanged");
        boolean forget = sa.hasParam("ForgetChanged");
        boolean champion = sa.hasParam("Champion");
        boolean imprint = sa.hasParam("Imprint");
        boolean combatChanged = false;
        CardZoneTable triggerList = CardZoneTable.getSimultaneousInstance(sa);
        for (Player player : HiddenOriginChoicesMap.keySet()) {
            boolean searchedLibrary = ((HiddenOriginChoices)HiddenOriginChoicesMap.get((Object)player)).searchedLibrary;
            boolean bl = ((HiddenOriginChoices)HiddenOriginChoicesMap.get((Object)player)).shuffleMandatory;
            CardCollection chosenCards = ((HiddenOriginChoices)HiddenOriginChoicesMap.get((Object)player)).chosenCards;
            int libraryPos = ((HiddenOriginChoices)HiddenOriginChoicesMap.get((Object)player)).libraryPos;
            List<ZoneType> origin = ((HiddenOriginChoices)HiddenOriginChoicesMap.get((Object)player)).origin;
            ZoneType destination = ((HiddenOriginChoices)HiddenOriginChoicesMap.get((Object)player)).destination;
            CardCollection movedCards = new CardCollection();
            Player decider = ObjectUtils.firstNonNull(chooser, player);
            for (Card c : chosenCards) {
                Iterator meld;
                GameEntityCounterTable table;
                CounterType cType;
                Card movedCard = null;
                Zone originZone = game.getZoneOf(c);
                EnumMap<AbilityKey, Object> moveParams = AbilityKey.newMap();
                moveParams.put(AbilityKey.FoundSearchingLibrary, Boolean.valueOf(searchedLibrary));
                AbilityKey.addCardZoneTableParams(moveParams, triggerList);
                if (destination.equals((Object)ZoneType.Library)) {
                    movedCard = game.getAction().moveToLibrary(c, libraryPos, sa, moveParams);
                } else if (destination.equals((Object)ZoneType.Battlefield)) {
                    GameEntity attachedTo;
                    HashMap<String, Object> params;
                    FCollection list;
                    moveParams.put(AbilityKey.SimultaneousETB, (Object)chosenCards);
                    if (sa.hasParam("Tapped")) {
                        c.setTapped(true);
                    }
                    if (sa.hasAdditionalAbility("AnimateSubAbility")) {
                        moveParams.put(AbilityKey.CardLKI, (Object)CardCopyService.getLKICopy(c));
                        SpellAbility animate = sa.getAdditionalAbility("AnimateSubAbility");
                        source.addRemembered(c);
                        AbilityUtils.resolve(animate);
                        source.removeRemembered(c);
                        animate.setSVar("unanimateTimestamp", String.valueOf(game.getTimestamp()));
                    }
                    if (sa.hasParam("GainControl")) {
                        Player newController;
                        String g2 = sa.getParam("GainControl");
                        Player player3 = newController = g2.equals("True") ? sa.getActivatingPlayer() : (Player)AbilityUtils.getDefinedPlayers(source, g2, sa).get(false);
                        if (newController != c.getController()) {
                            c.runChangeControllerCommands();
                        }
                        c.setController(newController, game.getNextTimestamp());
                    }
                    if (sa.hasParam("WithCountersType")) {
                        cType = CounterType.getType(sa.getParam("WithCountersType"));
                        int cAmount = AbilityUtils.calculateAmount(source, sa.getParamOrDefault("WithCountersAmount", "1"), sa);
                        table = new GameEntityCounterTable();
                        table.put(player, c, cType, cAmount);
                        moveParams.put(AbilityKey.CounterTable, (Object)table);
                    }
                    if (sa.hasParam("Transformed")) {
                        if (!c.isTransformable()) continue;
                        if (!moveParams.containsKey((Object)AbilityKey.CardLKI)) {
                            moveParams.put(AbilityKey.CardLKI, (Object)CardCopyService.getLKICopy(c));
                        }
                        c.changeCardState("Transform", null, sa);
                    }
                    if (sa.hasParam("AttachedTo") && c.isAttachment()) {
                        list = AbilityUtils.getDefinedCards(source, sa.getParam("AttachedTo"), sa);
                        if (list.isEmpty()) {
                            list = CardLists.getValidCards((Iterable<Card>)triggerList.getLastStateBattlefield(), sa.getParam("AttachedTo"), source.getController(), source, (CardTraitBase)sa);
                        }
                        if (!list.isEmpty()) {
                            list = CardLists.filter((Iterable<Card>)list, CardPredicates.canBeAttached(c, sa));
                        }
                        if (!list.isEmpty()) {
                            String title = Localizer.getInstance().getMessage("lblSelectACardAttachSourceTo", CardTranslation.getTranslatedName(c.getName()));
                            params = Maps.newHashMap();
                            params.put("Attach", c);
                            attachedTo = (Card)decider.getController().chooseSingleEntityForEffect(list, sa, title, params);
                            c.attachToEntity(game.getCardState((Card)attachedTo), sa, true);
                        } else if (c.isAura()) continue;
                    }
                    if (sa.hasParam("AttachedToPlayer")) {
                        list = AbilityUtils.getDefinedPlayers(source, sa.getParam("AttachedToPlayer"), sa);
                        if (list.isEmpty()) continue;
                        String title = Localizer.getInstance().getMessage("lblSelectACardAttachSourceTo", CardTranslation.getTranslatedName(c.getName()));
                        params = Maps.newHashMap();
                        params.put("Attach", c);
                        attachedTo = (Player)player.getController().chooseSingleEntityForEffect(list, sa, title, params);
                        c.attachToEntity(attachedTo, sa);
                    }
                    if (ChangeZoneEffect.addToCombat(c, sa, "Attacking", "Blocking")) {
                        combatChanged = true;
                    }
                    if (sa.hasParam("FaceDown")) {
                        c.turnFaceDown(true);
                        CardFactoryUtil.setFaceDownState(c, sa);
                    }
                    movedCard = game.getAction().moveToPlay(c, c.getController(), sa, moveParams);
                    if (sa.hasParam("AttachAfter") && movedCard.isAttachment() && movedCard.isInPlay()) {
                        list = AbilityUtils.getDefinedCards(source, sa.getParam("AttachAfter"), sa);
                        if (list.isEmpty()) {
                            list = CardLists.getValidCards((Iterable<Card>)game.getCardsIn(ZoneType.Battlefield), sa.getParam("AttachAfter"), c.getController(), c, (CardTraitBase)sa);
                        }
                        if (!list.isEmpty()) {
                            String title = Localizer.getInstance().getMessage("lblSelectACardAttachSourceTo", CardTranslation.getTranslatedName(c.getName()));
                            params = Maps.newHashMap();
                            params.put("Attach", movedCard);
                            attachedTo = (Card)decider.getController().chooseSingleEntityForEffect(list, sa, title, params);
                            movedCard.attachToEntity(attachedTo, sa);
                        }
                    }
                } else if (destination.equals((Object)ZoneType.Exile)) {
                    if (!c.canExiledBy(sa, true)) continue;
                    movedCard = game.getAction().exile(c, sa, moveParams);
                    ChangeZoneEffect.handleExiledWith(movedCard, sa);
                    if (sa.hasParam("ExileFaceDown")) {
                        movedCard.turnFaceDown(true);
                    }
                    if (sa.hasParam("Foretold")) {
                        movedCard.setForetold(true);
                        if (sa.hasParam("ForetoldCost")) {
                            movedCard.setForetoldCostByEffect(true);
                        }
                        movedCard.addMayLookTemp(sa.getActivatingPlayer());
                    }
                } else {
                    movedCard = game.getAction().moveTo(destination, c, 0, sa, moveParams);
                }
                movedCards.add(movedCard);
                if (originZone != null) {
                    if (c.getMeldedWith() != null && (meld = game.getCardState(c.getMeldedWith(), null)) != null && destination.equals((Object)ZoneType.Exile)) {
                        ChangeZoneEffect.handleExiledWith(meld, sa);
                    }
                    if (c.hasMergedCard()) {
                        meld = c.getMergedCards().iterator();
                        while (meld.hasNext()) {
                            Card card = (Card)meld.next();
                            if (card == c || !destination.equals((Object)ZoneType.Exile)) continue;
                            ChangeZoneEffect.handleExiledWith(c, sa);
                        }
                    }
                }
                if (champion) {
                    Map<AbilityKey, Object> runParams = AbilityKey.mapFromCard(source);
                    runParams.put(AbilityKey.Championed, c);
                    game.getTriggerHandler().runTrigger(TriggerType.Championed, runParams, false);
                }
                if (remember) {
                    source.addRemembered(movedCard);
                    if (c.getMeldedWith() != null && (meld = game.getCardState(c.getMeldedWith(), null)) != null) {
                        source.addRemembered(meld);
                    }
                    if (c.hasMergedCard()) {
                        meld = c.getMergedCards().iterator();
                        while (meld.hasNext()) {
                            Card card = (Card)meld.next();
                            if (card == c) continue;
                            source.addRemembered(card);
                        }
                    }
                }
                if (sa.hasParam("RememberLKI")) {
                    source.addRemembered(CardCopyService.getLKICopy(c));
                }
                if (forget) {
                    source.removeRemembered(movedCard);
                }
                if (imprint) {
                    source.addImprintedCard(movedCard);
                    if (c.hasMergedCard()) {
                        meld = c.getMergedCards().iterator();
                        while (meld.hasNext()) {
                            Card card = (Card)meld.next();
                            if (card == c) continue;
                            source.addImprintedCard(card);
                        }
                    }
                }
                if (!ZoneType.Exile.equals((Object)destination) || !sa.hasParam("WithCountersType")) continue;
                cType = CounterType.getType(sa.getParam("WithCountersType"));
                int cAmount = AbilityUtils.calculateAmount(sa.getOriginalHost(), sa.getParamOrDefault("WithCountersAmount", "1"), sa);
                table = new GameEntityCounterTable();
                movedCard.addCounter(cType, cAmount, player, table);
                table.replaceCounterEffect(game, sa, true);
            }
            if (!((ZoneType.Battlefield.equals((Object)destination) || changeType.isEmpty() || defined || changeType.equals("Card")) && (!sa.hasParam("Reveal") || movedCards.isEmpty()) || sa.hasParam("NoReveal"))) {
                game.getAction().reveal(movedCards, player);
            }
            if (origin.contains((Object)ZoneType.Library) && !destination.equals((Object)ZoneType.Library) && !defined && bl || sa.hasParam("Shuffle") && "True".equals(sa.getParam("Shuffle"))) {
                player.shuffle(sa);
            }
            if (!sa.hasParam("AtEOT") || movedCards.isEmpty()) continue;
            ChangeZoneEffect.registerDelayedTrigger(sa, sa.getParam("AtEOT"), movedCards);
        }
        if (combatChanged) {
            game.updateCombatForView();
            game.fireEvent(new GameEventCombatChanged());
        }
        triggerList.triggerChangesZoneAll(game, sa);
        if ("UntilHostLeavesPlay".equals(sa.getParam("Duration"))) {
            ChangeZoneEffect.addUntilCommand(sa, ChangeZoneEffect.untilHostLeavesPlayCommand(triggerList, sa));
        }
    }

    private void handleCastWhileSearching(CardCollection fetchList, Player decider) {
        CardCollection canCastWhileSearching = CardLists.getKeyword((Iterable<Card>)fetchList, "While you're searching your library, you may cast CARDNAME from your library.");
        decider.getController().tempShowCards(canCastWhileSearching);
        for (Card tgtCard : canCastWhileSearching) {
            List<SpellAbility> sas = AbilityUtils.getSpellsFromPlayEffect(tgtCard, decider, CardStateName.Original, true);
            if (sas.isEmpty()) continue;
            SpellAbility tgtSA = decider.getController().getAbilityToPlay(tgtCard, sas);
            if (!decider.getController().confirmAction(tgtSA, null, Localizer.getInstance().getMessage("lblDoYouWantPlayCard", CardTranslation.getTranslatedName(tgtCard.getName())), null) || !decider.getController().playSaFromPlayEffect(tgtSA)) continue;
            fetchList.remove(tgtCard);
        }
        decider.getController().endTempShowCards();
    }

    private static boolean allowMultiSelect(Player decider, SpellAbility sa) {
        return decider.getController().isGuiPlayer() && !sa.hasParam("Mandatory") && !sa.hasParam("ShareLandType") && !sa.hasParam("DifferentNames") && !sa.hasParam("DifferentPower") && !sa.hasParam("DifferentCMC") && !sa.hasParam("AtRandom") && (!sa.hasParam("Defined") || sa.hasParam("ChooseFromDefined")) && !sa.hasParam("WithTotalCMC") && !sa.hasParam("WithTotalPower") && !sa.hasParam("WithTotalCardTypes");
    }

    private void removeFromStack(SpellAbility tgtSA, SpellAbility srcSA, SpellAbilityStackInstance si, Game game, CardZoneTable triggerList, GameEntityCounterTable counterTable) {
        Card tgtHost = tgtSA.getHostCard();
        game.getStack().remove(si);
        EnumMap<AbilityKey, Object> params = AbilityKey.newMap();
        params.put(AbilityKey.StackSa, tgtSA);
        AbilityKey.addCardZoneTableParams(params, triggerList);
        Card movedCard = null;
        if (srcSA.hasParam("Destination")) {
            boolean remember = srcSA.hasParam("RememberChanged");
            boolean imprint = srcSA.hasParam("Imprint");
            if (!tgtSA.isAbility()) {
                if (srcSA.getParam("Destination").equals("Graveyard")) {
                    movedCard = game.getAction().moveToGraveyard(tgtHost, srcSA, params);
                } else if (srcSA.getParam("Destination").equals("Exile")) {
                    if (!tgtHost.canExiledBy(srcSA, true)) {
                        return;
                    }
                    movedCard = game.getAction().exile(tgtHost, srcSA, params);
                    ChangeZoneEffect.handleExiledWith(movedCard, srcSA);
                } else if (srcSA.getParam("Destination").equals("TopOfLibrary")) {
                    movedCard = game.getAction().moveToLibrary(tgtHost, srcSA, params);
                } else if (srcSA.getParam("Destination").equals("Hand")) {
                    movedCard = game.getAction().moveToHand(tgtHost, srcSA, params);
                } else if (srcSA.getParam("Destination").equals("BottomOfLibrary")) {
                    movedCard = game.getAction().moveToBottomOfLibrary(tgtHost, srcSA, params);
                } else if (srcSA.getParam("Destination").equals("Library")) {
                    int libraryPos = srcSA.hasParam("LibraryPosition") ? AbilityUtils.calculateAmount(tgtHost, srcSA.getParam("LibraryPosition"), srcSA) : 0;
                    movedCard = game.getAction().moveToLibrary(tgtHost, libraryPos, srcSA, params);
                    if (srcSA.hasParam("Shuffle") && "True".equals(srcSA.getParam("Shuffle"))) {
                        tgtHost.getOwner().shuffle(srcSA);
                    }
                } else {
                    throw new IllegalArgumentException("AbilityFactory_ChangeZone: Invalid Destination argument for card " + srcSA.getHostCard().getName());
                }
            }
            if (srcSA.hasParam("WithCountersType")) {
                Player placer = srcSA.getActivatingPlayer();
                if (srcSA.hasParam("WithCountersPlacer")) {
                    placer = (Player)AbilityUtils.getDefinedPlayers(srcSA.getHostCard(), srcSA.getParam("WithCountersPlacer"), srcSA).get(false);
                }
                CounterType cType = CounterType.getType(srcSA.getParam("WithCountersType"));
                int cAmount = AbilityUtils.calculateAmount(srcSA.getHostCard(), srcSA.getParamOrDefault("WithCountersAmount", "1"), srcSA);
                movedCard.addCounter(cType, cAmount, placer, counterTable);
            }
            if (remember) {
                srcSA.getHostCard().addRemembered(tgtHost);
            }
            if (imprint) {
                srcSA.getHostCard().addImprintedCard(tgtHost);
            }
            if (!tgtSA.isAbility()) {
                System.out.println("Moving spell to " + srcSA.getParam("Destination"));
            }
        }
    }

    private Pair<ZoneType, Integer> handleAltDest(SpellAbility sa, Card host, ZoneType dest1, int libPos1, Player p) {
        boolean allowAltDest = true;
        boolean altDestOpt = true;
        if (sa.hasParam("DestAltSVar")) {
            allowAltDest = false;
            String sVar = sa.getParam("DestAltSVar");
            if (sVar.startsWith("MANDATORY ")) {
                altDestOpt = false;
                sVar = sVar.replace("MANDATORY ", "");
            }
            String comparator = sa.getParamOrDefault("DestAltSVarCompare", "GE1");
            String compareTo = comparator.substring(2);
            int x = AbilityUtils.calculateAmount(host, sVar, sa);
            if (Expressions.compare(x, comparator, AbilityUtils.calculateAmount(host, compareTo, sa))) {
                allowAltDest = true;
            }
        }
        ZoneType dest2 = ZoneType.smartValueOf(sa.getParam("DestinationAlternative"));
        Pair<ZoneType, Integer> alt = Pair.of(dest2, Integer.parseInt(sa.getParamOrDefault("LibraryPositionAlternative", "0")));
        if (allowAltDest && !altDestOpt) {
            return alt;
        }
        if (allowAltDest) {
            boolean topBot = dest1.equals((Object)ZoneType.Library) && dest2.equals((Object)ZoneType.Library);
            String prompt = Localizer.getInstance().getMessage(topBot ? "lblChooseLibraryPosition" : "lblChooseDestination", new Object[0]);
            List<String> options = topBot ? Arrays.asList(Localizer.getInstance().getMessage("lblTop", new Object[0]) + (libPos1 == 0 ? "" : " (" + Lang.getInstance().getOrdinal(libPos1 + 1) + ")"), Localizer.getInstance().getMessage("lblBottom", new Object[0])) : Arrays.asList(StringUtils.capitalize(dest1.getTranslatedName()), StringUtils.capitalize(dest2.getTranslatedName()));
            Player decider = p;
            if (sa.hasParam("AlternativeDecider")) {
                PlayerCollection c = AbilityUtils.getDefinedPlayers(host, sa.getParam("AlternativeDecider"), sa);
                Player player = decider = c.isEmpty() ? null : (Player)c.get(false);
            }
            if (decider != null && !decider.getController().confirmAction(sa, PlayerActionConfirmMode.ChangeZoneToAltDestination, prompt, options, null, null)) {
                return alt;
            }
        }
        return Pair.of(dest1, libPos1);
    }

    private static class HiddenOriginChoices {
        boolean shuffleMandatory;
        boolean searchedLibrary;
        CardCollection chosenCards;
        int libraryPos;
        List<ZoneType> origin;
        ZoneType destination;

        private HiddenOriginChoices() {
        }
    }
}

