/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import com.google.common.collect.Iterables;
import forge.game.CardTraitBase;
import forge.game.Game;
import forge.game.GameActionUtil;
import forge.game.GameEntityCounterTable;
import forge.game.ability.AbilityKey;
import forge.game.ability.AbilityUtils;
import forge.game.ability.SpellAbilityEffect;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardCopyService;
import forge.game.card.CardFactoryUtil;
import forge.game.card.CardLists;
import forge.game.card.CardZoneTable;
import forge.game.card.CounterType;
import forge.game.player.Player;
import forge.game.player.PlayerCollection;
import forge.game.spellability.SpellAbility;
import forge.game.zone.Zone;
import forge.game.zone.ZoneType;
import forge.util.Lang;
import forge.util.Localizer;
import forge.util.TextUtil;
import java.util.EnumMap;
import java.util.List;

public class ChangeZoneAllEffect
extends SpellAbilityEffect {
    @Override
    protected String getStackDescription(SpellAbility sa) {
        String[] desc = sa.getDescription().split(":");
        if (desc.length > 1) {
            return desc[1];
        }
        return desc[0];
    }

    @Override
    public void resolve(SpellAbility sa) {
        int libraryPos;
        CardCollection cards;
        if (!ChangeZoneAllEffect.checkValidDuration(sa.getParam("Duration"), sa)) {
            return;
        }
        Card source = sa.getHostCard();
        ZoneType destination = ZoneType.smartValueOf(sa.getParam("Destination"));
        List<ZoneType> origin = ZoneType.listValueOf(sa.getParam("Origin"));
        PlayerCollection tgtPlayers = ChangeZoneAllEffect.getTargetPlayers(sa);
        Game game = sa.getActivatingPlayer().getGame();
        if (!sa.usesTargeting() && !sa.hasParam("Defined") || sa.hasParam("UseAllOriginZones")) {
            cards = new CardCollection(game.getCardsIn(origin));
            tgtPlayers = game.getPlayers();
        } else {
            cards = tgtPlayers.getCardsIn(origin);
        }
        if (sa.hasParam("Optional")) {
            String targets = Lang.joinHomogenous(cards);
            String message = sa.hasParam("OptionQuestion") ? TextUtil.fastReplace(sa.getParam("OptionQuestion"), "TARGETS", targets) : Localizer.getInstance().getMessage("lblMoveTargetFromOriginToDestination", targets, Lang.joinHomogenous(origin, ZoneType::getTranslatedName), destination.getTranslatedName());
            if (!sa.getActivatingPlayer().getController().confirmAction(sa, null, message, null)) {
                return;
            }
        }
        cards = (CardCollection)AbilityUtils.filterListByType(cards, sa.getParam("ChangeType"), sa);
        if (sa.hasParam("TypeLimit")) {
            cards = new CardCollection(Iterables.limit(cards, AbilityUtils.calculateAmount(source, sa.getParam("TypeLimit"), sa)));
        }
        if (sa.hasParam("ForgetOtherRemembered")) {
            source.clearRemembered();
        }
        String remember = sa.getParam("RememberChanged");
        String forget = sa.getParam("ForgetChanged");
        String imprint = sa.getParam("Imprint");
        boolean random = sa.hasParam("RandomOrder");
        boolean remLKI = sa.hasParam("RememberLKI");
        boolean movingToDeck = destination.isDeck();
        int n = libraryPos = sa.hasParam("LibraryPosition") ? Integer.parseInt(sa.getParam("LibraryPosition")) : 0;
        if (!random && !sa.hasParam("Shuffle")) {
            if (movingToDeck && cards.size() >= 2) {
                Player p = (Player)AbilityUtils.getDefinedPlayers(source, sa.getParam("DefinedPlayer"), sa).get(false);
                cards = (CardCollection)p.getController().orderMoveToZoneList(cards, destination, sa);
            } else {
                cards = (CardCollection)GameActionUtil.orderCardsByTheirOwners(game, cards, destination, sa);
            }
        }
        if (movingToDeck && random) {
            CardLists.shuffle(cards);
        }
        CardZoneTable triggerList = CardZoneTable.getSimultaneousInstance(sa);
        for (Card c : cards) {
            Zone originZone = game.getZoneOf(c);
            if (sa.hasParam("Fizzle") && (originZone.is(ZoneType.Exile) || originZone.is(ZoneType.Hand) || originZone.is(ZoneType.Stack))) {
                game.getStack().remove(c);
            }
            if (remLKI) {
                source.addRemembered(CardCopyService.getLKICopy(c));
            }
            EnumMap<AbilityKey, Object> moveParams = AbilityKey.newMap();
            AbilityKey.addCardZoneTableParams(moveParams, triggerList);
            if (destination == ZoneType.Battlefield) {
                moveParams.put(AbilityKey.SimultaneousETB, (Object)cards);
                if (sa.hasAdditionalAbility("AnimateSubAbility")) {
                    moveParams.put(AbilityKey.CardLKI, (Object)CardCopyService.getLKICopy(c));
                    SpellAbility animate = sa.getAdditionalAbility("AnimateSubAbility");
                    source.addRemembered(c);
                    AbilityUtils.resolve(animate);
                    source.removeRemembered(c);
                    animate.setSVar("unanimateTimestamp", String.valueOf(game.getTimestamp()));
                }
                if (sa.hasParam("Tapped")) {
                    c.setTapped(true);
                }
                if (sa.hasParam("FaceDown")) {
                    c.turnFaceDown(true);
                    CardFactoryUtil.setFaceDownState(c, sa);
                }
                if (sa.hasParam("WithCountersType")) {
                    CounterType cType = CounterType.getType(sa.getParam("WithCountersType"));
                    int cAmount = AbilityUtils.calculateAmount(c, sa.getParamOrDefault("WithCountersAmount", "1"), sa);
                    GameEntityCounterTable table = new GameEntityCounterTable();
                    table.put(sa.getActivatingPlayer(), c, cType, cAmount);
                    moveParams.put(AbilityKey.CounterTable, (Object)table);
                }
            }
            Card movedCard = null;
            if (sa.hasParam("GainControl")) {
                c.setController(sa.getActivatingPlayer(), game.getNextTimestamp());
                movedCard = game.getAction().moveToPlay(c, sa.getActivatingPlayer(), sa, moveParams);
            } else {
                if (destination == ZoneType.Exile && !c.canExiledBy(sa, true)) continue;
                movedCard = game.getAction().moveTo(destination, c, libraryPos, sa, moveParams);
                if (destination == ZoneType.Exile) {
                    ChangeZoneAllEffect.handleExiledWith(movedCard, sa);
                }
                if (sa.hasParam("ExileFaceDown")) {
                    movedCard.turnFaceDown(true);
                }
            }
            if (movedCard.getZone().equals(originZone)) continue;
            if (remember != null && (remember.equalsIgnoreCase("True") || movedCard.isValid(remember, sa.getActivatingPlayer(), source, (CardTraitBase)sa))) {
                Card meld;
                if (!source.isRemembered(movedCard)) {
                    source.addRemembered(movedCard);
                }
                if (c.getMeldedWith() != null && (meld = game.getCardState(c.getMeldedWith(), null)) != null && !source.isRemembered(meld)) {
                    source.addRemembered(meld);
                }
                if (c.hasMergedCard()) {
                    for (Card card : c.getMergedCards()) {
                        if (card == c || source.isRemembered(card)) continue;
                        source.addRemembered(card);
                    }
                }
            }
            if (forget != null) {
                source.removeRemembered(c);
            }
            if (imprint == null) continue;
            source.addImprintedCard(movedCard);
        }
        triggerList.triggerChangesZoneAll(game, sa);
        if (sa.hasParam("Duration")) {
            ChangeZoneAllEffect.addUntilCommand(sa, ChangeZoneAllEffect.untilHostLeavesPlayCommand(triggerList, sa));
        }
        if (sa.hasParam("Shuffle")) {
            for (Player p : tgtPlayers) {
                p.shuffle(sa);
            }
        }
    }
}

