/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import com.google.common.collect.Lists;
import forge.game.Game;
import forge.game.ability.AbilityKey;
import forge.game.ability.AbilityUtils;
import forge.game.ability.SpellAbilityEffect;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardCopyService;
import forge.game.combat.Combat;
import forge.game.event.GameEventCombatChanged;
import forge.game.spellability.SpellAbility;
import forge.game.trigger.TriggerType;
import forge.util.Lang;
import java.util.ArrayList;
import java.util.EnumMap;

public class BlockEffect
extends SpellAbilityEffect {
    @Override
    public void resolve(SpellAbility sa) {
        Card host = sa.getHostCard();
        Game game = host.getGame();
        Combat combat = game.getPhaseHandler().getCombat();
        ArrayList<Object> attackers = new ArrayList<Object>();
        if (sa.hasParam("DefinedAttacker")) {
            for (Object attacker : AbilityUtils.getDefinedCards(host, sa.getParam("DefinedAttacker"), sa)) {
                if (!combat.isAttacking((Card)attacker)) continue;
                attackers.add(attacker);
            }
        }
        ArrayList<Card> blockers = new ArrayList<Card>();
        if (sa.hasParam("DefinedBlocker")) {
            for (Object blocker : AbilityUtils.getDefinedCards(host, sa.getParam("DefinedBlocker"), sa)) {
                if (!((Card)blocker).isCreature() || !((Card)blocker).isInPlay()) continue;
                blockers.add((Card)blocker);
            }
        }
        if (attackers.size() == 0 || blockers.size() == 0) {
            return;
        }
        ArrayList<Card> blocked = Lists.newArrayList();
        for (Card card : attackers) {
            boolean wasBlocked = combat.isBlocked(card);
            for (Card blocker : blockers) {
                if (combat.isBlocking(blocker, card)) continue;
                combat.addBlocker(card, blocker);
                combat.orderAttackersForDamageAssignment(blocker);
                blocker.addBlockedThisTurn(CardCopyService.getLKICopy(card));
                card.addBlockedByThisTurn(CardCopyService.getLKICopy(blocker));
                EnumMap<AbilityKey, Object> runParams = AbilityKey.newMap();
                runParams.put(AbilityKey.Attacker, card);
                runParams.put(AbilityKey.Blocker, blocker);
                game.getTriggerHandler().runTrigger(TriggerType.AttackerBlockedByCreature, runParams, false);
                runParams = AbilityKey.newMap();
                runParams.put(AbilityKey.Blocker, (Object)blocker);
                runParams.put(AbilityKey.Attackers, (Object)card);
                game.getTriggerHandler().runTrigger(TriggerType.Blocks, runParams, false);
            }
            card.getDamageHistory().setCreatureGotBlockedThisCombat(true);
            if (wasBlocked) continue;
            blocked.add(card);
            EnumMap<AbilityKey, Object> runParams = AbilityKey.newMap();
            runParams.put(AbilityKey.Attacker, card);
            runParams.put(AbilityKey.Blockers, blockers);
            runParams.put(AbilityKey.Defender, combat.getDefenderByAttacker(card));
            runParams.put(AbilityKey.DefendingPlayer, combat.getDefenderPlayerByAttacker(card));
            game.getTriggerHandler().runTrigger(TriggerType.AttackerBlocked, runParams, false);
            combat.orderBlockersForDamageAssignment(card, new CardCollection((Iterable<Card>)blockers));
        }
        if (!blocked.isEmpty()) {
            EnumMap<AbilityKey, Object> runParams = AbilityKey.newMap();
            runParams.put(AbilityKey.Attackers, blocked);
            game.getTriggerHandler().runTrigger(TriggerType.AttackerBlockedOnce, runParams, false);
        }
        game.updateCombatForView();
        game.fireEvent(new GameEventCombatChanged());
    }

    @Override
    protected String getStackDescription(SpellAbility sa) {
        StringBuilder sb = new StringBuilder();
        ArrayList<String> attackers = new ArrayList<String>();
        if (sa.hasParam("DefinedAttacker")) {
            for (Card attacker : AbilityUtils.getDefinedCards(sa.getHostCard(), sa.getParam("DefinedAttacker"), sa)) {
                attackers.add(attacker.toString());
            }
        }
        ArrayList<String> blockers = new ArrayList<String>();
        if (sa.hasParam("DefinedBlocker")) {
            for (Card blocker : AbilityUtils.getDefinedCards(sa.getHostCard(), sa.getParam("DefinedBlocker"), sa)) {
                blockers.add(blocker.toString());
            }
        }
        sb.append(Lang.joinHomogenous(blockers)).append(" block ").append(Lang.joinHomogenous(attackers));
        return sb.toString();
    }
}

