/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import forge.game.CardTraitBase;
import forge.game.Game;
import forge.game.GameActionUtil;
import forge.game.GameEntity;
import forge.game.GameObject;
import forge.game.ability.AbilityKey;
import forge.game.ability.AbilityUtils;
import forge.game.ability.SpellAbilityEffect;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardCollectionView;
import forge.game.card.CardLists;
import forge.game.card.CardPredicates;
import forge.game.card.CardZoneTable;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.game.zone.ZoneType;
import forge.util.CardTranslation;
import forge.util.Lang;
import forge.util.Localizer;
import forge.util.collect.FCollection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;

public class AttachEffect
extends SpellAbilityEffect {
    @Override
    public void resolve(SpellAbility sa) {
        Object attachTo;
        Object title;
        HashMap<String, Object> params;
        CardCollectionView attachments;
        Player activator = sa.getActivatingPlayer();
        Card source = sa.getHostCard();
        Game game = source.getGame();
        Player chooser = activator;
        if (sa.hasParam("Chooser")) {
            chooser = Iterables.getFirst(AbilityUtils.getDefinedPlayers(source, sa.getParam("Chooser"), sa), null);
        }
        if (sa.hasParam("Object")) {
            attachments = AbilityUtils.getDefinedCards(source, sa.getParam("Object"), sa);
        } else if (sa.hasParam("Choices")) {
            ZoneType choiceZone = ZoneType.Battlefield;
            if (sa.hasParam("ChoiceZone")) {
                choiceZone = ZoneType.smartValueOf(sa.getParam("ChoiceZone"));
            }
            String title2 = sa.hasParam("ChoiceTitle") ? sa.getParam("ChoiceTitle") : Localizer.getInstance().getMessage("lblChoose", new Object[0]) + " ";
            CardCollection choices = CardLists.getValidCards((Iterable<Card>)game.getCardsIn(choiceZone), sa.getParam("Choices"), activator, source, (CardTraitBase)sa);
            params = Maps.newHashMap();
            params.put("Target", Iterables.getFirst(AttachEffect.getDefinedEntitiesOrTargeted(sa, "Defined"), null));
            Card c = chooser.getController().chooseSingleEntityForEffect(choices, sa, title2, params);
            if (c == null) {
                return;
            }
            attachments = new CardCollection(c);
        } else {
            attachments = new CardCollection(source);
        }
        if (attachments.isEmpty()) {
            return;
        }
        if (sa.hasParam("Object") && (sa.hasParam("Choices") || sa.hasParam("PlayerChoices"))) {
            ZoneType choiceZone = ZoneType.Battlefield;
            if (sa.hasParam("ChoiceZone")) {
                choiceZone = ZoneType.smartValueOf(sa.getParam("ChoiceZone"));
            }
            title = sa.hasParam("ChoiceTitle") ? sa.getParam("ChoiceTitle") : Localizer.getInstance().getMessage("lblChoose", new Object[0]) + " ";
            FCollection<Object> choices = new FCollection();
            if (sa.hasParam("PlayerChoices")) {
                choices = AbilityUtils.getDefinedEntities(source, sa.getParam("PlayerChoices"), (CardTraitBase)sa);
                for (Object attachment : attachments) {
                    for (GameEntity gameEntity : choices) {
                        if (gameEntity.canBeAttached((Card)attachment, sa)) continue;
                        choices.remove(gameEntity);
                    }
                }
            } else {
                CardCollection cardChoices = CardLists.getValidCards((Iterable<Card>)game.getCardsIn(choiceZone), sa.getParam("Choices"), activator, source, (CardTraitBase)sa);
                for (Card attachment : attachments) {
                    Card card;
                    if (sa.hasParam("Move") && (card = attachment.getAttachedTo()) != null) {
                        cardChoices.remove(card);
                    }
                    cardChoices = CardLists.filter((Iterable<Card>)cardChoices, CardPredicates.canBeAttached(attachment, sa));
                }
                choices.addAll(cardChoices);
            }
            HashMap<String, Object> params2 = Maps.newHashMap();
            params2.put("Attachments", attachments);
            attachTo = chooser.getController().chooseSingleEntityForEffect(choices, sa, (String)title, params2);
        } else {
            FCollection<GameEntity> targets = new FCollection<GameEntity>(AttachEffect.getDefinedEntitiesOrTargeted(sa, "Defined"));
            if (targets.isEmpty()) {
                return;
            }
            title = Localizer.getInstance().getMessage("lblChoose", new Object[0]);
            params = Maps.newHashMap();
            params.put("Attachments", attachments);
            attachTo = chooser.getController().chooseSingleEntityForEffect(targets, sa, (String)title, params);
        }
        if (attachTo == null) {
            return;
        }
        String attachToName = attachTo instanceof Card ? CardTranslation.getTranslatedName(((Card)attachTo).getName()) : ((GameEntity)attachTo).toString();
        attachments = GameActionUtil.orderCardsByTheirOwners(game, attachments, ZoneType.Battlefield, sa);
        for (Card attachment : attachments) {
            Card gameCard = attachment.getGame().getCardState(attachment, null);
            if (gameCard == null || !attachment.equalsWithGameTimestamp(gameCard)) continue;
            String message = Localizer.getInstance().getMessage("lblDoYouWantAttachSourceToTarget", CardTranslation.getTranslatedName(attachment.getName()), attachToName);
            if (sa.hasParam("Optional") && !activator.getController().confirmAction(sa, null, message, null)) continue;
            attachment.attachToEntity((GameEntity)attachTo, sa);
            if (!sa.hasParam("RememberAttached") || !attachment.isAttachedToEntity((GameEntity)attachTo)) continue;
            source.addRemembered(attachment);
        }
        if (source.isAura() && sa.isSpell()) {
            CardZoneTable table = new CardZoneTable();
            source.setController(activator, 0L);
            ZoneType previousZone = source.getZone().getZoneType();
            EnumMap<AbilityKey, Object> moveParams = AbilityKey.newMap();
            moveParams.put(AbilityKey.LastStateBattlefield, game.copyLastStateBattlefield());
            moveParams.put(AbilityKey.LastStateGraveyard, game.copyLastStateGraveyard());
            Card c = game.getAction().moveToPlay(source, source.getController(), sa, moveParams);
            ZoneType newZone = c.getZone().getZoneType();
            if (newZone != previousZone) {
                table.put(previousZone, newZone, c);
            }
            table.triggerChangesZoneAll(game, sa);
        }
    }

    @Override
    protected String getStackDescription(SpellAbility sa) {
        StringBuilder sb = new StringBuilder();
        sb.append(" ").append(Localizer.getInstance().getMessage("lblAttachTo", new Object[0])).append(" ");
        List<GameObject> targets = AttachEffect.getTargets(sa);
        sb.append(Lang.joinHomogenous(targets));
        return sb.toString();
    }
}

