/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import forge.card.CardType;
import forge.card.ColorSet;
import forge.game.Game;
import forge.game.ability.AbilityUtils;
import forge.game.ability.effects.AnimateEffectBase;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.event.GameEventCardStatsChanged;
import forge.game.spellability.SpellAbility;
import forge.util.Lang;
import forge.util.TextUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public class AnimateEffect
extends AnimateEffectBase {
    @Override
    public void resolve(SpellAbility sa) {
        Card source = sa.getHostCard();
        String duration = sa.getParam("Duration");
        String animateRemembered = null;
        String animateImprinted = null;
        if (!AnimateEffect.checkValidDuration(duration, sa)) {
            return;
        }
        if (sa.hasParam("RememberObjects")) {
            animateRemembered = sa.getParam("RememberObjects");
        }
        if (sa.hasParam("ImprintCards")) {
            animateImprinted = sa.getParam("ImprintCards");
        }
        Integer power = null;
        if (sa.hasParam("Power")) {
            power = AbilityUtils.calculateAmount(source, sa.getParam("Power"), sa);
        }
        Integer toughness = null;
        if (sa.hasParam("Toughness")) {
            toughness = AbilityUtils.calculateAmount(source, sa.getParam("Toughness"), sa);
        }
        Game game = sa.getActivatingPlayer().getGame();
        long timestamp = game.getNextTimestamp();
        CardType types = new CardType(true);
        if (sa.hasParam("Types")) {
            types.addAll(Arrays.asList(sa.getParam("Types").split(",")));
        }
        CardType removeTypes = new CardType(true);
        if (sa.hasParam("RemoveTypes")) {
            removeTypes.addAll(Arrays.asList(sa.getParam("RemoveTypes").split(",")));
        }
        if (types.hasSubtype("ChosenType")) {
            types.clear();
            types.add(source.getChosenType());
        } else if (types.hasSubtype("ChosenType2")) {
            types.clear();
            types.add(source.getChosenType2());
        }
        ArrayList<String> keywords = Lists.newArrayList();
        if (sa.hasParam("Keywords")) {
            keywords.addAll(Arrays.asList(sa.getParam("Keywords").split(" & ")));
        }
        ArrayList<String> removeKeywords = Lists.newArrayList();
        if (sa.hasParam("RemoveKeywords")) {
            removeKeywords.addAll(Arrays.asList(sa.getParam("RemoveKeywords").split(" & ")));
        }
        ArrayList<String> hiddenKeywords = Lists.newArrayList();
        if (sa.hasParam("HiddenKeywords")) {
            hiddenKeywords.addAll(Arrays.asList(sa.getParam("HiddenKeywords").split(" & ")));
        }
        for (int i = 0; i < keywords.size(); ++i) {
            String k = (String)keywords.get(i);
            if (!source.hasSVar(k)) continue;
            keywords.add(source.getSVar(k));
            keywords.remove(k);
        }
        ColorSet finalColors = null;
        if (sa.hasParam("Colors")) {
            String colors = sa.getParam("Colors");
            finalColors = colors.equals("ChosenColor") ? ColorSet.fromNames(source.getChosenColors()) : ColorSet.fromNames(Arrays.asList(colors.split(",")));
        }
        ArrayList<String> abilities = Lists.newArrayList();
        if (sa.hasParam("Abilities")) {
            abilities.addAll(Arrays.asList(sa.getParam("Abilities").split(",")));
        }
        ArrayList<String> replacements = Lists.newArrayList();
        if (sa.hasParam("Replacements")) {
            replacements.addAll(Arrays.asList(sa.getParam("Replacements").split(",")));
        }
        ArrayList<String> triggers = Lists.newArrayList();
        if (sa.hasParam("Triggers")) {
            triggers.addAll(Arrays.asList(sa.getParam("Triggers").split(",")));
        }
        ArrayList<String> stAbs = Lists.newArrayList();
        if (sa.hasParam("staticAbilities")) {
            stAbs.addAll(Arrays.asList(sa.getParam("staticAbilities").split(",")));
        }
        HashMap<String, String> sVarsMap = Maps.newHashMap();
        if (sa.hasParam("sVars")) {
            for (String s2 : sa.getParam("sVars").split(",")) {
                String actualsVar = AbilityUtils.getSVar(sa, s2);
                String name = s2;
                if (actualsVar.startsWith("SVar:")) {
                    actualsVar = actualsVar.split("SVar:")[1];
                    name = actualsVar.split(":")[0];
                    actualsVar = actualsVar.split(":")[1];
                }
                sVarsMap.put(name, actualsVar);
            }
        }
        List<Card> tgts = AnimateEffect.getCardsfromTargets(sa);
        if (sa.hasParam("Optional")) {
            String message;
            String targets = Lang.joinHomogenous(tgts);
            String string = message = sa.hasParam("OptionQuestion") ? TextUtil.fastReplace(sa.getParam("OptionQuestion"), "TARGETS", targets) : this.getStackDescription(sa);
            if (!sa.getActivatingPlayer().getController().confirmAction(sa, null, message, null)) {
                return;
            }
        }
        for (Card c : tgts) {
            if (c.isPhasedOut()) continue;
            AnimateEffect.doAnimate(c, sa, power, toughness, types, removeTypes, finalColors, keywords, removeKeywords, hiddenKeywords, abilities, triggers, replacements, stAbs, timestamp, duration);
            if (sa.hasParam("Name")) {
                c.addChangedName(sa.getParam("Name"), false, timestamp, 0L);
            }
            if (!sVarsMap.isEmpty()) {
                c.addChangedSVars(sVarsMap, timestamp, 0L);
            }
            if (animateRemembered != null) {
                c.addRemembered(AbilityUtils.getDefinedObjects(source, animateRemembered, sa));
            }
            if (animateImprinted != null) {
                c.addImprintedCards(AbilityUtils.getDefinedCards(source, animateImprinted, sa));
            }
            if (sa.isCrew()) {
                c.becomesCrewed(sa);
                c.updatePowerToughnessForView();
            }
            game.fireEvent(new GameEventCardStatsChanged(c));
        }
        if (sa.hasParam("AtEOT") && !tgts.isEmpty()) {
            AnimateEffect.registerDelayedTrigger(sa, sa.getParam("AtEOT"), tgts);
        }
    }

    @Override
    protected String getStackDescription(SpellAbility sa) {
        boolean justOne;
        Card host = sa.getHostCard();
        StringBuilder sb = new StringBuilder();
        CardCollection tgts = AnimateEffect.getDefinedCardsOrTargeted(sa);
        boolean bl = justOne = tgts.size() <= 1;
        if (sa.hasParam("IfDesc")) {
            if (sa.getParam("IfDesc").equals("True") && sa.hasParam("SpellDescription")) {
                String ifDesc = sa.getParam("SpellDescription");
                sb.append(ifDesc, 0, ifDesc.indexOf(",") + 1);
            } else {
                AnimateEffect.tokenizeString(sa, sb, sa.getParam("IfDesc"));
            }
            sb.append(" ");
        }
        sb.append(sa.hasParam("DefinedDesc") ? sa.getParam("DefinedDesc") : Lang.joinHomogenous(tgts));
        sb.append(" ");
        int initial = sb.length();
        boolean becomes = false;
        Integer power = null;
        if (sa.hasParam("Power")) {
            power = AbilityUtils.calculateAmount(host, sa.getParam("Power"), sa);
        }
        Integer toughness = null;
        if (sa.hasParam("Toughness")) {
            toughness = AbilityUtils.calculateAmount(host, sa.getParam("Toughness"), sa);
        }
        boolean permanent = "Permanent".equals(sa.getParam("Duration"));
        ArrayList<String> types = Lists.newArrayList();
        if (sa.hasParam("Types")) {
            types.addAll(Arrays.asList(sa.getParam("Types").split(",")));
            becomes = true;
        }
        ArrayList<String> keywords = Lists.newArrayList();
        if (sa.hasParam("Keywords")) {
            keywords.addAll(Arrays.asList(sa.getParam("Keywords").split(" & ")));
        }
        for (int i = 0; i < keywords.size(); ++i) {
            String k = (String)keywords.get(i);
            if (!sa.hasSVar(k)) continue;
            keywords.add("\"" + k + "\"");
            keywords.remove(k);
        }
        ArrayList<String> colors = Lists.newArrayList();
        if (sa.hasParam("Colors")) {
            colors.addAll(Arrays.asList(sa.getParam("Colors").split(",")));
            becomes = true;
        }
        if (power != null || toughness != null) {
            sb.append(justOne ? "has" : "have").append(" base ");
            if (power != null && toughness != null) {
                sb.append("power and toughness ").append(power).append("/").append(toughness).append(" ");
            } else if (power != null) {
                sb.append("power ").append(power).append(" ");
            } else {
                sb.append("toughness ").append(toughness).append(" ");
            }
        }
        if (sb.length() > initial && becomes) {
            sb.append(" and ");
        }
        if (becomes) {
            sb.append(justOne ? "becomes " : "become ");
        }
        if (colors.contains("ChosenColor")) {
            sb.append("color of that player's choice");
        } else {
            for (int i = 0; i < colors.size(); ++i) {
                sb.append(((String)colors.get(i)).toLowerCase()).append(" ");
                if (i >= colors.size() - 1) continue;
                sb.append("and ");
            }
        }
        if (types.contains("ChosenType")) {
            sb.append("type of player's choice ");
        } else {
            for (int i = 0; i < types.size(); ++i) {
                String type = (String)types.get(i);
                if (i == 0 && justOne) {
                    sb.append(Lang.startsWithVowel(type) ? "an " : "a ");
                }
                sb.append(CardType.CoreType.isValidEnum(type) ? type.toLowerCase() : type).append(" ");
            }
        }
        if (keywords.size() > 0) {
            sb.append(sb.length() > initial ? "and " : "").append(" gains ");
            sb.append(Lang.joinHomogenous(keywords).toLowerCase()).append(" ");
        }
        if (!permanent && sb.length() > initial) {
            String duration = sa.getParam("Duration");
            if ("UntilEndOfCombat".equals(duration)) {
                sb.append("until end of combat");
            } else if ("UntilHostLeavesPlay".equals(duration)) {
                sb.append("until ").append(host).append(" leaves the battlefield");
            } else if ("UntilYourNextUpkeep".equals(duration)) {
                sb.append("until your next upkeep");
            } else if ("UntilYourNextTurn".equals(duration)) {
                sb.append("until your next turn");
            } else if ("UntilControllerNextUntap".equals(duration)) {
                sb.append("until its controller's next untap step");
            } else {
                sb.append("until end of turn");
            }
        }
        if (sa.hasParam("staticAbilities") && sa.getParam("staticAbilities").contains("MustAttack")) {
            sb.append(sb.length() > initial ? " and " : "");
            sb.append(justOne ? "attacks" : "attack").append(" this turn if able");
        }
        sb.append(".");
        if (sa.hasParam("AtEOT")) {
            String pronoun;
            sb.append(" ");
            String eot = sa.getParam("AtEOT");
            String string = pronoun = justOne ? "it" : "them";
            if (eot.equals("Hand")) {
                sb.append("Return ").append(pronoun).append(" to your hand");
            } else if (eot.equals("SacrificeCtrl")) {
                sb.append(justOne ? "Its controller sacrifices it" : "Their controllers sacrifice them");
            } else {
                sb.append(eot).append(" ").append(pronoun);
            }
            sb.append(" at the beginning of the next end step.");
        }
        return sb.toString();
    }
}

