/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import forge.card.CardType;
import forge.card.RemoveType;
import forge.game.Game;
import forge.game.GameEntityCounterTable;
import forge.game.ability.AbilityUtils;
import forge.game.ability.effects.TokenEffectBase;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardLists;
import forge.game.card.CardPredicates;
import forge.game.card.CardZoneTable;
import forge.game.card.CounterEnumType;
import forge.game.card.CounterType;
import forge.game.card.token.TokenInfo;
import forge.game.event.GameEventCombatChanged;
import forge.game.event.GameEventTokenCreated;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.game.zone.ZoneType;
import forge.util.Lang;
import forge.util.Localizer;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Set;
import org.apache.commons.lang3.mutable.MutableBoolean;

public class AmassEffect
extends TokenEffectBase {
    @Override
    protected String getStackDescription(SpellAbility sa) {
        StringBuilder sb = new StringBuilder("Amass ");
        Card card = sa.getHostCard();
        int amount = AbilityUtils.calculateAmount(card, sa.getParamOrDefault("Num", "1"), sa);
        String type = sa.getParam("Type");
        sb.append(CardType.getPluralType(type)).append(" ").append(amount).append(" (Put ");
        sb.append(Lang.nounWithNumeral(amount, "+1/+1 counter"));
        sb.append("on an Army you control. If you don't control one, create a 0/0 black " + type + " Army creature token first.)");
        return sb.toString();
    }

    @Override
    public void resolve(SpellAbility sa) {
        CardCollection tgtCards;
        Card source = sa.getHostCard();
        Game game = source.getGame();
        Player activator = sa.getActivatingPlayer();
        int amount = AbilityUtils.calculateAmount(source, sa.getParamOrDefault("Num", "1"), sa);
        String type = sa.getParam("Type");
        if (!Iterables.any(activator.getCardsIn(ZoneType.Battlefield), CardPredicates.isType("Army"))) {
            CardZoneTable triggerList = new CardZoneTable();
            MutableBoolean combatChanged = new MutableBoolean(false);
            StringBuilder sb = new StringBuilder("b_0_0_");
            sb.append(sa.getOriginalParam("Type").toLowerCase()).append("_army");
            Card result = TokenInfo.getProtoType(sb.toString(), sa, activator, false);
            result.setCreatureTypes(Lists.newArrayList(type, "Army"));
            result.setName(type + " Army Token");
            result.setTokenSpawningAbility(sa);
            this.makeTokenTable(this.makeTokenTableInternal(activator, result, 1), false, triggerList, combatChanged, sa);
            triggerList.triggerChangesZoneAll(game, sa);
            game.fireEvent(new GameEventTokenCreated());
            if (combatChanged.isTrue()) {
                game.updateCombatForView();
                game.fireEvent(new GameEventCombatChanged());
            }
        }
        if ((tgtCards = CardLists.getType(activator.getCardsIn(ZoneType.Battlefield), "Army")).isEmpty()) {
            return;
        }
        HashMap<String, Object> params = Maps.newHashMap();
        params.put("CounterType", CounterType.get(CounterEnumType.P1P1));
        params.put("Amount", 1);
        Card tgt = activator.getController().chooseSingleEntityForEffect(tgtCards, sa, Localizer.getInstance().getMessage("lblChooseAnArmy", new Object[0]), false, params);
        if (sa.hasParam("RememberAmass")) {
            source.addRemembered(tgt);
        }
        GameEntityCounterTable table = new GameEntityCounterTable();
        tgt.addCounter(CounterEnumType.P1P1, amount, activator, table);
        table.replaceCounterEffect(game, sa, true);
        tgt.addChangedCardTypes(CardType.parse(type, true), (CardType)null, false, (Set<RemoveType>)EnumSet.noneOf(RemoveType.class), game.getNextTimestamp(), 0L, true, false);
    }
}

