/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import forge.game.GameLogEntryType;
import forge.game.GameType;
import forge.game.ability.AbilityKey;
import forge.game.ability.SpellAbilityEffect;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.game.trigger.TriggerType;
import forge.util.Lang;
import forge.util.TextUtil;
import java.util.Map;

public class AlterAttributeEffect
extends SpellAbilityEffect {
    @Override
    public void resolve(SpellAbility sa) {
        boolean activate = Boolean.parseBoolean(sa.getParamOrDefault("Activate", "true"));
        String[] attributes = sa.getParam("Attributes").split(",");
        CardCollection defined = AlterAttributeEffect.getDefinedCardsOrTargeted(sa);
        if (sa.hasParam("Optional")) {
            String message;
            String targets = Lang.joinHomogenous(defined);
            String string = message = sa.hasParam("OptionQuestion") ? TextUtil.fastReplace(sa.getParam("OptionQuestion"), "TARGETS", targets) : this.getStackDescription(sa);
            if (!sa.getActivatingPlayer().getController().confirmAction(sa, null, message, null)) {
                return;
            }
        }
        for (Card c : defined) {
            for (String attr : attributes) {
                boolean altered = false;
                switch (attr.trim()) {
                    case "Plotted": {
                        altered = c.setPlotted(activate);
                        break;
                    }
                    case "Solve": 
                    case "Solved": {
                        altered = c.setSolved(activate);
                        if (!altered) break;
                        Map<AbilityKey, Object> runParams = AbilityKey.mapFromCard(c);
                        runParams.put(AbilityKey.Player, sa.getActivatingPlayer());
                        c.getGame().getTriggerHandler().runTrigger(TriggerType.CaseSolved, runParams, false);
                        break;
                    }
                    case "Suspect": 
                    case "Suspected": {
                        altered = c.setSuspected(activate);
                        break;
                    }
                    case "Saddle": 
                    case "Saddled": {
                        altered = c.setSaddled(activate);
                        if (!altered) break;
                        CardCollection saddlers = sa.getPaidList("TappedCards", true);
                        c.addSaddledByThisTurn(saddlers);
                        Map<AbilityKey, Object> runParams = AbilityKey.mapFromCard(c);
                        runParams.put(AbilityKey.Crew, saddlers);
                        c.getGame().getTriggerHandler().runTrigger(TriggerType.BecomesSaddled, runParams, false);
                        break;
                    }
                    case "Commander": {
                        Player p = c.getOwner();
                        if (c.isCommander() == activate || p.getCommanders().contains(c) == activate) break;
                        if (activate) {
                            if (!c.getGame().getRules().hasCommander()) {
                                System.out.println("Commander status applied in non-commander format. Applying Commander variant.");
                                c.getGame().getRules().addAppliedVariant(GameType.Commander);
                            }
                            p.addCommander(c);
                            c.getGame().getGameLog().add(GameLogEntryType.STACK_RESOLVE, String.format("%s is now %s's commander.", c.getPaperCard().getName(), p));
                        } else {
                            p.removeCommander(c);
                            c.getGame().getGameLog().add(GameLogEntryType.STACK_RESOLVE, String.format("%s is no longer %s's commander.", c.getPaperCard().getName(), p));
                        }
                        altered = true;
                        break;
                    }
                }
                if (!altered || !sa.hasParam("RememberAltered")) continue;
                sa.getHostCard().addRemembered(c);
            }
            c.updateAbilityTextForView();
        }
    }
}

