/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import forge.game.ability.SpellAbilityEffect;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardLists;
import forge.game.player.Player;
import forge.game.player.PlayerCollection;
import forge.game.spellability.SpellAbility;
import forge.game.zone.ZoneType;
import forge.util.Lang;
import forge.util.Localizer;
import forge.util.collect.FCollection;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;

public class ActivateAbilityEffect
extends SpellAbilityEffect {
    @Override
    protected String getStackDescription(SpellAbility sa) {
        StringBuilder sb = new StringBuilder();
        PlayerCollection tgtPlayers = ActivateAbilityEffect.getTargetPlayers(sa);
        sb.append(StringUtils.join(tgtPlayers, ", "));
        sb.append(" activates ");
        sb.append(Lang.nounWithAmount(1, sa.hasParam("ManaAbility") ? "mana ability" : "ability"));
        sb.append(" of each ").append(sa.getParamOrDefault("Type", "Card"));
        sb.append(" they control.");
        return sb.toString();
    }

    @Override
    public void resolve(SpellAbility sa) {
        boolean isManaAb = sa.hasParam("ManaAbility");
        for (Player p : ActivateAbilityEffect.getTargetPlayers(sa)) {
            if (!p.isInGame()) continue;
            CardCollection list = CardLists.getType(p.getCardsIn(ZoneType.Battlefield), sa.getParamOrDefault("Type", "Card"));
            for (Card c : list) {
                ArrayList<SpellAbility> possibleAb = Lists.newArrayList(c.getAllPossibleAbilities(p, true));
                if (isManaAb) {
                    possibleAb.retainAll((FCollection)c.getManaAbilities());
                }
                if (possibleAb.isEmpty()) continue;
                SpellAbility manaAb = p.getController().chooseSingleSpellForEffect(possibleAb, sa, Localizer.getInstance().getMessage("lblChooseManaAbility", new Object[0]), ImmutableMap.of());
                p.getController().playChosenSpellAbility(manaAb);
            }
        }
    }
}

