/*
 * Decompiled with CFR 0.152.
 */
package forge.game;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import forge.game.IEntityMap;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardCollectionView;
import forge.game.player.Player;
import forge.game.staticability.StaticAbility;
import java.util.List;
import java.util.Map;

public class StaticEffect {
    private final Card source;
    private StaticAbility ability;
    private CardCollectionView affectedCards = new CardCollection();
    private List<Player> affectedPlayers = Lists.newArrayList();
    private long timestamp = -1L;
    private Map<String, String> mapParams = Maps.newTreeMap();

    StaticEffect(Card source) {
        this.source = source;
    }

    StaticEffect(StaticAbility ability) {
        this(ability.getHostCard());
        this.ability = ability;
    }

    private StaticEffect makeMappedCopy(IEntityMap map) {
        StaticEffect copy = new StaticEffect(map.map(this.source));
        copy.ability = this.ability;
        copy.affectedCards = map.mapCollection(this.affectedCards);
        copy.affectedPlayers = map.mapList(this.affectedPlayers);
        copy.timestamp = this.timestamp;
        copy.mapParams = this.mapParams;
        return copy;
    }

    public final void setTimestamp(long t2) {
        this.timestamp = t2;
    }

    public final long getTimestamp() {
        return this.timestamp;
    }

    public final Card getSource() {
        return this.source;
    }

    public final CardCollectionView getAffectedCards() {
        return this.affectedCards;
    }

    public final void setAffectedCards(CardCollectionView list) {
        this.affectedCards = list;
    }

    public final List<Player> getAffectedPlayers() {
        return this.affectedPlayers;
    }

    public final void setAffectedPlayers(List<Player> list) {
        this.affectedPlayers = list;
    }

    public final void setParams(Map<String, String> params) {
        this.mapParams = params;
    }

    public final Map<String, String> getParams() {
        return this.mapParams;
    }

    public boolean hasParam(String key) {
        return this.mapParams.containsKey(key);
    }

    public String getParam(String key) {
        return this.mapParams.get(key);
    }

    final CardCollectionView remove() {
        CardCollectionView affectedCards = this.getAffectedCards();
        List<Player> affectedPlayers = this.getAffectedPlayers();
        boolean removeMayPlay = false;
        if (this.hasParam("MayPlay")) {
            removeMayPlay = true;
        }
        if (this.hasParam("IgnoreEffectCost")) {
            this.getSource().removeChangedCardTraits(this.getTimestamp(), this.ability.getId());
        }
        for (Player p : affectedPlayers) {
            p.setUnlimitedHandSize(false);
            p.setMaxHandSize(p.getStartingHandSize());
            p.removeChangedKeywords(this.getTimestamp(), this.ability.getId());
            p.removeMaxLandPlays(this.getTimestamp());
            p.removeMaxLandPlaysInfinite(this.getTimestamp());
            p.removeControlledWhileSearching(this.getTimestamp());
            p.removeControlVote(this.getTimestamp());
            p.removeAdditionalVote(this.getTimestamp());
            p.removeAdditionalOptionalVote(this.getTimestamp());
            p.removeAdditionalVillainousChoices(this.getTimestamp());
            p.removeDeclaresAttackers(this.getTimestamp());
            p.removeDeclaresBlockers(this.getTimestamp());
        }
        for (Card affectedCard : affectedCards) {
            if (this.hasParam("GainControl")) {
                affectedCard.removeTempController(this.getTimestamp());
            }
            affectedCard.removeChangedTextColorWord(this.getTimestamp(), this.ability.getId());
            if (this.hasParam("SetPower") || this.hasParam("SetToughness")) {
                affectedCard.removeNewPT(this.getTimestamp(), this.ability.getId());
            }
            affectedCard.removePTBoost(this.getTimestamp(), this.ability.getId());
            if (this.hasParam("AddKeyword") || this.hasParam("RemoveKeyword") || this.hasParam("RemoveLandTypes") || this.hasParam("ShareRememberedKeywords") || this.hasParam("RemoveAllAbilities")) {
                affectedCard.removeChangedCardKeywords(this.getTimestamp(), this.ability.getId(), false);
            }
            if (this.hasParam("CantHaveKeyword")) {
                affectedCard.removeCantHaveKeyword(this.getTimestamp());
            }
            if (this.hasParam("AddHiddenKeyword")) {
                affectedCard.removeHiddenExtrinsicKeywords(this.timestamp, this.ability.getId());
            }
            if (this.hasParam("AddAbility") || this.hasParam("GainsAbilitiesOf") || this.hasParam("GainsAbilitiesOfDefined") || this.hasParam("GainsTriggerAbsOf") || this.hasParam("AddTrigger") || this.hasParam("AddStaticAbility") || this.hasParam("AddReplacementEffects") || this.hasParam("RemoveAllAbilities") || this.hasParam("RemoveLandTypes")) {
                affectedCard.removeChangedCardTraits(this.getTimestamp(), this.ability.getId());
            }
            if (this.hasParam("AddType") || this.hasParam("AddAllCreatureTypes") || this.hasParam("RemoveType") || this.hasParam("RemoveLandTypes")) {
                affectedCard.removeChangedCardTypes(this.getTimestamp(), this.ability.getId(), false);
            }
            if (this.hasParam("AddColor") || this.hasParam("SetColor")) {
                affectedCard.removeColor(this.getTimestamp(), this.ability.getId());
            }
            if (this.hasParam("SetName") || this.hasParam("AddNames")) {
                affectedCard.removeChangedName(this.timestamp, this.ability.getId());
            }
            if (this.hasParam("MayLookAt")) {
                affectedCard.removeMayLookAt(this.getTimestamp());
            }
            if (removeMayPlay) {
                affectedCard.removeMayPlay(this.ability);
            }
            if (this.hasParam("GainTextOf")) {
                affectedCard.removeChangedName(this.getTimestamp(), this.ability.getId());
                affectedCard.removeChangedManaCost(this.getTimestamp(), this.ability.getId());
                affectedCard.removeColor(this.getTimestamp(), this.ability.getId());
                affectedCard.removeChangedCardTypes(this.getTimestamp(), this.ability.getId());
                affectedCard.removeChangedCardTraits(this.getTimestamp(), this.ability.getId());
                affectedCard.removeChangedCardKeywords(this.getTimestamp(), this.ability.getId());
                affectedCard.removeNewPT(this.getTimestamp(), this.ability.getId());
                affectedCard.updateChangedText();
            }
            if (this.hasParam("Goad")) {
                affectedCard.removeGoad(this.getTimestamp());
            }
            if (this.hasParam("CanBlockAny")) {
                affectedCard.removeCanBlockAny(this.getTimestamp());
            }
            if (this.hasParam("CanBlockAmount")) {
                affectedCard.removeCanBlockAdditional(this.getTimestamp());
            }
            affectedCard.removeChangedSVars(this.getTimestamp(), this.ability.getId());
            affectedCard.updateAbilityTextForView();
        }
        return affectedCards;
    }

    public void removeMapped(IEntityMap map) {
        this.makeMappedCopy(map).remove();
    }
}

