/*
 * Decompiled with CFR 0.152.
 */
package forge.game;

import com.google.common.collect.Iterables;
import forge.LobbyPlayer;
import forge.deck.Deck;
import forge.game.Game;
import forge.game.GameEntity;
import forge.game.GameEntityView;
import forge.game.GameLog;
import forge.game.GameOutcome;
import forge.game.GameRules;
import forge.game.GameType;
import forge.game.Match;
import forge.game.card.CardCollection;
import forge.game.card.CardView;
import forge.game.combat.AttackingBand;
import forge.game.combat.Combat;
import forge.game.combat.CombatView;
import forge.game.phase.PhaseHandler;
import forge.game.phase.PhaseType;
import forge.game.player.PlayerView;
import forge.game.player.RegisteredPlayer;
import forge.game.spellability.StackItemView;
import forge.game.zone.MagicStack;
import forge.trackable.TrackableCollection;
import forge.trackable.TrackableObject;
import forge.trackable.TrackableProperty;
import forge.util.collect.FCollectionView;

public class GameView
extends TrackableObject {
    private static final long serialVersionUID = 8522884512960961528L;
    private final transient Game game;
    private final transient Match match;

    public GameView(Game game) {
        super(game.getId(), game.getTracker());
        this.match = game.getMatch();
        this.game = game;
        this.set(TrackableProperty.Title, game.getMatch().getTitle());
        this.set(TrackableProperty.WinningTeam, -1);
        GameRules rules = game.getRules();
        this.set(TrackableProperty.IsCommander, rules.hasCommander());
        this.set(TrackableProperty.GameType, rules.getGameType());
        this.set(TrackableProperty.PoisonCountersToLose, rules.getPoisonCountersToLose());
        this.set(TrackableProperty.NumGamesInMatch, rules.getGamesPerMatch());
        this.set(TrackableProperty.GameLog, game.getGameLog());
        this.set(TrackableProperty.NumPlayedGamesInMatch, game.getMatch().getOutcomes().size());
    }

    public Match getMatch() {
        return this.match;
    }

    public Game getGame() {
        return this.game;
    }

    public FCollectionView<PlayerView> getPlayers() {
        return (FCollectionView)this.get(TrackableProperty.Players);
    }

    public void updatePlayers(Game game) {
        this.set(TrackableProperty.Players, PlayerView.getCollection(game.getPlayers()));
    }

    public String getTitle() {
        return (String)this.get(TrackableProperty.Title);
    }

    public boolean isCommander() {
        return (Boolean)this.get(TrackableProperty.IsCommander);
    }

    public GameType getGameType() {
        return (GameType)((Object)this.get(TrackableProperty.GameType));
    }

    public int getPoisonCountersToLose() {
        return (Integer)this.get(TrackableProperty.PoisonCountersToLose);
    }

    public int getNumGamesInMatch() {
        return (Integer)this.get(TrackableProperty.NumGamesInMatch);
    }

    public int getTurn() {
        return (Integer)this.get(TrackableProperty.Turn);
    }

    void updateTurn(PhaseHandler phaseHandler) {
        this.set(TrackableProperty.Turn, phaseHandler.getTurn());
    }

    public PhaseType getPhase() {
        return (PhaseType)((Object)this.get(TrackableProperty.Phase));
    }

    void updatePhase(PhaseHandler phaseHandler) {
        this.set(TrackableProperty.Phase, phaseHandler.getPhase());
    }

    public PlayerView getPlayerTurn() {
        return (PlayerView)this.get(TrackableProperty.PlayerTurn);
    }

    void updatePlayerTurn(PhaseHandler phaseHandler) {
        this.set(TrackableProperty.PlayerTurn, PlayerView.get(phaseHandler.getPlayerTurn()));
    }

    public void updateNeedsPhaseRedrawn(PlayerView p, PhaseType ph) {
        this.set(TrackableProperty.PlayerTurn, p);
        this.set(TrackableProperty.Phase, ph);
        this.set(TrackableProperty.NeedsPhaseRedrawn, true);
    }

    public boolean getNeedsPhaseRedrawn() {
        if (this.get(TrackableProperty.NeedsPhaseRedrawn) == null) {
            return false;
        }
        return (Boolean)this.get(TrackableProperty.NeedsPhaseRedrawn);
    }

    public void clearNeedsPhaseRedrawn() {
        this.set(TrackableProperty.NeedsPhaseRedrawn, false);
    }

    public void updatePlanarPlayer(PlayerView p) {
        this.set(TrackableProperty.PlanarPlayer, p);
    }

    public PlayerView getPlanarPlayer() {
        return (PlayerView)this.get(TrackableProperty.PlanarPlayer);
    }

    public FCollectionView<StackItemView> getStack() {
        return (FCollectionView)this.get(TrackableProperty.Stack);
    }

    public StackItemView peekStack() {
        return Iterables.getFirst(this.getStack(), null);
    }

    public int getStormCount() {
        return (Integer)this.get(TrackableProperty.StormCount);
    }

    void updateStack(MagicStack stack) {
        this.set(TrackableProperty.Stack, StackItemView.getCollection(stack));
        this.set(TrackableProperty.StormCount, stack.getSpellsCastThisTurn().size());
    }

    public boolean isFirstGameInMatch() {
        return this.getNumPlayedGamesInMatch() == 0;
    }

    public int getNumPlayedGamesInMatch() {
        return (Integer)this.get(TrackableProperty.NumPlayedGamesInMatch);
    }

    public boolean isGameOver() {
        return (Boolean)this.get(TrackableProperty.GameOver);
    }

    public boolean isMatchOver() {
        return (Boolean)this.get(TrackableProperty.MatchOver);
    }

    public boolean isMulligan() {
        if (this.get(TrackableProperty.Mulligan) == null) {
            return false;
        }
        return (Boolean)this.get(TrackableProperty.Mulligan);
    }

    public void updateIsMulligan(boolean value) {
        this.set(TrackableProperty.Mulligan, value);
    }

    public String getWinningPlayerName() {
        return (String)this.get(TrackableProperty.WinningPlayerName);
    }

    public int getWinningTeam() {
        return (Integer)this.get(TrackableProperty.WinningTeam);
    }

    void updateGameOver(Game game) {
        this.set(TrackableProperty.GameOver, game.isGameOver());
        this.set(TrackableProperty.MatchOver, game.getMatch().isMatchOver());
        if (game.getOutcome() != null && game.getOutcome().getWinningLobbyPlayer() != null) {
            this.set(TrackableProperty.WinningPlayerName, game.getOutcome().getWinningLobbyPlayer().getName());
        }
        this.set(TrackableProperty.WinningTeam, game.getOutcome() == null ? -1 : game.getOutcome().getWinningTeam());
    }

    public GameLog getGameLog() {
        return (GameLog)this.get(TrackableProperty.GameLog);
    }

    void updateGameLog(GameLog gameLog) {
        this.flagAsChanged(TrackableProperty.GameLog);
    }

    public TrackableCollection<CardView> getRevealedCollection() {
        return (TrackableCollection)this.get(TrackableProperty.RevealedCardsCollection);
    }

    public void updateRevealedCards(TrackableCollection<CardView> collection) {
        this.set(TrackableProperty.RevealedCardsCollection, collection);
    }

    public CombatView getCombat() {
        return (CombatView)this.get(TrackableProperty.CombatView);
    }

    public void updateCombatView(CombatView combatView) {
        this.set(TrackableProperty.CombatView, combatView);
    }

    void updateCombat(Combat combat) {
        if (combat == null) {
            this.set(TrackableProperty.CombatView, null);
            return;
        }
        CombatView combatView = new CombatView(combat.getAttackingPlayer().getGame().getTracker());
        for (AttackingBand b : combat.getAttackingBands()) {
            if (b == null) continue;
            GameEntity defender = combat.getDefenderByAttacker(b);
            CardCollection blockers = combat.getBlockers(b);
            boolean isBlocked = b.isBlocked() == Boolean.TRUE;
            combatView.addAttackingBand(CardView.getCollection(b.getAttackers()), GameEntityView.get(defender), isBlocked ? CardView.getCollection(blockers) : null, CardView.getCollection(blockers));
        }
        this.updateCombatView(combatView);
    }

    public void serialize() {
    }

    public void deserialize() {
    }

    public boolean isMatchWonBy(LobbyPlayer questPlayer) {
        return this.getMatch().isWonBy(questPlayer);
    }

    public Iterable<GameOutcome> getOutcomesOfMatch() {
        return this.getMatch().getOutcomes();
    }

    public boolean isWinner(LobbyPlayer guiPlayer) {
        return this.getOutcome().isWinner(guiPlayer);
    }

    public int getGamesWonBy(LobbyPlayer questPlayer) {
        return this.getMatch().getGamesWonBy(questPlayer);
    }

    public Deck getDeck(PlayerView pv) {
        for (RegisteredPlayer rp : this.getMatch().getPlayers()) {
            if (!pv.isLobbyPlayer(rp.getPlayer())) continue;
            return rp.getDeck();
        }
        return null;
    }

    public GameOutcome getOutcome() {
        return this.getMatch().getOutcomeById(this.getId());
    }

    public GameOutcome.AnteResult getAnteResult(PlayerView player) {
        return this.getOutcome().getAnteResult(player);
    }
}

