/*
 * Decompiled with CFR 0.152.
 */
package forge.game;

import forge.game.GameType;
import java.util.EnumSet;
import java.util.Set;

public class GameRules {
    private final GameType gameType;
    private boolean manaBurn;
    private int poisonCountersToLose = 10;
    private int gamesPerMatch = 3;
    private int gamesToWinMatch = 2;
    private boolean playForAnte = false;
    private boolean matchAnteRarity = false;
    private boolean AISideboardingEnabled = false;
    private boolean sideboardForAI = false;
    private final Set<GameType> appliedVariants = EnumSet.noneOf(GameType.class);
    private boolean useGrayText;
    private boolean warnAboutAICards = true;

    public GameRules(GameType type) {
        this.gameType = type;
    }

    public GameType getGameType() {
        return this.gameType;
    }

    public boolean hasManaBurn() {
        return this.manaBurn;
    }

    public void setManaBurn(boolean manaBurn) {
        this.manaBurn = manaBurn;
    }

    public int getPoisonCountersToLose() {
        return this.poisonCountersToLose;
    }

    public void setPoisonCountersToLose(int amount) {
        this.poisonCountersToLose = amount;
    }

    public int getGamesPerMatch() {
        return this.gamesPerMatch;
    }

    public void setGamesPerMatch(int gamesPerMatch) {
        this.gamesPerMatch = gamesPerMatch;
        this.gamesToWinMatch = gamesPerMatch / 2 + 1;
    }

    public boolean useAnte() {
        return this.playForAnte;
    }

    public void setPlayForAnte(boolean useAnte) {
        this.playForAnte = useAnte;
    }

    public boolean getMatchAnteRarity() {
        return this.matchAnteRarity;
    }

    public void setMatchAnteRarity(boolean matchRarity) {
        this.matchAnteRarity = matchRarity;
    }

    public boolean getSideboardForAI() {
        return this.sideboardForAI;
    }

    public void setSideboardForAI(boolean sideboard) {
        this.sideboardForAI = sideboard;
    }

    public boolean getAISideboardingEnabled() {
        return this.AISideboardingEnabled;
    }

    public void setAISideboardingEnabled(boolean aiSideboarding) {
        this.AISideboardingEnabled = aiSideboarding;
    }

    public int getGamesToWinMatch() {
        return this.gamesToWinMatch;
    }

    public void setAppliedVariants(Set<GameType> appliedVariants) {
        if (appliedVariants != null && !appliedVariants.isEmpty()) {
            this.appliedVariants.addAll(appliedVariants);
        }
    }

    public void addAppliedVariant(GameType variant) {
        this.appliedVariants.add(variant);
    }

    public boolean hasAppliedVariant(GameType variant) {
        return this.appliedVariants.contains((Object)variant);
    }

    public boolean hasCommander() {
        return this.appliedVariants.contains((Object)GameType.Commander) || this.appliedVariants.contains((Object)GameType.Oathbreaker) || this.appliedVariants.contains((Object)GameType.TinyLeaders) || this.appliedVariants.contains((Object)GameType.Brawl);
    }

    public boolean useGrayText() {
        return this.useGrayText;
    }

    public void setUseGrayText(boolean useGrayText) {
        this.useGrayText = useGrayText;
    }

    public boolean warnAboutAICards() {
        return this.warnAboutAICards;
    }

    public void setWarnAboutAICards(boolean warnAboutAICards) {
        this.warnAboutAICards = warnAboutAICards;
    }
}

