/*
 * Decompiled with CFR 0.152.
 */
package forge.game;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import forge.StaticData;
import forge.card.CardDb;
import forge.card.CardEdition;
import forge.card.CardRarity;
import forge.deck.CardPool;
import forge.deck.Deck;
import forge.item.IPaperCard;
import forge.item.PaperCard;
import forge.util.FileSection;
import forge.util.FileUtil;
import forge.util.storage.StorageBase;
import forge.util.storage.StorageReaderRecursiveFolderWithUserFolder;
import java.io.File;
import java.io.FilenameFilter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class GameFormat
implements Comparable<GameFormat> {
    private final String name;
    private FormatType formatType;
    private FormatSubType formatSubType;
    protected final List<String> allowedSetCodes;
    protected final List<CardRarity> allowedRarities;
    protected final List<String> bannedCardNames;
    protected final List<String> restrictedCardNames;
    protected final List<String> additionalCardNames;
    protected boolean restrictedLegendary = false;
    private Date effectiveDate;
    private static final SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
    private static final String DEFAULTDATE = "1990-01-01";
    protected final transient List<String> allowedSetCodes_ro;
    protected final transient List<String> bannedCardNames_ro;
    protected final transient List<String> restrictedCardNames_ro;
    protected final transient List<String> additionalCardNames_ro;
    protected final transient Predicate<PaperCard> filterRules;
    protected final transient Predicate<PaperCard> filterPrinted;
    private final int index;
    public static final GameFormat NoFormat = new GameFormat("(none)", GameFormat.parseDate("1990-01-01"), null, null, null, false, null, null, Integer.MAX_VALUE, FormatType.CUSTOM, FormatSubType.CUSTOM);
    public final Predicate<CardEdition> editionLegalPredicate = subject -> this.isSetLegal(subject.getCode());

    public GameFormat(String fName, Iterable<String> sets, List<String> bannedCards) {
        this(fName, GameFormat.parseDate(DEFAULTDATE), sets, bannedCards, null, false, null, null, 0, FormatType.CUSTOM, FormatSubType.CUSTOM);
    }

    public GameFormat(String fName, Date effectiveDate, Iterable<String> sets, List<String> bannedCards, List<String> restrictedCards, Boolean restrictedLegendary, List<String> additionalCards, List<CardRarity> rarities, int compareIdx, FormatType formatType, FormatSubType formatSubType) {
        ArrayList<String> arrayList;
        ArrayList<String> arrayList2;
        List<String> list;
        this.index = compareIdx;
        this.formatType = formatType;
        this.formatSubType = formatSubType;
        this.name = fName;
        this.effectiveDate = effectiveDate;
        if (sets != null) {
            StaticData data = StaticData.instance();
            HashSet<String> parsedSets = new HashSet<String>();
            for (String set : sets) {
                if (data.getCardEdition(set) == null) {
                    System.out.println("Set " + set + " in format " + fName + " does not match any valid editions!");
                    continue;
                }
                parsedSets.add(set);
            }
            this.allowedSetCodes = Lists.newArrayList(parsedSets);
        } else {
            this.allowedSetCodes = new ArrayList<String>();
        }
        if (bannedCards == null) {
            ArrayList<String> arrayList3;
            list = arrayList3;
        } else {
            list = this.bannedCardNames = Lists.newArrayList(bannedCards);
        }
        if (restrictedCards == null) {
            ArrayList<String> arrayList4;
            arrayList2 = arrayList4;
            super();
        } else {
            arrayList2 = Lists.newArrayList(restrictedCards);
        }
        this.restrictedCardNames = arrayList2;
        this.allowedRarities = rarities == null ? new ArrayList() : rarities;
        this.restrictedLegendary = restrictedLegendary;
        if (additionalCards == null) {
            ArrayList<String> arrayList5;
            arrayList = arrayList5;
            super();
        } else {
            arrayList = Lists.newArrayList(additionalCards);
        }
        this.additionalCardNames = arrayList;
        this.allowedSetCodes_ro = Collections.unmodifiableList(this.allowedSetCodes);
        this.bannedCardNames_ro = Collections.unmodifiableList(this.bannedCardNames);
        this.restrictedCardNames_ro = Collections.unmodifiableList(this.restrictedCardNames);
        this.additionalCardNames_ro = Collections.unmodifiableList(this.additionalCardNames);
        this.filterRules = this.buildFilterRules();
        this.filterPrinted = this.buildFilterPrinted();
    }

    protected Predicate<PaperCard> buildFilter(boolean printed) {
        Predicate<PaperCard> p = Predicates.not(IPaperCard.Predicates.names(this.getBannedCardNames()));
        p = FormatSubType.ARENA.equals((Object)this.getFormatSubType()) ? Predicates.and(p, Predicates.not(IPaperCard.Predicates.Presets.IS_UNREBALANCED)) : Predicates.and(p, Predicates.not(IPaperCard.Predicates.Presets.IS_REBALANCED));
        if (!this.getAllowedSetCodes().isEmpty()) {
            p = Predicates.and(p, printed ? IPaperCard.Predicates.printedInSets(this.getAllowedSetCodes(), printed) : StaticData.instance().getCommonCards().wasPrintedInSets(this.getAllowedSetCodes()));
        }
        if (!this.getAllowedRarities().isEmpty()) {
            ArrayList<Predicate<? super PaperCard>> crp = Lists.newArrayList();
            for (CardRarity cr : this.getAllowedRarities()) {
                crp.add(StaticData.instance().getCommonCards().wasPrintedAtRarity(cr));
            }
            p = Predicates.and(p, Predicates.or(crp));
        }
        if (!this.getAdditionalCards().isEmpty()) {
            p = Predicates.or(p, IPaperCard.Predicates.names(this.getAdditionalCards()));
        }
        return p;
    }

    private Predicate<PaperCard> buildFilterPrinted() {
        return this.buildFilter(true);
    }

    private Predicate<PaperCard> buildFilterRules() {
        return this.buildFilter(false);
    }

    public String getName() {
        return this.name;
    }

    private static Date parseDate(String date) {
        if (date.length() <= 7) {
            date = date + "-01";
        }
        try {
            return formatter.parse(date);
        }
        catch (ParseException e) {
            return new Date();
        }
    }

    public Date getEffectiveDate() {
        return this.effectiveDate;
    }

    public FormatType getFormatType() {
        return this.formatType;
    }

    public FormatSubType getFormatSubType() {
        return this.formatSubType;
    }

    public List<String> getAllowedSetCodes() {
        return this.allowedSetCodes_ro;
    }

    public List<String> getBannedCardNames() {
        return this.bannedCardNames_ro;
    }

    public List<String> getRestrictedCards() {
        return this.restrictedCardNames_ro;
    }

    public Boolean isRestrictedLegendary() {
        return this.restrictedLegendary;
    }

    public List<String> getAdditionalCards() {
        return this.additionalCardNames_ro;
    }

    public List<CardRarity> getAllowedRarities() {
        return this.allowedRarities;
    }

    public List<PaperCard> getAllCards() {
        ArrayList<PaperCard> cards = new ArrayList<PaperCard>();
        CardDb commonCards = StaticData.instance().getCommonCards();
        for (String setCode : this.allowedSetCodes_ro) {
            CardEdition edition = StaticData.instance().getEditions().get(setCode);
            if (edition == null) continue;
            for (CardEdition.CardInSet card : edition.getAllCardsInSet()) {
                PaperCard pc;
                if (this.bannedCardNames_ro.contains(card.name) || (pc = commonCards.getCard(card.name, setCode, card.collectorNumber)) == null) continue;
                cards.add(pc);
            }
        }
        return cards;
    }

    public Predicate<PaperCard> getFilterRules() {
        return this.filterRules;
    }

    public Predicate<PaperCard> getFilterPrinted() {
        return this.filterPrinted;
    }

    public boolean isSetLegal(String setCode) {
        return this.getAllowedSetCodes().isEmpty() || this.getAllowedSetCodes().contains(setCode);
    }

    private boolean isPoolLegal(CardPool allCards) {
        return this.getPoolLegalityProblem(allCards) == null;
    }

    public boolean isDeckLegal(Deck deck) {
        return this.isPoolLegal(deck.getAllCardsInASinglePool());
    }

    private String getPoolLegalityProblem(CardPool allCards) {
        Object sb;
        ArrayList<PaperCard> erroneousCI = new ArrayList<PaperCard>();
        for (Object poolEntry : allCards) {
            if (this.getFilterRules().apply((PaperCard)poolEntry.getKey())) continue;
            erroneousCI.add((PaperCard)poolEntry.getKey());
        }
        if (erroneousCI.size() > 0) {
            sb = new StringBuilder("contains the following illegal cards:\n");
            for (PaperCard cp : erroneousCI) {
                ((StringBuilder)sb).append("\n").append(cp.getName());
            }
            return ((StringBuilder)sb).toString();
        }
        if (!this.getRestrictedCards().isEmpty() || this.isRestrictedLegendary().booleanValue()) {
            ArrayList<PaperCard> erroneousRestricted = new ArrayList<PaperCard>();
            for (Object poolEntry : allCards) {
                boolean isLegendaryNonPlaneswalker;
                boolean isRestricted = this.getRestrictedCards().contains(((PaperCard)poolEntry.getKey()).getName());
                boolean bl = isLegendaryNonPlaneswalker = ((PaperCard)poolEntry.getKey()).getRules().getType().isLegendary() && !((PaperCard)poolEntry.getKey()).getRules().getType().isPlaneswalker() && this.isRestrictedLegendary() != false;
                if ((Integer)poolEntry.getValue() <= 1 || !isRestricted && !isLegendaryNonPlaneswalker) continue;
                erroneousRestricted.add((PaperCard)poolEntry.getKey());
            }
            if (erroneousRestricted.size() > 0) {
                sb = new StringBuilder("contains more than one copy of the following restricted cards:\n");
                for (PaperCard cp : erroneousRestricted) {
                    ((StringBuilder)sb).append("\n").append(cp.getName());
                }
                return ((StringBuilder)sb).toString();
            }
        }
        return null;
    }

    public String getDeckConformanceProblem(Deck deck) {
        if (deck == null) {
            return "is not selected";
        }
        return this.getPoolLegalityProblem(deck.getAllCardsInASinglePool());
    }

    public String toString() {
        return this.name;
    }

    @Override
    public int compareTo(GameFormat other) {
        if (null == other) {
            return 1;
        }
        if (other.formatType != this.formatType) {
            return this.formatType.compareTo(other.formatType);
        }
        if (other.formatSubType != this.formatSubType) {
            return this.formatSubType.compareTo(other.formatSubType);
        }
        if (this.formatType.equals((Object)FormatType.ARCHIVED)) {
            int compareDates = this.effectiveDate.compareTo(other.effectiveDate);
            if (compareDates != 0) {
                return compareDates;
            }
            return this.index - other.index;
        }
        return this.name.compareTo(other.name);
    }

    public int getIndex() {
        return this.index;
    }

    public static class InverseDateComparator
    implements Comparator<GameFormat> {
        @Override
        public int compare(GameFormat gf1, GameFormat gf2) {
            if (null == gf1 || null == gf2) {
                return 1;
            }
            if (gf2.formatType != gf1.formatType) {
                return gf1.formatType.compareTo(gf2.formatType);
            }
            if (gf2.formatSubType != gf1.formatSubType) {
                return gf1.formatSubType.compareTo(gf2.formatSubType);
            }
            if (gf1.formatType.equals((Object)FormatType.ARCHIVED) && gf1.effectiveDate != gf2.effectiveDate) {
                return gf1.effectiveDate.compareTo(gf2.effectiveDate);
            }
            return gf1.name.compareTo(gf2.name);
        }
    }

    public static class Collection
    extends StorageBase<GameFormat> {
        private List<GameFormat> naturallyOrdered;
        private List<GameFormat> reverseDateOrdered;
        private TreeMap<FormatType, List<GameFormat>> formatsTypeMap;

        public Collection(Reader reader) {
            super("Format collections", reader);
            this.naturallyOrdered = reader.naturallyOrdered;
            this.reverseDateOrdered = new ArrayList<GameFormat>(this.naturallyOrdered);
            this.naturallyOrdered.sort(Comparator.naturalOrder());
            this.reverseDateOrdered.sort(new InverseDateComparator());
        }

        public Iterable<GameFormat> getOrderedList() {
            return this.naturallyOrdered;
        }

        public Iterable<GameFormat> getReverseDateOrderedList() {
            return this.reverseDateOrdered;
        }

        public final Map<FormatType, List<GameFormat>> getFormatTypeMap() {
            if (this.formatsTypeMap == null) {
                this.formatsTypeMap = new TreeMap();
                for (FormatType formatType : FormatType.values()) {
                    this.formatsTypeMap.put(formatType, new ArrayList());
                }
                for (GameFormat format : this.naturallyOrdered) {
                    FormatType key = format.getFormatType();
                    List<GameFormat> formatsOfType = this.formatsTypeMap.get((Object)key);
                    formatsOfType.add(format);
                }
            }
            return this.formatsTypeMap;
        }

        public Iterable<GameFormat> getSanctionedList() {
            ArrayList<GameFormat> coreList = new ArrayList<GameFormat>();
            for (GameFormat format : this.naturallyOrdered) {
                if (!format.getFormatType().equals((Object)FormatType.SANCTIONED)) continue;
                coreList.add(format);
            }
            return coreList;
        }

        public Iterable<GameFormat> getFilterList() {
            ArrayList<GameFormat> coreList = new ArrayList<GameFormat>();
            for (GameFormat format : this.naturallyOrdered) {
                if (format.getFormatType().equals((Object)FormatType.ARCHIVED) || format.getFormatType().equals((Object)FormatType.DIGITAL)) continue;
                coreList.add(format);
            }
            return coreList;
        }

        public Iterable<GameFormat> getArchivedList() {
            ArrayList<GameFormat> coreList = new ArrayList<GameFormat>();
            for (GameFormat format : this.naturallyOrdered) {
                if (!format.getFormatType().equals((Object)FormatType.ARCHIVED)) continue;
                coreList.add(format);
            }
            return coreList;
        }

        public Iterable<GameFormat> getCasualList() {
            ArrayList<GameFormat> casualList = new ArrayList<GameFormat>();
            for (GameFormat format : this.naturallyOrdered) {
                if (!format.getFormatType().equals((Object)FormatType.CASUAL)) continue;
                casualList.add(format);
            }
            return casualList;
        }

        public Iterable<GameFormat> getCoreFormatsWithLimitedSets() {
            ArrayList<GameFormat> formatsWithLimitedSets = new ArrayList<GameFormat>();
            for (GameFormat format : this.naturallyOrdered) {
                if (format.getAllowedSetCodes().size() <= 0) continue;
                formatsWithLimitedSets.add(format);
            }
            return formatsWithLimitedSets;
        }

        public Iterable<GameFormat> getBlockList() {
            ArrayList<GameFormat> blockFormats = new ArrayList<GameFormat>();
            for (GameFormat format : this.getArchivedList()) {
                if (format.getFormatSubType() != FormatSubType.BLOCK || !format.getName().endsWith("Block")) continue;
                blockFormats.add(format);
            }
            Collections.sort(blockFormats);
            return blockFormats;
        }

        public Map<String, List<GameFormat>> getArchivedMap() {
            HashMap<String, List<GameFormat>> coreList = new HashMap<String, List<GameFormat>>();
            for (GameFormat format : this.naturallyOrdered) {
                if (!format.getFormatType().equals((Object)FormatType.ARCHIVED)) continue;
                String alpha = format.getName().substring(0, 1);
                if (!coreList.containsKey(alpha)) {
                    coreList.put(alpha, new ArrayList());
                }
                ((List)coreList.get(alpha)).add(format);
            }
            return coreList;
        }

        public GameFormat getStandard() {
            return (GameFormat)this.map.get("Standard");
        }

        public GameFormat getExtended() {
            return (GameFormat)this.map.get("Extended");
        }

        public GameFormat getPioneer() {
            return (GameFormat)this.map.get("Pioneer");
        }

        public GameFormat getHistoric() {
            return (GameFormat)this.map.get("Historic");
        }

        public GameFormat getModern() {
            return (GameFormat)this.map.get("Modern");
        }

        public GameFormat getLegacy() {
            return (GameFormat)this.map.get("Legacy");
        }

        public GameFormat getVintage() {
            return (GameFormat)this.map.get("Vintage");
        }

        public GameFormat getPremodern() {
            return (GameFormat)this.map.get("Premodern");
        }

        public GameFormat getPauper() {
            return (GameFormat)this.map.get("Pauper");
        }

        public GameFormat getFormat(String format) {
            return (GameFormat)this.map.get(format);
        }

        public GameFormat getFormatOfDeck(Deck deck) {
            for (GameFormat gf : this.reverseDateOrdered) {
                if (!gf.isDeckLegal(deck)) continue;
                return gf;
            }
            return NoFormat;
        }

        public Set<GameFormat> getAllFormatsOfCard(PaperCard card) {
            HashSet<GameFormat> result = new HashSet<GameFormat>();
            for (GameFormat gf : this.naturallyOrdered) {
                if (!gf.getFilterRules().apply(card)) continue;
                result.add(gf);
            }
            if (result.isEmpty()) {
                result.add(NoFormat);
            }
            return result;
        }

        public Set<GameFormat> getAllFormatsOfDeck(Deck deck) {
            return this.getAllFormatsOfDeck(deck, false);
        }

        public Set<GameFormat> getAllFormatsOfDeck(Deck deck, Boolean exhaustive) {
            TreeSet<GameFormat> result = new TreeSet<GameFormat>();
            HashSet<FormatSubType> coveredTypes = new HashSet<FormatSubType>();
            CardPool allCards = deck.getAllCardsInASinglePool();
            for (GameFormat gf : this.reverseDateOrdered) {
                if (gf.getFormatType().equals((Object)FormatType.DIGITAL) && !exhaustive.booleanValue() || gf.getFormatSubType().equals((Object)FormatSubType.COMMANDER) || gf.getFormatType().equals((Object)FormatType.ARCHIVED) && coveredTypes.contains((Object)gf.getFormatSubType()) && !exhaustive.booleanValue() || !gf.isPoolLegal(allCards)) continue;
                result.add(gf);
                coveredTypes.add(gf.getFormatSubType());
            }
            if (result.isEmpty()) {
                result.add(NoFormat);
            }
            return result;
        }

        @Override
        public void add(GameFormat item) {
            this.naturallyOrdered.add(item);
        }
    }

    public static class Reader
    extends StorageReaderRecursiveFolderWithUserFolder<GameFormat> {
        List<GameFormat> naturallyOrdered = new ArrayList<GameFormat>();
        boolean includeArchived;
        private List<String> coreFormats = new ArrayList<String>();
        public static final FilenameFilter TXT_FILE_FILTER = (dir, name) -> name.endsWith(".txt") || dir.isDirectory();

        public Reader(File forgeFormats, File customFormats, boolean includeArchived) {
            super(forgeFormats, customFormats, GameFormat::getName);
            this.coreFormats.add("Standard.txt");
            this.coreFormats.add("Pioneer.txt");
            this.coreFormats.add("Historic.txt");
            this.coreFormats.add("Modern.txt");
            this.coreFormats.add("Legacy.txt");
            this.coreFormats.add("Vintage.txt");
            this.coreFormats.add("Commander.txt");
            this.coreFormats.add("Extended.txt");
            this.coreFormats.add("Brawl.txt");
            this.coreFormats.add("Oathbreaker.txt");
            this.coreFormats.add("Premodern.txt");
            this.coreFormats.add("Pauper.txt");
            this.coreFormats.add("PreDH.txt");
            this.includeArchived = includeArchived;
        }

        @Override
        protected GameFormat read(File file) {
            Boolean strRestrictedLegendary;
            String strCars;
            FormatSubType formatsubType;
            FormatType formatType;
            if (!this.includeArchived && !this.coreFormats.contains(file.getName())) {
                return null;
            }
            Map<String, List<String>> contents = FileSection.parseSections(FileUtil.readFile(file));
            List<String> sets = null;
            List<String> bannedCards = null;
            List<String> restrictedCards = null;
            Boolean restrictedLegendary = false;
            List<String> additionalCards = null;
            ArrayList<CardRarity> rarities = null;
            List<String> formatStrings = contents.get("format");
            if (formatStrings == null) {
                return null;
            }
            FileSection section = FileSection.parse(formatStrings, FileSection.COLON_KV_SEPARATOR);
            String title = section.get("name");
            try {
                formatType = FormatType.valueOf(section.get("type").toUpperCase());
            }
            catch (Exception e) {
                if ("HISTORIC".equals(section.get("type").toUpperCase())) {
                    System.out.println("Historic is no longer used as a format Type. Please update " + file.getAbsolutePath() + " to use 'Archived' instead");
                    formatType = FormatType.ARCHIVED;
                }
                formatType = FormatType.CUSTOM;
            }
            try {
                formatsubType = FormatSubType.valueOf(section.get("subtype").toUpperCase());
            }
            catch (Exception e) {
                formatsubType = FormatSubType.CUSTOM;
            }
            int idx = section.getInt("order");
            String dateStr = section.get("effective");
            if (dateStr == null) {
                dateStr = GameFormat.DEFAULTDATE;
            }
            Date date = GameFormat.parseDate(dateStr);
            String strSets = section.get("sets");
            if (null != strSets) {
                sets = Arrays.asList(strSets.split(", "));
            }
            if ((strCars = section.get("banned")) != null) {
                bannedCards = Arrays.asList(strCars.split("; "));
            }
            if ((strCars = section.get("restricted")) != null) {
                restrictedCards = Arrays.asList(strCars.split("; "));
            }
            if ((strRestrictedLegendary = Boolean.valueOf(section.getBoolean("restrictedlegendary"))) != null) {
                restrictedLegendary = strRestrictedLegendary;
            }
            if ((strCars = section.get("additional")) != null) {
                additionalCards = Arrays.asList(strCars.split("; "));
            }
            if ((strCars = section.get("rarities")) != null) {
                rarities = Lists.newArrayList();
                for (String s2 : strCars.split(", ")) {
                    CardRarity cr = CardRarity.smartValueOf(s2);
                    if (cr.name().equals("Unknown")) continue;
                    rarities.add(cr);
                }
            }
            GameFormat result = new GameFormat(title, date, sets, bannedCards, restrictedCards, restrictedLegendary, additionalCards, rarities, idx, formatType, formatsubType);
            this.naturallyOrdered.add(result);
            return result;
        }

        @Override
        protected FilenameFilter getFileFilter() {
            return TXT_FILE_FILTER;
        }
    }

    public static enum FormatSubType {
        BLOCK,
        STANDARD,
        EXTENDED,
        PAUPER,
        PIONEER,
        MODERN,
        LEGACY,
        VINTAGE,
        COMMANDER,
        PLANECHASE,
        VIDEOGAME,
        MTGO,
        ARENA,
        CUSTOM;

    }

    public static enum FormatType {
        SANCTIONED,
        CASUAL,
        ARCHIVED,
        DIGITAL,
        CUSTOM;

    }
}

