/*
 * Decompiled with CFR 0.152.
 */
package forge.game;

import forge.game.IIdentifiable;
import forge.trackable.TrackableObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

public class GameEntityCache<Entity extends IIdentifiable, View extends TrackableObject> {
    private HashMap<Integer, Entity> entityCache = new HashMap();

    public void put(Integer id, Entity entity) {
        this.entityCache.put(id, entity);
    }

    public void putAll(Iterable<Entity> entities) {
        for (IIdentifiable e : entities) {
            this.put(e.getId(), e);
        }
    }

    public void remove(Integer id) {
        this.entityCache.remove(id);
    }

    public Entity get(View entityView) {
        if (entityView == null) {
            return null;
        }
        return (Entity)((IIdentifiable)this.entityCache.get(((TrackableObject)entityView).getId()));
    }

    public void addToList(Iterable<View> views, List<Entity> list) {
        for (TrackableObject view : views) {
            Entity entity = this.get(view);
            if (entity == null) continue;
            list.add(entity);
        }
    }

    public List<Entity> getList(Iterable<View> views) {
        ArrayList list = new ArrayList();
        this.addToList(views, list);
        return list;
    }

    public void clear() {
        this.entityCache.clear();
    }

    public Collection<Entity> getValues() {
        return this.entityCache.values();
    }
}

