/*
 * Decompiled with CFR 0.152.
 */
package forge.game;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import forge.game.CardTraitBase;
import forge.game.Game;
import forge.game.GameEntityCounterTable;
import forge.game.GameEntityView;
import forge.game.GameObject;
import forge.game.IIdentifiable;
import forge.game.ability.AbilityKey;
import forge.game.ability.AbilityUtils;
import forge.game.ability.ApiType;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardCollectionView;
import forge.game.card.CardLists;
import forge.game.card.CardPredicates;
import forge.game.card.CounterEnumType;
import forge.game.card.CounterType;
import forge.game.event.GameEventCardAttachment;
import forge.game.keyword.Keyword;
import forge.game.player.Player;
import forge.game.replacement.ReplacementEffect;
import forge.game.replacement.ReplacementType;
import forge.game.spellability.SpellAbility;
import forge.game.spellability.TargetRestrictions;
import forge.game.staticability.StaticAbilityCantAttach;
import forge.game.zone.ZoneType;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;

public abstract class GameEntity
extends GameObject
implements IIdentifiable {
    protected int id;
    private String name = "";
    protected CardCollection attachedCards = new CardCollection();
    protected Map<CounterType, Integer> counters = Maps.newHashMap();
    protected List<Pair<Integer, Boolean>> damageReceivedThisTurn = Lists.newArrayList();

    protected GameEntity(int id0) {
        this.id = id0;
    }

    @Override
    public int getId() {
        return this.id;
    }

    public void dangerouslySetId(int i) {
        this.id = i;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String s2) {
        this.name = s2;
        this.getView().updateName(this);
    }

    public abstract int addDamageAfterPrevention(int var1, Card var2, SpellAbility var3, boolean var4, GameEntityCounterTable var5);

    public int staticDamagePrevention(int damage, int possiblePrevention, Card source, boolean isCombat) {
        if (damage <= 0) {
            return 0;
        }
        if (!source.canDamagePrevented(isCombat)) {
            return damage;
        }
        if (isCombat && this.getGame().getReplacementHandler().isPreventCombatDamageThisTurn()) {
            return 0;
        }
        for (Card ca : this.getGame().getCardsIn(ZoneType.STATIC_ABILITIES_SOURCE_ZONES)) {
            for (ReplacementEffect re : ca.getReplacementEffects()) {
                if (!re.getMode().equals((Object)ReplacementType.DamageDone) || !re.hasParam("PreventionEffect") && !re.hasParam("Prevent") || !re.zonesCheck(this.getGame().getZoneOf(ca)) || !re.requirementsCheck(this.getGame()) || "Immortal Coil".equals(ca.getName()) || !re.matchesValidParam("ValidSource", source) || !re.matchesValidParam("ValidTarget", this) || re.hasParam("IsCombat") && re.getParam("IsCombat").equals("True") != isCombat) continue;
                if (re.hasParam("Prevent")) {
                    return 0;
                }
                if (re.getOverridingAbility() != null) {
                    SpellAbility repSA = re.getOverridingAbility();
                    if (repSA.getApi() != ApiType.ReplaceDamage) continue;
                    damage = Math.max(0, damage - AbilityUtils.calculateAmount(ca, repSA.getParam("Amount"), repSA));
                    continue;
                }
                return 0;
            }
        }
        return Math.max(0, damage - possiblePrevention);
    }

    public abstract int staticReplaceDamage(int var1, Card var2, boolean var3);

    public int getPreventNextDamageTotalShields() {
        return this.getGame().getReplacementHandler().getTotalPreventionShieldAmount(this);
    }

    public abstract boolean hasKeyword(String var1);

    public abstract boolean hasKeyword(Keyword var1);

    public final CardCollectionView getEnchantedBy() {
        return CardLists.filter((Iterable<Card>)this.getAttachedCards(), CardPredicates.Presets.AURA);
    }

    public final CardCollectionView getAttachedCards() {
        return CardLists.filter((Iterable<Card>)this.attachedCards, CardPredicates.phasedIn());
    }

    public final CardCollectionView getAllAttachedCards() {
        return this.attachedCards;
    }

    public final void setAttachedCards(Iterable<Card> cards) {
        this.attachedCards = new CardCollection(cards);
        this.updateAttachedCards();
    }

    public final void clearAttachedCards() {
        if (this.attachedCards.isEmpty()) {
            return;
        }
        this.attachedCards.clear();
        this.updateAttachedCards();
    }

    public final boolean hasCardAttachments() {
        return !this.getAttachedCards().isEmpty();
    }

    public final boolean isEnchanted() {
        return Iterables.any(this.getAttachedCards(), CardPredicates.Presets.AURA);
    }

    public final boolean hasCardAttachment(Card c) {
        return this.getAttachedCards().contains(c);
    }

    public final boolean isEnchantedBy(Card c) {
        return this.hasCardAttachment(c);
    }

    public final boolean hasCardAttachment(String cardName) {
        return Iterables.any(this.getAttachedCards(), CardPredicates.nameEquals(cardName));
    }

    public final boolean isEnchantedBy(String cardName) {
        return this.hasCardAttachment(cardName);
    }

    public final void addAttachedCard(Card c) {
        if (this.attachedCards.add(c)) {
            this.updateAttachedCards();
            this.getGame().fireEvent(new GameEventCardAttachment(c, null, this));
        }
    }

    public final void removeAttachedCard(Card c) {
        if (this.attachedCards.remove(c)) {
            this.updateAttachedCards();
            this.getGame().fireEvent(new GameEventCardAttachment(c, this, null));
        }
    }

    public final void updateAttachedCards() {
        this.getView().updateAttachedCards(this);
    }

    public final void unAttachAllCards() {
        for (Card c : this.getAttachedCards()) {
            c.unattachFromEntity(this);
        }
    }

    public boolean canBeAttached(Card attach, SpellAbility sa) {
        return this.canBeAttached(attach, sa, false);
    }

    public boolean canBeAttached(Card attach, SpellAbility sa, boolean checkSBA) {
        if (!attach.isAttachment() || attach.isCreature() && !attach.hasKeyword(Keyword.RECONFIGURE) || this.equals(attach)) {
            return false;
        }
        if (attach.isPhasedOut()) {
            return false;
        }
        if (attach.isAura() && !this.canBeEnchantedBy(attach)) {
            return false;
        }
        if (attach.isEquipment() && !this.canBeEquippedBy(attach, sa)) {
            return false;
        }
        if (attach.isFortification() && !this.canBeFortifiedBy(attach)) {
            return false;
        }
        return !StaticAbilityCantAttach.cantAttach(this, attach, checkSBA);
    }

    protected boolean canBeEquippedBy(Card aura, SpellAbility sa) {
        return false;
    }

    protected boolean canBeFortifiedBy(Card aura) {
        return false;
    }

    protected boolean canBeEnchantedBy(Card aura) {
        SpellAbility sa = aura.getFirstAttachSpell();
        TargetRestrictions tgt = null;
        if (sa != null) {
            tgt = sa.getTargetRestrictions();
        }
        return tgt != null && this.isValid(tgt.getValidTgts(), aura.getController(), aura, (CardTraitBase)sa);
    }

    public boolean hasCounters() {
        return !this.counters.isEmpty();
    }

    public final Map<CounterType, Integer> getCounters() {
        return this.counters;
    }

    public final int getCounters(CounterType counterName) {
        Integer value = this.counters.get(counterName);
        return value == null ? 0 : value;
    }

    public final int getCounters(CounterEnumType counterType) {
        return this.getCounters(CounterType.get(counterType));
    }

    public void setCounters(CounterType counterType, Integer num) {
        if (num <= 0) {
            this.counters.remove(counterType);
        } else {
            this.counters.put(counterType, num);
        }
    }

    public void setCounters(CounterEnumType counterType, Integer num) {
        this.setCounters(CounterType.get(counterType), num);
    }

    public abstract void setCounters(Map<CounterType, Integer> var1);

    public abstract boolean canRemoveCounters(CounterType var1);

    public abstract boolean canReceiveCounters(CounterType var1);

    public abstract int subtractCounter(CounterType var1, int var2, Player var3);

    public abstract void clearCounters();

    public boolean canReceiveCounters(CounterEnumType type) {
        return this.canReceiveCounters(CounterType.get(type));
    }

    public final void addCounter(CounterType counterType, int n, Player source, GameEntityCounterTable table) {
        if (n <= 0 || !this.canReceiveCounters(counterType)) {
            return;
        }
        table.put(source, this, counterType, n);
    }

    public final void addCounter(CounterEnumType counterType, int n, Player source, GameEntityCounterTable table) {
        this.addCounter(CounterType.get(counterType), n, source, table);
    }

    public int subtractCounter(CounterEnumType counterName, int n, Player remover) {
        return this.subtractCounter(CounterType.get(counterName), n, remover);
    }

    public abstract void addCounterInternal(CounterType var1, int var2, Player var3, boolean var4, GameEntityCounterTable var5, Map<AbilityKey, Object> var6);

    public void addCounterInternal(CounterEnumType counterType, int n, Player source, boolean fireEvents, GameEntityCounterTable table, Map<AbilityKey, Object> params) {
        this.addCounterInternal(CounterType.get(counterType), n, source, fireEvents, table, params);
    }

    public List<Pair<Integer, Boolean>> getDamageReceivedThisTurn() {
        return this.damageReceivedThisTurn;
    }

    public void setDamageReceivedThisTurn(List<Pair<Integer, Boolean>> dmg) {
        this.damageReceivedThisTurn.addAll(dmg);
    }

    public void receiveDamage(Pair<Integer, Boolean> dmg) {
        this.damageReceivedThisTurn.add(dmg);
    }

    public final int getAssignedDamage() {
        return this.getAssignedDamage(null, null);
    }

    public final int getAssignedCombatDamage() {
        return this.getAssignedDamage(true, null);
    }

    public final int getAssignedDamage(Boolean isCombat, Card source) {
        int num = 0;
        for (Pair<Integer, Boolean> dmg : this.damageReceivedThisTurn) {
            if (isCombat != null && dmg.getRight() != isCombat || source != null && !this.getGame().getDamageLKI(dmg).getLeft().equalsWithGameTimestamp(source)) continue;
            num += dmg.getLeft().intValue();
        }
        return num;
    }

    public final boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        return o.hashCode() == this.id && o.getClass().equals(this.getClass());
    }

    public final int hashCode() {
        return this.id;
    }

    public String toString() {
        return this.name;
    }

    public abstract Game getGame();

    public abstract GameEntityView getView();
}

