/*
 * Decompiled with CFR 0.152.
 */
package forge.game;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Table;
import com.google.common.eventbus.EventBus;
import forge.GameCommand;
import forge.card.CardRarity;
import forge.card.CardStateName;
import forge.game.CardTraitBase;
import forge.game.Direction;
import forge.game.GameAction;
import forge.game.GameEndReason;
import forge.game.GameEntity;
import forge.game.GameEntityCache;
import forge.game.GameLog;
import forge.game.GameLogEntryType;
import forge.game.GameOutcome;
import forge.game.GameRules;
import forge.game.GameSnapshot;
import forge.game.GameStage;
import forge.game.GameView;
import forge.game.Match;
import forge.game.StaticEffects;
import forge.game.ability.AbilityKey;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardCollectionView;
import forge.game.card.CardCopyService;
import forge.game.card.CardDamageHistory;
import forge.game.card.CardLists;
import forge.game.card.CardPredicates;
import forge.game.card.CardView;
import forge.game.card.CardZoneTable;
import forge.game.card.CounterType;
import forge.game.combat.Combat;
import forge.game.event.Event;
import forge.game.event.GameEventDayTimeChanged;
import forge.game.event.GameEventGameOutcome;
import forge.game.phase.Phase;
import forge.game.phase.PhaseHandler;
import forge.game.phase.PhaseType;
import forge.game.phase.Untap;
import forge.game.player.IGameEntitiesFactory;
import forge.game.player.Player;
import forge.game.player.PlayerCollection;
import forge.game.player.PlayerView;
import forge.game.player.RegisteredPlayer;
import forge.game.replacement.ReplacementHandler;
import forge.game.spellability.SpellAbility;
import forge.game.spellability.SpellAbilityStackInstance;
import forge.game.staticability.StaticAbilityCantChangeDayTime;
import forge.game.trigger.TriggerHandler;
import forge.game.trigger.TriggerType;
import forge.game.zone.CostPaymentStack;
import forge.game.zone.MagicStack;
import forge.game.zone.Zone;
import forge.game.zone.ZoneType;
import forge.trackable.Tracker;
import forge.util.Aggregates;
import forge.util.MyRandom;
import forge.util.Visitor;
import forge.util.collect.FCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.tuple.Pair;

public class Game {
    private static int maxId = 0;
    private int id;
    private final GameRules rules;
    private final PlayerCollection allPlayers = new PlayerCollection();
    private final PlayerCollection ingamePlayers = new PlayerCollection();
    private final PlayerCollection lostPlayers = new PlayerCollection();
    private List<Card> activePlanes = null;
    public final Phase cleanup;
    public final Phase endOfCombat;
    public final Phase endOfTurn;
    public final Untap untap;
    public final Phase upkeep;
    public final List<GameCommand> sbaCheckedCommandList;
    public final MagicStack stack;
    public final CostPaymentStack costPaymentStack = new CostPaymentStack();
    private final PhaseHandler phaseHandler;
    private final StaticEffects staticEffects = new StaticEffects();
    private final TriggerHandler triggerHandler = new TriggerHandler(this);
    private final ReplacementHandler replacementHandler = new ReplacementHandler(this);
    private final EventBus events = new EventBus("game events");
    private final GameLog gameLog = new GameLog();
    private final Zone stackZone = new Zone(ZoneType.Stack, this);
    public boolean EXPERIMENTAL_RESTORE_SNAPSHOT = false;
    private GameSnapshot previousGameState = null;
    private CardCollection lastStateBattlefield = new CardCollection();
    private CardCollection lastStateGraveyard = new CardCollection();
    private CardZoneTable untilHostLeavesPlayTriggerList = new CardZoneTable();
    private Table<CounterType, Player, List<Pair<Card, Integer>>> countersAddedThisTurn = HashBasedTable.create();
    private Multimap<CounterType, Pair<GameEntity, Integer>> countersRemovedThisTurn = ArrayListMultimap.create();
    private List<Card> leftBattlefieldThisTurn = Lists.newArrayList();
    private List<Card> leftGraveyardThisTurn = Lists.newArrayList();
    private FCollection<CardDamageHistory> globalDamageHistory = new FCollection();
    private IdentityHashMap<Pair<Integer, Boolean>, Pair<Card, GameEntity>> damageThisTurnLKI = new IdentityHashMap();
    private Map<Player, Card> topLibsCast = Maps.newHashMap();
    private Map<Card, Integer> facedownWhileCasting = Maps.newHashMap();
    private Player monarch;
    private Player initiative;
    private Player monarchBeginTurn;
    private Player startingPlayer;
    private Direction turnOrder = Direction.getDefaultDirection();
    private Boolean daytime = null;
    private int numPiledGuessedSA;
    private long timestamp = 0L;
    public final GameAction action;
    private final Match match;
    private GameStage age = GameStage.BeforeMulligan;
    private GameOutcome outcome;
    private final Game maingame;
    private final GameView view;
    private final Tracker tracker = new Tracker();
    private final GameEntityCache<Player, PlayerView> playerCache = new GameEntityCache();
    private final Table<Integer, Long, Card> changeZoneLKIInfo = HashBasedTable.create();
    private int cardIdCounter = 0;
    private int hiddenCardIdCounter = 0;

    private static int nextId() {
        return ++maxId;
    }

    public int getId() {
        return this.id;
    }

    public Player getStartingPlayer() {
        return this.startingPlayer;
    }

    public void setStartingPlayer(Player p) {
        this.startingPlayer = p;
    }

    public Player getMonarch() {
        return this.monarch;
    }

    public void setMonarch(Player p) {
        this.monarch = p;
    }

    public Player getMonarchBeginTurn() {
        return this.monarchBeginTurn;
    }

    public void setMonarchBeginTurn(Player monarchBeginTurn) {
        this.monarchBeginTurn = monarchBeginTurn;
    }

    public Player getHasInitiative() {
        return this.initiative;
    }

    public void setHasInitiative(Player p) {
        this.initiative = p;
    }

    public CardZoneTable getUntilHostLeavesPlayTriggerList() {
        return this.untilHostLeavesPlayTriggerList;
    }

    public CardCollectionView getLastStateBattlefield() {
        return this.lastStateBattlefield;
    }

    public CardCollectionView getLastStateGraveyard() {
        return this.lastStateGraveyard;
    }

    public void stashGameState() {
        if (this.EXPERIMENTAL_RESTORE_SNAPSHOT) {
            this.previousGameState = new GameSnapshot(this);
            this.previousGameState.makeCopy();
        }
    }

    public boolean restoreGameState() {
        if (this.previousGameState == null || !this.EXPERIMENTAL_RESTORE_SNAPSHOT) {
            return false;
        }
        this.previousGameState.restoreGameState(this);
        return true;
    }

    public void copyLastState() {
        this.lastStateBattlefield.clear();
        this.lastStateGraveyard.clear();
        HashMap<Integer, Card> cachedMap = Maps.newHashMap();
        for (Player p : this.getPlayers()) {
            this.lastStateBattlefield.addAll(p.getZone(ZoneType.Battlefield).getLKICopy(cachedMap));
            this.lastStateGraveyard.addAll(p.getZone(ZoneType.Graveyard).getLKICopy(cachedMap));
        }
    }

    public CardCollectionView copyLastState(ZoneType type) {
        CardCollection result = new CardCollection();
        HashMap<Integer, Card> cachedMap = Maps.newHashMap();
        for (Player p : this.getPlayers()) {
            result.addAll(p.getZone(type).getLKICopy(cachedMap));
        }
        return result;
    }

    public CardCollectionView copyLastStateBattlefield() {
        return this.copyLastState(ZoneType.Battlefield);
    }

    public CardCollectionView copyLastStateGraveyard() {
        return this.copyLastState(ZoneType.Graveyard);
    }

    public void updateLastStateForCard(Card c) {
        CardCollection lookup;
        if (c == null || c.getZone() == null) {
            return;
        }
        ZoneType zone = c.getZone().getZoneType();
        CardCollection cardCollection = zone.equals((Object)ZoneType.Battlefield) ? this.lastStateBattlefield : (lookup = zone.equals((Object)ZoneType.Graveyard) ? this.lastStateGraveyard : null);
        if (lookup != null) {
            this.lastStateBattlefield.remove(c);
            this.lastStateGraveyard.remove(c);
            lookup.add(CardCopyService.getLKICopy(c));
        }
    }

    public Player getPlayer(PlayerView playerView) {
        return this.playerCache.get(playerView);
    }

    public Player getPlayer(int id) {
        for (Player p : this.allPlayers) {
            if (p.getId() != id) continue;
            return p;
        }
        return null;
    }

    public void addPlayer(int id, Player player) {
        this.playerCache.put(id, player);
    }

    public final void addChangeZoneLKIInfo(Card lki) {
        if (lki == null) {
            return;
        }
        this.changeZoneLKIInfo.put(lki.getId(), lki.getGameTimestamp(), lki);
    }

    public final Card getChangeZoneLKIInfo(Card c) {
        if (c == null) {
            return null;
        }
        return ObjectUtils.defaultIfNull(this.changeZoneLKIInfo.get(c.getId(), c.getGameTimestamp()), c);
    }

    public final void clearChangeZoneLKIInfo() {
        this.changeZoneLKIInfo.clear();
    }

    public void addLeftBattlefieldThisTurn(Card lki) {
        this.leftBattlefieldThisTurn.add(lki);
    }

    public void addLeftGraveyardThisTurn(Card lki) {
        this.leftGraveyardThisTurn.add(lki);
    }

    public List<Card> getLeftBattlefieldThisTurn() {
        return this.leftBattlefieldThisTurn;
    }

    public List<Card> getLeftGraveyardThisTurn() {
        return this.leftGraveyardThisTurn;
    }

    public void clearLeftBattlefieldThisTurn() {
        this.leftBattlefieldThisTurn.clear();
    }

    public void clearLeftGraveyardThisTurn() {
        this.leftGraveyardThisTurn.clear();
    }

    public Game(Iterable<RegisteredPlayer> players0, GameRules rules0, Match match0) {
        this(players0, rules0, match0, null, -1);
    }

    public Game(Iterable<RegisteredPlayer> players0, GameRules rules0, Match match0, Game maingame0, int startingLife) {
        this.rules = rules0;
        this.match = match0;
        this.maingame = maingame0;
        this.id = Game.nextId();
        int highestTeam = -1;
        for (RegisteredPlayer psc : players0) {
            int teamNum = psc.getTeamNumber();
            if (teamNum <= highestTeam) continue;
            highestTeam = teamNum;
        }
        this.view = new GameView(this);
        int plId = 0;
        for (RegisteredPlayer psc : players0) {
            int teamNum;
            IGameEntitiesFactory factory = (IGameEntitiesFactory)((Object)psc.getPlayer());
            Integer id = psc.getId();
            Player pl = factory.createIngamePlayer(this, id == null ? plId++ : id);
            this.allPlayers.add(pl);
            this.ingamePlayers.add(pl);
            if (startingLife != -1) {
                pl.setStartingLife(startingLife);
            } else {
                pl.setStartingLife(psc.getStartingLife());
            }
            pl.setMaxHandSize(psc.getStartingHand());
            pl.setStartingHandSize(psc.getStartingHand());
            if (psc.getManaShards() > 0) {
                pl.setNumManaShards(psc.getManaShards());
            }
            if ((teamNum = psc.getTeamNumber()) == -1) {
                teamNum = ++highestTeam;
                psc.setTeamNumber(teamNum);
            }
            pl.setTeam(teamNum);
        }
        this.action = new GameAction(this);
        this.stack = new MagicStack(this);
        this.phaseHandler = new PhaseHandler(this);
        this.untap = new Untap(this);
        this.upkeep = new Phase(PhaseType.UPKEEP);
        this.cleanup = new Phase(PhaseType.CLEANUP);
        this.endOfCombat = new Phase(PhaseType.COMBAT_END);
        this.endOfTurn = new Phase(PhaseType.END_OF_TURN);
        this.sbaCheckedCommandList = new ArrayList<GameCommand>();
        this.view.updatePlayers(this);
        this.subscribeToEvents(this.gameLog.getEventVisitor());
    }

    public GameView getView() {
        return this.view;
    }

    public Tracker getTracker() {
        return this.tracker;
    }

    public final PlayerCollection getPlayers() {
        return this.ingamePlayers;
    }

    public final PlayerCollection getLostPlayers() {
        return this.lostPlayers;
    }

    public final PlayerCollection getPlayersInTurnOrder() {
        if (this.getTurnOrder().isDefaultDirection()) {
            return this.ingamePlayers;
        }
        PlayerCollection players = new PlayerCollection(this.ingamePlayers);
        Collections.reverse(players);
        return players;
    }

    public final PlayerCollection getPlayersInTurnOrder(Player p) {
        PlayerCollection players = new PlayerCollection(this.getPlayersInTurnOrder());
        int i = players.indexOf(p);
        Collections.rotate(players, -i);
        return players;
    }

    public final PlayerCollection getNonactivePlayers() {
        PlayerCollection players = new PlayerCollection(this.ingamePlayers);
        players.remove(this.phaseHandler.getPlayerTurn());
        if (!this.getTurnOrder().isDefaultDirection()) {
            Collections.reverse(players);
        }
        return players;
    }

    public final PlayerCollection getRegisteredPlayers() {
        return this.allPlayers;
    }

    public final Untap getUntap() {
        return this.untap;
    }

    public final Phase getUpkeep() {
        return this.upkeep;
    }

    public final Phase getEndOfCombat() {
        return this.endOfCombat;
    }

    public final Phase getEndOfTurn() {
        return this.endOfTurn;
    }

    public final Phase getCleanup() {
        return this.cleanup;
    }

    public void addSBACheckedCommand(GameCommand c) {
        this.sbaCheckedCommandList.add(c);
    }

    public final void runSBACheckedCommands() {
        for (GameCommand c : this.sbaCheckedCommandList) {
            c.run();
        }
        this.sbaCheckedCommandList.clear();
    }

    public final PhaseHandler getPhaseHandler() {
        return this.phaseHandler;
    }

    public final void updateTurnForView() {
        this.view.updateTurn(this.phaseHandler);
    }

    public final void updatePhaseForView() {
        this.view.updatePhase(this.phaseHandler);
    }

    public final void updatePlayerTurnForView() {
        this.view.updatePlayerTurn(this.phaseHandler);
    }

    public final MagicStack getStack() {
        return this.stack;
    }

    public final void updateStackForView() {
        this.view.updateStack(this.stack);
    }

    public final StaticEffects getStaticEffects() {
        return this.staticEffects;
    }

    public final TriggerHandler getTriggerHandler() {
        return this.triggerHandler;
    }

    public final Combat getCombat() {
        return this.getPhaseHandler().getCombat();
    }

    public final void updateCombatForView() {
        this.view.updateCombat(this.getCombat());
    }

    public final GameLog getGameLog() {
        return this.gameLog;
    }

    public final void updateGameLogForView() {
        this.view.updateGameLog(this.gameLog);
    }

    public final Zone getStackZone() {
        return this.stackZone;
    }

    public CardCollectionView getCardsPlayerCanActivateInStack() {
        return CardLists.filter((Iterable<Card>)this.stackZone.getCards(), c -> {
            for (SpellAbility sa : c.getSpellAbilities()) {
                ZoneType restrictZone = sa.getRestrictions().getZone();
                if (ZoneType.Stack != restrictZone) continue;
                return true;
            }
            return false;
        });
    }

    public final Direction getTurnOrder() {
        if (this.phaseHandler.getPlayerTurn() != null && this.phaseHandler.getPlayerTurn().getAmountOfKeyword("The turn order is reversed.") % 2 == 1) {
            return this.turnOrder.getOtherDirection();
        }
        return this.turnOrder;
    }

    public final void reverseTurnOrder() {
        this.turnOrder = this.turnOrder.getOtherDirection();
    }

    public final void resetTurnOrder() {
        this.turnOrder = Direction.getDefaultDirection();
    }

    public final long getNextTimestamp() {
        this.timestamp = this.getTimestamp() + 1L;
        return this.getTimestamp();
    }

    public final long getTimestamp() {
        return this.timestamp;
    }

    public void dangerouslySetTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public final GameOutcome getOutcome() {
        return this.outcome;
    }

    public final Game getMaingame() {
        return this.maingame;
    }

    public ReplacementHandler getReplacementHandler() {
        return this.replacementHandler;
    }

    public synchronized boolean isGameOver() {
        return this.age == GameStage.GameOver;
    }

    public synchronized void setGameOver(GameEndReason reason) {
        for (Player p : this.allPlayers) {
            p.clearController();
        }
        this.age = GameStage.GameOver;
        for (Player p : this.getPlayers()) {
            p.onGameOver();
        }
        GameOutcome result = new GameOutcome(reason, this.getRegisteredPlayers());
        result.setTurnsPlayed(this.getPhaseHandler().getTurn());
        this.outcome = result;
        if (this.maingame == null) {
            this.match.addGamePlayed(this);
        }
        this.view.updateGameOver(this);
        if (this.maingame == null) {
            this.fireEvent(new GameEventGameOutcome(result, this.match.getOutcomes()));
        }
    }

    public Zone getZoneOf(Card card) {
        return card.getLastKnownZone();
    }

    public synchronized CardCollectionView getCardsIn(ZoneType zone) {
        if (zone == ZoneType.Stack) {
            return this.getStackZone().getCards();
        }
        return this.getPlayers().getCardsIn(zone);
    }

    public CardCollectionView getCardsIncludePhasingIn(ZoneType zone) {
        if (zone == ZoneType.Stack) {
            return this.getStackZone().getCards();
        }
        CardCollection cards = new CardCollection();
        for (Player p : this.getPlayers()) {
            cards.addAll(p.getCardsIn(zone, false));
        }
        return cards;
    }

    public CardCollectionView getCardsIn(Iterable<ZoneType> zones) {
        CardCollection cards = new CardCollection();
        for (ZoneType z : zones) {
            cards.addAll(this.getCardsIn(z));
        }
        return cards;
    }

    public CardCollectionView getCardsInOwnedBy(Iterable<ZoneType> zones, Player p) {
        CardCollection cards = new CardCollection();
        for (ZoneType z : zones) {
            cards.addAll(this.getCardsIncludePhasingIn(z));
        }
        return CardLists.filter((Iterable<Card>)cards, CardPredicates.isOwner(p));
    }

    public boolean isCardExiled(Card c) {
        return this.getCardsIn(ZoneType.Exile).contains(c);
    }

    public boolean isCardInPlay(String cardName) {
        return Iterables.any(this.getCardsIn(ZoneType.Battlefield), CardPredicates.nameEquals(cardName));
    }

    public boolean isCardInCommand(String cardName) {
        return Iterables.any(this.getCardsIn(ZoneType.Command), CardPredicates.nameEquals(cardName));
    }

    public CardCollectionView getColoredCardsInPlay(String color) {
        CardCollection cards = new CardCollection();
        for (Player p : this.getPlayers()) {
            cards.addAll(p.getColoredCardsInPlay(color));
        }
        return cards;
    }

    public Card getCardState(Card card) {
        return this.getCardState(card, card);
    }

    public Card getCardState(Card card, Card notFound) {
        CardStateVisitor visit = new CardStateVisitor(card);
        this.forEachCardInGame(visit);
        return visit.getFound(notFound);
    }

    public Card findByView(CardView view) {
        if (view == null) {
            return null;
        }
        CardIdVisitor visit = new CardIdVisitor(view.getId());
        if (ZoneType.Stack.equals((Object)view.getZone())) {
            visit.visitAll(this.getStackZone());
        } else if (view.getController() != null && view.getZone() != null) {
            visit.visitAll(this.getPlayer(view.getController()).getZone(view.getZone()));
        } else {
            this.forEachCardInGame(visit);
        }
        return visit.getFound();
    }

    public Card findById(int id) {
        CardIdVisitor visit = new CardIdVisitor(id);
        this.forEachCardInGame(visit);
        return visit.getFound();
    }

    public void forEachCardInGame(Visitor<Card> visitor) {
        this.forEachCardInGame(visitor, false);
    }

    public void forEachCardInGame(Visitor<Card> visitor, boolean withSideboard) {
        for (Player player : this.getPlayers()) {
            if (!visitor.visitAll(player.getZone(ZoneType.Graveyard).getCards())) {
                return;
            }
            if (!visitor.visitAll(player.getZone(ZoneType.Hand).getCards())) {
                return;
            }
            if (!visitor.visitAll(player.getZone(ZoneType.Library).getCards())) {
                return;
            }
            if (!visitor.visitAll(player.getZone(ZoneType.Battlefield).getCards(false))) {
                return;
            }
            if (!visitor.visitAll(player.getZone(ZoneType.Exile).getCards())) {
                return;
            }
            if (!visitor.visitAll(player.getZone(ZoneType.Command).getCards())) {
                return;
            }
            if (withSideboard && !visitor.visitAll(player.getZone(ZoneType.Sideboard).getCards())) {
                return;
            }
            if (visitor.visitAll(player.getInboundTokens())) continue;
            return;
        }
        visitor.visitAll(this.getStackZone().getCards());
    }

    public CardCollectionView getCardsInGame() {
        final CardCollection all = new CardCollection();
        Visitor<Card> visitor = new Visitor<Card>(){

            @Override
            public boolean visit(Card card) {
                all.add(card);
                return true;
            }
        };
        this.forEachCardInGame(visitor);
        return all;
    }

    public final GameAction getAction() {
        return this.action;
    }

    public final Match getMatch() {
        return this.match;
    }

    public Player getNextPlayerAfter(Player playerTurn) {
        return this.getNextPlayerAfter(playerTurn, this.getTurnOrder());
    }

    public Player getNextPlayerAfter(Player playerTurn, Direction turnOrder) {
        int iPlayer = this.ingamePlayers.indexOf(playerTurn);
        if (this.ingamePlayers.isEmpty()) {
            return null;
        }
        int shift = turnOrder.getShift();
        if (-1 == iPlayer) {
            int iAlive;
            int totalNumPlayers = this.allPlayers.size();
            iPlayer = this.allPlayers.indexOf(playerTurn);
            do {
                if ((iPlayer = (iPlayer + shift) % totalNumPlayers) >= 0) continue;
                iPlayer += totalNumPlayers;
            } while ((iAlive = this.ingamePlayers.indexOf(this.allPlayers.get(iPlayer))) < 0);
            iPlayer = iAlive;
        } else {
            int numPlayersInGame = this.ingamePlayers.size();
            if ((iPlayer = (iPlayer + shift) % numPlayersInGame) < 0) {
                iPlayer += numPlayersInGame;
            }
        }
        return (Player)this.ingamePlayers.get(iPlayer);
    }

    public int getPosition(Player player, Player startingPlayer) {
        int myPosition;
        int startPosition = this.ingamePlayers.indexOf(startingPlayer);
        if (startPosition > (myPosition = this.ingamePlayers.indexOf(player))) {
            myPosition += this.ingamePlayers.size();
        }
        return myPosition - startPosition + 1;
    }

    public void onPlayerLost(Player p) {
        p.setHasLost(true);
        CardCollectionView cards = this.getCardsInGame();
        boolean planarControllerLost = false;
        boolean planarOwnerLost = false;
        boolean isMultiplayer = this.getPlayers().size() > 2;
        CardZoneTable triggerList = new CardZoneTable(this.getLastStateBattlefield(), this.getLastStateGraveyard());
        if (!isMultiplayer) {
            for (Player pl : this.getPlayers()) {
                pl.revealFaceDownCards();
            }
        } else {
            p.revealFaceDownCards();
        }
        for (Card c : cards) {
            if (!c.getOwner().equals(p) || !c.getController().equals(p)) continue;
            c.getGame().getTriggerHandler().clearActiveTriggers(c, null);
        }
        for (Card c : cards) {
            if (c.isPlane() || c.isPhenomenon()) {
                if (c.getController().equals(p)) {
                    planarControllerLost = true;
                }
                if (c.getOwner().equals(p)) {
                    planarOwnerLost = true;
                }
            }
            if (isMultiplayer) {
                c.removeAttachedTo(p);
                if (c.getOwner().equals(p)) {
                    if (c.getEffectSource() != null && !c.isEmblem()) {
                        c.getZone().remove(c);
                        this.getNextPlayerAfter(p).getZone(ZoneType.Command).add(c);
                        continue;
                    }
                    for (Card cc : cards) {
                        cc.removeImprintedCard(c);
                        cc.removeEncodedCard(c);
                        cc.removeRemembered(c);
                        cc.removeAttachedTo(c);
                        cc.removeAttachedCard(c);
                    }
                    triggerList.put(c.getZone().getZoneType(), null, c);
                    this.getAction().ceaseToExist(c, false);
                    this.getTriggerHandler().clearDelayedTrigger(c);
                    continue;
                }
                if (c.isInPlay() && (c.getController().equals(p) || c.getZone().getPlayer().equals(p))) {
                    c.removeTempController(p);
                    this.getAction().controllerChangeZoneCorrection(c);
                }
                c.removeTempController(p);
                if (c.isInZone(ZoneType.Stack)) {
                    SpellAbilityStackInstance si = this.getStack().getInstanceMatchingSpellAbilityID(c.getCastSA());
                    si.setActivatingPlayer(c.getController());
                }
                if (!c.getController().equals(p) || c.isPlane() || c.isPhenomenon()) continue;
                this.getAction().exile(c, null, null);
                triggerList.put(ZoneType.Battlefield, c.getZone().getZoneType(), c);
                continue;
            }
            c.forceTurnFaceUp();
        }
        triggerList.triggerChangesZoneAll(this, null);
        if (planarControllerLost) {
            for (Card c : this.getActivePlanes()) {
                if (c == null || c.getOwner().equals(p)) continue;
                c.setController(this.getNextPlayerAfter(p), 0L);
                this.getAction().controllerChangeZoneCorrection(c);
            }
        }
        if (planarOwnerLost) {
            Player planarController = this.getPhaseHandler().getPlayerTurn();
            if (planarController.equals(p)) {
                planarController = this.getNextPlayerAfter(p);
            }
            EnumMap<AbilityKey, Object> runParams = AbilityKey.newMap();
            CardCollection planesLeavingGame = new CardCollection();
            for (Card c : this.getActivePlanes()) {
                if (c == null || !c.getOwner().equals(p)) continue;
                planesLeavingGame.add(c);
                planarController.removeCurrentPlane(c);
            }
            runParams.put(AbilityKey.Cards, planesLeavingGame);
            this.getTriggerHandler().runTrigger(TriggerType.PlaneswalkedFrom, runParams, false);
            planarController.planeswalk(null);
        }
        if (p.isMonarch()) {
            if (p.equals(this.getPhaseHandler().getPlayerTurn())) {
                this.getAction().becomeMonarch(this.getNextPlayerAfter(p), null);
            } else {
                this.getAction().becomeMonarch(this.getPhaseHandler().getPlayerTurn(), null);
            }
        }
        if (p.hasInitiative()) {
            if (p.equals(this.getPhaseHandler().getPlayerTurn())) {
                this.getAction().takeInitiative(this.getNextPlayerAfter(p), null);
            } else {
                this.getAction().takeInitiative(this.getPhaseHandler().getPlayerTurn(), null);
            }
        }
        this.getStack().removeInstancesControlledBy(p);
        this.getTriggerHandler().onPlayerLost(p);
        this.ingamePlayers.remove(p);
        this.lostPlayers.add(p);
        Map<AbilityKey, Object> runParams = AbilityKey.mapFromPlayer(p);
        this.getTriggerHandler().runTrigger(TriggerType.LosesGame, runParams, false);
    }

    public void fireEvent(Event event) {
        this.events.post(event);
    }

    public void subscribeToEvents(Object subscriber) {
        this.events.register(subscriber);
    }

    public GameRules getRules() {
        return this.rules;
    }

    public List<Card> getActivePlanes() {
        return this.activePlanes;
    }

    public void setActivePlanes(List<Card> activePlane0) {
        this.activePlanes = activePlane0;
    }

    public GameStage getAge() {
        return this.age;
    }

    public void setAge(GameStage value) {
        this.age = value;
    }

    public int nextCardId() {
        return ++this.cardIdCounter;
    }

    public int nextHiddenCardId() {
        return ++this.hiddenCardIdCounter;
    }

    public Multimap<Player, Card> chooseCardsForAnte(boolean matchRarity) {
        ArrayListMultimap<Player, Card> anteed = ArrayListMultimap.create();
        if (matchRarity) {
            boolean onePlayerHasTimeShifted = false;
            ArrayList<CardRarity> validRarities = new ArrayList<CardRarity>(Arrays.asList(CardRarity.values()));
            for (Player player : this.getPlayers()) {
                Set<CardRarity> playerRarity = Game.getValidRarities(player.getCardsIn(ZoneType.Library));
                if (!onePlayerHasTimeShifted) {
                    onePlayerHasTimeShifted = playerRarity.contains((Object)CardRarity.Special);
                }
                validRarities.retainAll(playerRarity);
            }
            if (validRarities.size() == 0) {
                for (Player player : this.getPlayers()) {
                    this.chooseRandomCardsForAnte(player, anteed);
                }
                return anteed;
            }
            if (validRarities.size() > 1) {
                validRarities.remove((Object)CardRarity.BasicLand);
            }
            if (validRarities.contains((Object)CardRarity.Special)) {
                onePlayerHasTimeShifted = false;
            }
            CardRarity anteRarity = (CardRarity)((Object)validRarities.get(MyRandom.getRandom().nextInt(validRarities.size())));
            System.out.println("Rarity chosen for ante: " + anteRarity.name());
            for (Player player : this.getPlayers()) {
                CardCollection library = new CardCollection(player.getCardsIn(ZoneType.Library));
                CardCollection toRemove = new CardCollection();
                for (Card card : library) {
                    if (onePlayerHasTimeShifted && card.getRarity() == CardRarity.Special) continue;
                    if (anteRarity == CardRarity.MythicRare || anteRarity == CardRarity.Rare) {
                        if (card.getRarity() == CardRarity.MythicRare || card.getRarity() == CardRarity.Rare) continue;
                        toRemove.add(card);
                        continue;
                    }
                    if (card.getRarity() == anteRarity) continue;
                    toRemove.add(card);
                }
                library.removeAll(toRemove);
                if (library.size() > 0) {
                    Card ante = (Card)library.get(MyRandom.getRandom().nextInt(library.size()));
                    anteed.put(player, ante);
                    continue;
                }
                this.chooseRandomCardsForAnte(player, anteed);
            }
        } else {
            for (Player player : this.getPlayers()) {
                this.chooseRandomCardsForAnte(player, anteed);
            }
        }
        return anteed;
    }

    private void chooseRandomCardsForAnte(Player player, Multimap<Player, Card> anteed) {
        Predicate<Card> goodForAnte;
        CardCollectionView lib = player.getCardsIn(ZoneType.Library);
        Card ante = Aggregates.random(Iterables.filter(lib, goodForAnte = Predicates.not(CardPredicates.Presets.BASIC_LANDS)));
        if (ante == null) {
            this.getGameLog().add(GameLogEntryType.ANTE, "Only basic lands found. Will ante one of them");
            ante = Aggregates.random(lib);
        }
        anteed.put(player, ante);
    }

    private static Set<CardRarity> getValidRarities(Iterable<Card> cards) {
        HashSet<CardRarity> rarities = new HashSet<CardRarity>();
        for (Card card : cards) {
            if (card.getRarity() == CardRarity.Rare || card.getRarity() == CardRarity.MythicRare) {
                rarities.add(CardRarity.Rare);
                continue;
            }
            rarities.add(card.getRarity());
        }
        return rarities;
    }

    public void clearCaches() {
        this.lastStateBattlefield.clear();
        this.lastStateGraveyard.clear();
    }

    public boolean isGraveyardOrdered(Player p) {
        for (Card c : p.getAllCards()) {
            if (c.hasSVar("NeedsOrderedGraveyard")) {
                return true;
            }
            if (!c.getOriginalState(CardStateName.Original).hasSVar("NeedsOrderedGraveyard")) continue;
            return true;
        }
        for (Card c : p.getOpponents().getCardsIn(ZoneType.Battlefield)) {
            if (!"opponent".equalsIgnoreCase(c.getSVar("NeedsOrderedGraveyard"))) continue;
            return true;
        }
        return false;
    }

    public Player getControlVote() {
        Player result = null;
        long maxValue = 0L;
        for (Player p : this.getPlayers()) {
            Long v = p.getHighestControlVote();
            if (v == null || v <= maxValue) continue;
            maxValue = v;
            result = p;
        }
        return result;
    }

    public void incPiledGuessedSA() {
        ++this.numPiledGuessedSA;
    }

    public int getNumPiledGuessedSA() {
        return this.numPiledGuessedSA;
    }

    public void resetNumPiledGuessedSA() {
        this.numPiledGuessedSA = 0;
    }

    public void onCleanupPhase() {
        this.resetNumPiledGuessedSA();
        this.clearLeftBattlefieldThisTurn();
        this.clearLeftGraveyardThisTurn();
        this.clearCounterAddedThisTurn();
        this.clearCounterRemovedThisTurn();
        this.clearGlobalDamageHistory();
        for (Player player : this.getRegisteredPlayers()) {
            player.onCleanupPhase();
        }
    }

    public void addCounterAddedThisTurn(Player putter, CounterType cType, Card card, Integer value) {
        if (putter == null || card == null || value <= 0) {
            return;
        }
        List<Pair<Card, Integer>> result = this.countersAddedThisTurn.get(cType, putter);
        if (result == null) {
            result = Lists.newArrayList();
            this.countersAddedThisTurn.put(cType, putter, result);
        }
        result.add(Pair.of(CardCopyService.getLKICopy(card), value));
    }

    public int getCounterAddedThisTurn(CounterType cType, String validPlayer, String validCard, Card source, Player sourceController, CardTraitBase ctb) {
        int result = 0;
        if (!this.countersAddedThisTurn.containsRow(cType)) {
            return result;
        }
        for (Map.Entry<Player, List<Pair<Card, Integer>>> e : this.countersAddedThisTurn.row(cType).entrySet()) {
            if (!e.getKey().isValid(validPlayer.split(","), sourceController, source, ctb)) continue;
            for (Pair<Card, Integer> p : e.getValue()) {
                if (!p.getKey().isValid(validCard.split(","), sourceController, source, ctb)) continue;
                result += p.getValue().intValue();
            }
        }
        return result;
    }

    public int getCounterAddedThisTurn(CounterType cType, Card card) {
        int result = 0;
        if (!this.countersAddedThisTurn.containsRow(cType)) {
            return result;
        }
        for (List<Pair<Card, Integer>> l : this.countersAddedThisTurn.row(cType).values()) {
            for (Pair<Card, Integer> p : l) {
                if (!p.getKey().equalsWithGameTimestamp(card)) continue;
                result += p.getValue().intValue();
            }
        }
        return result;
    }

    public void clearCounterAddedThisTurn() {
        this.countersAddedThisTurn.clear();
    }

    public void addCounterRemovedThisTurn(CounterType cType, Card card, Integer value) {
        this.countersRemovedThisTurn.put(cType, Pair.of(CardCopyService.getLKICopy(card), value));
    }

    public void addCounterRemovedThisTurn(CounterType cType, Player player, Integer value) {
        this.countersRemovedThisTurn.put(cType, Pair.of(player, value));
    }

    public int getCounterRemovedThisTurn(CounterType cType, String valid, Card source, Player sourceController, CardTraitBase ctb) {
        int result = 0;
        for (Pair<GameEntity, Integer> p : this.countersRemovedThisTurn.get(cType)) {
            if (!p.getKey().isValid(valid.split(","), sourceController, source, ctb)) continue;
            result += p.getValue().intValue();
        }
        return result;
    }

    public void clearCounterRemovedThisTurn() {
        this.countersRemovedThisTurn.clear();
    }

    public List<Integer> getDamageDoneThisTurn(Boolean isCombat, boolean anyIsEnough, String validSourceCard, String validTargetEntity, Card source, Player sourceController, CardTraitBase ctb) {
        ArrayList<Integer> dmgList = Lists.newArrayList();
        for (CardDamageHistory cdh : this.globalDamageHistory) {
            int dmg = cdh.getDamageDoneThisTurn(isCombat, anyIsEnough, validSourceCard, validTargetEntity, source, sourceController, ctb);
            if (dmg == 0) continue;
            dmgList.add(dmg);
            if (!anyIsEnough) continue;
            break;
        }
        return dmgList;
    }

    public void addGlobalDamageHistory(CardDamageHistory cdh, Pair<Integer, Boolean> dmg, Card source, GameEntity target) {
        this.globalDamageHistory.add(cdh);
        this.damageThisTurnLKI.put(dmg, Pair.of(source, target));
    }

    public void clearGlobalDamageHistory() {
        this.globalDamageHistory.clear();
        this.damageThisTurnLKI.clear();
    }

    public Pair<Card, GameEntity> getDamageLKI(Pair<Integer, Boolean> dmg) {
        return this.damageThisTurnLKI.get(dmg);
    }

    public Card getTopLibForPlayer(Player P) {
        return this.topLibsCast.get(P);
    }

    public void setTopLibsCast() {
        Iterator iterator = this.getPlayers().iterator();
        while (iterator.hasNext()) {
            Player p;
            this.topLibsCast.put(p, (p = (Player)iterator.next()).getTopXCardsFromLibrary(1).isEmpty() ? null : (Card)p.getTopXCardsFromLibrary(1).get(false));
        }
    }

    public void clearTopLibsCast(SpellAbility sa) {
        if (sa.getActivatingPlayer().getPaidForSA() == null) {
            this.topLibsCast.clear();
            for (Card c : this.facedownWhileCasting.keySet()) {
                if (!c.isInZone(ZoneType.Hand)) continue;
                c.forceTurnFaceUp();
                Map<AbilityKey, Object> runParams = AbilityKey.mapFromCard(c);
                runParams.put(AbilityKey.Number, this.facedownWhileCasting.get(c));
                runParams.put(AbilityKey.Player, c.getOwner());
                runParams.put(AbilityKey.CanReveal, true);
                this.getTriggerHandler().runTrigger(TriggerType.Drawn, runParams, true);
            }
            this.facedownWhileCasting.clear();
        }
    }

    public void addFacedownWhileCasting(Card c, int numDrawn) {
        this.facedownWhileCasting.put(c, numDrawn);
    }

    public boolean isDay() {
        return this.daytime != null && this.daytime == false;
    }

    public boolean isNight() {
        return this.daytime != null && this.daytime == true;
    }

    public boolean isNeitherDayNorNight() {
        return this.daytime == null;
    }

    public Boolean getDayTime() {
        return this.daytime;
    }

    public void setDayTime(Boolean value) {
        if (StaticAbilityCantChangeDayTime.cantChangeDay(this, value)) {
            return;
        }
        Boolean previous = this.daytime;
        this.daytime = value;
        if (previous != null && value != null && previous != value) {
            EnumMap<AbilityKey, Object> params = AbilityKey.newMap();
            this.getTriggerHandler().runTrigger(TriggerType.DayTimeChanges, params, false);
        }
        if (!this.isNeitherDayNorNight()) {
            this.fireEvent(new GameEventDayTimeChanged(this.isDay()));
        }
    }

    private static class CardIdVisitor
    extends Visitor<Card> {
        Card found = null;
        int id;

        private CardIdVisitor(int id) {
            this.id = id;
        }

        @Override
        public boolean visit(Card object) {
            if (this.id == object.getId()) {
                this.found = object;
            }
            return this.found == null;
        }

        public Card getFound() {
            return this.found;
        }
    }

    private static class CardStateVisitor
    extends Visitor<Card> {
        Card found = null;
        Card old = null;

        private CardStateVisitor(Card card) {
            this.old = card;
        }

        @Override
        public boolean visit(Card object) {
            if (object.equals(this.old)) {
                this.found = object;
            }
            return this.found == null;
        }

        public Card getFound(Card notFound) {
            return this.found == null ? notFound : this.found;
        }
    }
}

