/*
 * Decompiled with CFR 0.152.
 */
package forge.game;

import com.google.common.collect.ImmutableList;
import java.util.List;

public enum Direction {
    Left,
    Right;

    private static final String LEFT = "Left";
    private static final String RIGHT = "Right";
    private static final List<Direction> listOfDirections;

    public static final Direction getDefaultDirection() {
        return Left;
    }

    public static List<Direction> getListOfDirections() {
        return listOfDirections;
    }

    public boolean isDefaultDirection() {
        return this.equals((Object)Direction.getDefaultDirection());
    }

    public int getShift() {
        if (this.isDefaultDirection()) {
            return 1;
        }
        return -1;
    }

    public Direction getOtherDirection() {
        switch (this) {
            case Left: {
                return Right;
            }
            case Right: {
                return Left;
            }
        }
        return null;
    }

    public String toString() {
        switch (this) {
            case Left: {
                return LEFT;
            }
            case Right: {
                return RIGHT;
            }
        }
        return null;
    }

    static {
        listOfDirections = ImmutableList.of(Direction.getDefaultDirection(), Direction.getDefaultDirection().getOtherDirection());
    }
}

