/*
 * Decompiled with CFR 0.152.
 */
package forge.error;

import com.esotericsoftware.minlog.Log;
import forge.FTrace;
import forge.gui.error.BugReporter;
import forge.localinstance.properties.ForgeConstants;
import forge.util.MultiplexOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;

public class ExceptionHandler
implements Thread.UncaughtExceptionHandler {
    private static PrintStream oldSystemOut;
    private static PrintStream oldSystemErr;
    private static OutputStream logFileStream;

    public static void registerErrorHandling() {
        File logFile = new File(ForgeConstants.LOG_FILE);
        int i = 0;
        while (logFile.exists() && !logFile.delete()) {
            String pathname = logFile.getPath().replaceAll("[0-9]{0,2}.log$", i++ + ".log");
            logFile = new File(pathname);
        }
        if (!logFile.exists()) {
            try {
                logFile.getParentFile().mkdirs();
                logFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            logFileStream = new FileOutputStream(logFile);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        oldSystemOut = System.out;
        System.setOut(new PrintStream(new MultiplexOutputStream(System.out, logFileStream), true));
        oldSystemErr = System.err;
        System.setErr(new PrintStream(new MultiplexOutputStream(System.err, logFileStream), true));
        Log.debug("Error handling registered!");
        FTrace.initialize();
    }

    public static void unregisterErrorHandling() throws IOException {
        FTrace.dump();
        System.setOut(oldSystemOut);
        System.setErr(oldSystemErr);
        logFileStream.close();
    }

    @Override
    public final void uncaughtException(Thread t2, Throwable ex) {
        BugReporter.reportException(ex);
    }

    public final void handle(Throwable ex) {
        BugReporter.reportException(ex);
    }

    static {
        Thread.setDefaultUncaughtExceptionHandler(new ExceptionHandler());
        System.setProperty("sun.awt.exception.handler", ExceptionHandler.class.getName());
    }
}

