/*
 * Decompiled with CFR 0.152.
 */
package forge.deck.io;

import forge.deck.Deck;
import forge.deck.DeckBase;
import forge.deck.io.DeckSerializer;
import forge.util.FileSection;
import forge.util.FileUtil;
import forge.util.IItemReader;
import forge.util.IItemSerializer;
import forge.util.storage.StorageReaderFolder;
import java.io.File;
import java.io.FilenameFilter;
import java.util.List;
import java.util.Map;

public class DeckStorage
extends StorageReaderFolder<Deck>
implements IItemSerializer<Deck> {
    public static final String FILE_EXTENSION = ".dck";
    private final String rootDir;
    private final boolean moveWronglyNamedDecks;
    public static final FilenameFilter DCK_FILE_FILTER = (dir, name) -> name.endsWith(FILE_EXTENSION);

    public DeckStorage(File deckDir0, String rootDir0) {
        this(deckDir0, rootDir0, false);
    }

    public DeckStorage(File deckDir0, String rootDir0, boolean moveWrongDecks) {
        super(deckDir0, DeckBase::getName);
        this.rootDir = rootDir0;
        this.moveWronglyNamedDecks = moveWrongDecks;
    }

    @Override
    public IItemReader<Deck> getReaderForFolder(File subfolder) {
        if (!subfolder.getParentFile().equals(this.directory)) {
            throw new UnsupportedOperationException("Only child folders of " + this.directory + " may be processed");
        }
        return new DeckStorage(subfolder, this.rootDir, false);
    }

    @Override
    public void save(Deck unit) {
        DeckSerializer.writeDeck(unit, this.makeFileFor(unit));
    }

    @Override
    public void erase(Deck unit) {
        this.makeFileFor(unit).delete();
    }

    public File makeFileFor(Deck deck) {
        return new File(this.directory, deck.getBestFileName() + FILE_EXTENSION);
    }

    @Override
    protected Deck read(File file) {
        Map<String, List<String>> sections = FileSection.parseSections(FileUtil.readFile(file));
        Deck result = DeckSerializer.fromSections(sections);
        if (this.moveWronglyNamedDecks) {
            DeckStorage.adjustFileLocation(file, result);
        }
        if (result != null) {
            result.setDirectory(file.getParent().substring(this.rootDir.length()));
        }
        return result;
    }

    private static void adjustFileLocation(File file, Deck result) {
        if (result == null) {
            file.delete();
        } else {
            String destFilename = result.getBestFileName() + FILE_EXTENSION;
            if (!file.getName().equals(destFilename)) {
                file.renameTo(new File(file.getParentFile().getParentFile(), destFilename));
            }
        }
    }

    @Override
    protected FilenameFilter getFileFilter() {
        return DCK_FILE_FILTER;
    }
}

