/*
 * Decompiled with CFR 0.152.
 */
package forge.deck.io;

import forge.deck.CardPool;
import forge.deck.Deck;
import forge.deck.DeckSection;
import forge.deck.io.DeckFileHeader;
import forge.util.FileSection;
import forge.util.FileSectionManual;
import forge.util.FileUtil;
import forge.util.TextUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class DeckSerializer {
    public static void writeDeck(Deck d, File f) {
        FileUtil.writeFile(f, DeckSerializer.serializeDeck(d));
    }

    static DeckFileHeader readDeckMetadata(Map<String, List<String>> map) {
        if (map == null) {
            return null;
        }
        List<String> metadata = map.get("metadata");
        if (metadata != null) {
            return new DeckFileHeader(FileSection.parse(metadata, FileSection.EQUALS_KV_SEPARATOR));
        }
        List<String> general = map.get("general");
        if (general != null) {
            FileSectionManual fs = new FileSectionManual();
            fs.put("Name", StringUtils.join((Iterable)map.get(""), " "));
            fs.put("Deck Type", StringUtils.join(general, " "));
            return new DeckFileHeader(fs);
        }
        return null;
    }

    private static List<String> serializeDeck(Deck d) {
        ArrayList<String> out = new ArrayList<String>();
        out.add(TextUtil.enclosedBracket("metadata"));
        out.add(TextUtil.concatNoSpace("Name", "=", d.getName().replaceAll("\n", "")));
        if (d.getComment() != null) {
            out.add(TextUtil.concatNoSpace("Comment", "=", d.getComment().replaceAll("\n", "")));
        }
        if (!d.getTags().isEmpty()) {
            out.add(TextUtil.concatNoSpace("Tags", "=", StringUtils.join(d.getTags(), ",")));
        }
        if (!d.getAiHints().isEmpty()) {
            out.add(TextUtil.concatNoSpace("AiHints", "=", StringUtils.join(d.getAiHints(), " | ")));
        }
        if (!d.getDraftNotes().isEmpty()) {
            String sb = DeckSerializer.serializeDraftNotes(d.getDraftNotes());
            out.add(TextUtil.concatNoSpace("DraftNotes", "=", sb));
        }
        for (Map.Entry<DeckSection, CardPool> s2 : d) {
            out.add(TextUtil.enclosedBracket(s2.getKey().toString()));
            out.add(s2.getValue().toCardList(System.lineSeparator()));
        }
        return out;
    }

    public static String serializeDraftNotes(Map<String, String> draftNotes) {
        StringBuilder sb = new StringBuilder();
        for (String key : draftNotes.keySet()) {
            if (sb.length() > 0) {
                sb.append(" | ");
            }
            sb.append(key).append(":").append(draftNotes.get(key));
        }
        return sb.toString();
    }

    public static Deck fromFile(File deckFile) {
        return DeckSerializer.fromSections(FileSection.parseSections(FileUtil.readFile(deckFile)));
    }

    public static Deck fromSections(Map<String, List<String>> sections) {
        if (sections == null || sections.isEmpty()) {
            return null;
        }
        DeckFileHeader dh = DeckSerializer.readDeckMetadata(sections);
        if (dh == null) {
            return null;
        }
        Deck d = new Deck(dh.getName());
        d.setComment(dh.getComment());
        d.setAiHints(dh.getAiHints());
        d.getTags().addAll(dh.getTags());
        d.setDraftNotes(dh.getDraftNotes());
        d.setDeferredSections(sections);
        return d;
    }
}

