/*
 * Decompiled with CFR 0.152.
 */
package forge.deck.io;

import forge.deck.DeckFormat;
import forge.util.FileSection;
import java.util.HashMap;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;

public class DeckFileHeader {
    public static final String NAME = "Name";
    public static final String DECK_TYPE = "Deck Type";
    public static final String TAGS = "Tags";
    public static final String TAGS_SEPARATOR = ",";
    public static final String DRAFT_NOTES = "DraftNotes";
    public static final String COMMENT = "Comment";
    private static final String PLAYER = "Player";
    private static final String CSTM_POOL = "Custom Pool";
    private static final String PLAYER_TYPE = "PlayerType";
    public static final String AI_HINTS = "AiHints";
    private final DeckFormat deckType;
    private final boolean customPool;
    private final String name;
    private final String comment;
    private final Set<String> tags;
    private final HashMap<String, String> draftNotes;
    private final boolean intendedForAi;
    private final String aiHints;

    public boolean isIntendedForAi() {
        return this.intendedForAi;
    }

    public String getAiHints() {
        return this.aiHints;
    }

    public DeckFileHeader(FileSection kvPairs) {
        this.name = kvPairs.get(NAME);
        this.comment = kvPairs.get(COMMENT);
        this.deckType = DeckFormat.smartValueOf(kvPairs.get(DECK_TYPE), DeckFormat.Constructed);
        this.customPool = kvPairs.getBoolean(CSTM_POOL);
        this.intendedForAi = "computer".equalsIgnoreCase(kvPairs.get(PLAYER)) || "ai".equalsIgnoreCase(kvPairs.get(PLAYER_TYPE));
        this.aiHints = kvPairs.get(AI_HINTS);
        this.tags = new TreeSet<String>();
        String rawTags = kvPairs.get(TAGS);
        if (StringUtils.isNotBlank(rawTags)) {
            for (String t2 : rawTags.split(TAGS_SEPARATOR)) {
                if (!StringUtils.isNotBlank(t2)) continue;
                this.tags.add(t2.trim());
            }
        }
        this.draftNotes = new HashMap();
        this.extractDraftNotes(kvPairs.get(DRAFT_NOTES));
    }

    private void extractDraftNotes(String rawNotes) {
        if (StringUtils.isBlank(rawNotes)) {
            return;
        }
        for (String t2 : rawNotes.split("\\|")) {
            String[] notes;
            if (StringUtils.isBlank(t2) || (notes = t2.trim().split(":", 2))[0].trim().isEmpty() || notes[1].trim().isEmpty()) continue;
            this.draftNotes.put(notes[0].trim(), notes[1].trim());
        }
    }

    public final boolean isCustomPool() {
        return this.customPool;
    }

    public final String getName() {
        return this.name;
    }

    public final String getComment() {
        return this.comment;
    }

    public final DeckFormat getDeckType() {
        return this.deckType;
    }

    public final Set<String> getTags() {
        return this.tags;
    }

    public final HashMap<String, String> getDraftNotes() {
        return this.draftNotes;
    }
}

