/*
 * Decompiled with CFR 0.152.
 */
package forge.deck.io;

import forge.game.GameFormat;
import forge.item.PaperCard;
import forge.localinstance.properties.ForgeConstants;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CardThemedMatrixIO {
    public static final String SUFFIX_DATA = ".dat";

    public static void saveMatrix(String format, HashMap<String, List<Map.Entry<PaperCard, Integer>>> map) {
        File file = CardThemedMatrixIO.getMatrixFile(format);
        try (FileOutputStream f = new FileOutputStream(file);
             ObjectOutputStream s2 = new ObjectOutputStream(f);){
            s2.writeObject(map);
        }
        catch (IOException e) {
            System.out.println("Error writing matrix data: " + e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static HashMap<String, List<Map.Entry<PaperCard, Integer>>> loadMatrix(String format) {
        try (FileInputStream fin = new FileInputStream(CardThemedMatrixIO.getMatrixFile(format));){
            HashMap hashMap;
            try (ObjectInputStream s2 = new ObjectInputStream(fin);){
                HashMap matrix;
                hashMap = matrix = (HashMap)s2.readObject();
            }
            return hashMap;
        }
        catch (Exception e) {
            System.out.println("Error reading matrix data: " + e);
            return null;
        }
    }

    public static File getMatrixFile(String name) {
        return new File(ForgeConstants.DECK_GEN_DIR, name + SUFFIX_DATA);
    }

    public static File getMatrixFolder(String name) {
        return new File(ForgeConstants.DECK_GEN_DIR, name);
    }

    public static File getMatrixFile(GameFormat gf) {
        return CardThemedMatrixIO.getMatrixFile(gf.getName());
    }
}

