/*
 * Decompiled with CFR 0.152.
 */
package forge.deck.io;

import forge.deck.io.Archetype;
import forge.game.GameFormat;
import forge.localinstance.properties.ForgeConstants;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;

public class CardThemedLDAIO {
    public static final String SUFFIX_DATA = ".lda.dat";
    public static final String RAW_SUFFIX_DATA = ".raw.dat";

    public static void saveRawLDA(String format, List<Archetype> lda) {
        File file = CardThemedLDAIO.getRAWLDAFile(format);
        try (FileOutputStream f = new FileOutputStream(file);
             ObjectOutputStream s2 = new ObjectOutputStream(f);){
            s2.writeObject(lda);
        }
        catch (IOException e) {
            System.out.println("Error writing matrix data: " + e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static List<Archetype> loadRawLDA(String format) {
        try (FileInputStream fin = new FileInputStream(CardThemedLDAIO.getRAWLDAFile(format));){
            List list;
            try (ObjectInputStream s2 = new ObjectInputStream(fin);){
                List matrix;
                list = matrix = (List)s2.readObject();
            }
            return list;
        }
        catch (Exception e) {
            System.out.println("Error reading LDA data: " + e);
            return null;
        }
    }

    public static void saveLDA(String format, Map<String, List<List<Pair<String, Double>>>> map) {
        File file = CardThemedLDAIO.getLDAFile(format);
        try (FileOutputStream f = new FileOutputStream(file);
             ObjectOutputStream s2 = new ObjectOutputStream(f);){
            s2.writeObject(map);
        }
        catch (IOException e) {
            System.out.println("Error writing matrix data: " + e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static Map<String, List<List<Pair<String, Double>>>> loadLDA(String format) {
        try (FileInputStream fin = new FileInputStream(CardThemedLDAIO.getLDAFile(format));){
            Map map;
            try (ObjectInputStream s2 = new ObjectInputStream(fin);){
                Map matrix;
                map = matrix = (Map)s2.readObject();
            }
            return map;
        }
        catch (Exception e) {
            System.out.println("Error reading LDA data: " + e);
            return null;
        }
    }

    public static File getLDAFile(String name) {
        return new File(ForgeConstants.DECK_GEN_DIR, name + SUFFIX_DATA);
    }

    public static File getRAWLDAFile(String name) {
        return new File(ForgeConstants.DECK_GEN_DIR, name + RAW_SUFFIX_DATA);
    }

    public static File getMatrixFolder(String name) {
        return new File(ForgeConstants.DECK_GEN_DIR, name);
    }

    public static File getLDAFile(GameFormat gf) {
        return CardThemedLDAIO.getLDAFile(gf.getName());
    }
}

