/*
 * Decompiled with CFR 0.152.
 */
package forge.deck.generation;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import forge.StaticData;
import forge.card.CardRules;
import forge.card.CardRulesPredicates;
import forge.card.CardType;
import forge.card.ColorSet;
import forge.card.MagicColor;
import forge.card.mana.ManaCost;
import forge.deck.CardPool;
import forge.deck.DeckFormat;
import forge.deck.generation.DeckGenPool;
import forge.deck.generation.IDeckGenPool;
import forge.item.IPaperCard;
import forge.item.PaperCard;
import forge.util.Aggregates;
import forge.util.DebugTrace;
import forge.util.ItemPool;
import forge.util.MyRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.tuple.ImmutablePair;

public abstract class DeckGeneratorBase {
    protected final DebugTrace trace = new DebugTrace();
    protected final Map<String, Integer> cardCounts = new HashMap<String, Integer>();
    protected int maxDuplicates = 4;
    protected boolean useArtifacts = true;
    protected String basicLandEdition = null;
    protected List<String> inverseDLands = new ArrayList<String>();
    protected List<String> dLands = new ArrayList<String>();
    protected ColorSet colors;
    protected final CardPool tDeck = new CardPool();
    protected final IDeckGenPool pool;
    protected IDeckGenPool landPool;
    protected final DeckFormat format;
    protected final IDeckGenPool fullCardDB;
    public static final Predicate<CardRules> AI_CAN_PLAY = Predicates.and(CardRulesPredicates.IS_KEPT_IN_AI_DECKS, CardRulesPredicates.IS_KEPT_IN_RANDOM_DECKS);
    public static final Predicate<CardRules> COLORLESS_CARDS = c -> {
        ManaCost mc = c.getManaCost();
        return c.getColorIdentity().isColorless() && !mc.isNoCost();
    };

    protected abstract float getLandPercentage();

    protected abstract float getCreaturePercentage();

    protected abstract float getSpellPercentage();

    public DeckGeneratorBase(IDeckGenPool pool0, DeckFormat format0, Predicate<PaperCard> formatFilter0) {
        this.pool = new DeckGenPool(format0.getCardPool(pool0).getAllCards(formatFilter0));
        this.format = format0;
        this.fullCardDB = pool0;
    }

    public DeckGeneratorBase(IDeckGenPool pool0, DeckFormat format0) {
        this.pool = new DeckGenPool(format0.getCardPool(pool0).getAllCards());
        this.format = format0;
        this.fullCardDB = pool0;
    }

    public void setSingleton(boolean singleton) {
        this.maxDuplicates = singleton ? 1 : 4;
    }

    public void setUseArtifacts(boolean value) {
        this.useArtifacts = value;
    }

    protected void addCreaturesAndSpells(int size, List<ImmutablePair<FilterCMC, Integer>> cmcLevels, boolean forAi) {
        this.trace.append("Building deck of ").append(size).append("cards\n");
        Iterable<PaperCard> cards = this.selectCardsOfMatchingColorForPlayer(forAi);
        Iterable<PaperCard> creatures = Iterables.filter(cards, Predicates.compose(CardRulesPredicates.Presets.IS_CREATURE, PaperCard::getRules));
        int creatCnt = (int)Math.ceil(this.getCreaturePercentage() * (float)size);
        this.trace.append("Creatures to add:").append(creatCnt).append("\n");
        this.addCmcAdjusted(creatures, creatCnt, cmcLevels);
        Predicate preSpells = Predicates.compose(CardRulesPredicates.Presets.IS_NON_CREATURE_SPELL, PaperCard::getRules);
        Iterable<PaperCard> spells = Iterables.filter(cards, preSpells);
        int spellCnt = (int)Math.ceil(this.getSpellPercentage() * (float)size);
        this.trace.append("Spells to add:").append(spellCnt).append("\n");
        this.addCmcAdjusted(spells, spellCnt, cmcLevels);
        this.trace.append(String.format("Current deck size: %d... should be %f%n", this.tDeck.countAll(), Float.valueOf((float)size * (this.getCreaturePercentage() + this.getSpellPercentage()))));
    }

    public CardPool getDeck(int size, boolean forAi) {
        return null;
    }

    protected boolean setBasicLandPool(String edition) {
        Predicate<Object> isSetBasicLand = edition != null ? Predicates.and(IPaperCard.Predicates.printedInSet(edition), Predicates.compose(CardRulesPredicates.Presets.IS_BASIC_LAND, PaperCard::getRules)) : Predicates.compose(CardRulesPredicates.Presets.IS_BASIC_LAND, PaperCard::getRules);
        this.landPool = new DeckGenPool(StaticData.instance().getCommonCards().getAllCards(isSetBasicLand));
        return this.landPool.contains("Plains");
    }

    protected int addSome(int cnt, List<PaperCard> source) {
        int srcLen = source.size();
        if (srcLen == 0) {
            return 0;
        }
        int res = 0;
        while (res < cnt) {
            PaperCard cp = source.get(MyRandom.getRandom().nextInt(srcLen));
            int newCount = this.cardCounts.get(cp.getName()) + 1;
            if (newCount <= this.maxDuplicates) {
                this.tDeck.add(this.pool.getCard(cp.getName(), cp.getEdition()));
                if (this.basicLandEdition == null && this.setBasicLandPool(cp.getEdition())) {
                    this.basicLandEdition = cp.getEdition();
                }
                this.cardCounts.put(cp.getName(), newCount);
                this.trace.append(String.format("(%d) %s [%s]%n", cp.getRules().getManaCost().getCMC(), cp.getName(), cp.getRules().getManaCost()));
                ++res;
            }
            if (newCount < this.maxDuplicates) continue;
            source.remove(cp);
            if (--srcLen != 0) continue;
            break;
        }
        return res;
    }

    protected int addSomeStr(int cnt, List<String> source) {
        int srcLen = source.size();
        if (srcLen == 0) {
            return 0;
        }
        int res = 0;
        while (res < cnt) {
            String s2 = source.get(MyRandom.getRandom().nextInt(srcLen));
            int newCount = this.cardCounts.get(s2) + 1;
            if (newCount <= this.maxDuplicates) {
                this.tDeck.add(this.pool.getCard(s2));
                this.cardCounts.put(s2, newCount);
                this.trace.append(s2 + "\n");
                ++res;
            }
            if (newCount < this.maxDuplicates) continue;
            source.remove(s2);
            if (--srcLen != 0) continue;
            break;
        }
        return res;
    }

    protected void addBasicLand(int cnt) {
        this.addBasicLand(cnt, null);
    }

    protected void addBasicLand(int cnt, String edition) {
        this.trace.append(cnt).append(" basic lands remain").append("\n");
        Map<String, Integer> clrCnts = DeckGeneratorBase.countLands(this.tDeck);
        if (cnt > 0 && clrCnts.isEmpty()) {
            clrCnts.put((String)MagicColor.Constant.BASIC_LANDS.get(0), cnt);
        }
        float totalColor = 0.0f;
        for (Map.Entry<String, Integer> c : clrCnts.entrySet()) {
            totalColor += (float)c.getValue().intValue();
            this.trace.append(c.getKey()).append(":").append(c.getValue()).append("\n");
        }
        this.trace.append("totalColor:").append(Float.valueOf(totalColor)).append("\n");
        int landsLeft = cnt;
        for (Map.Entry<String, Integer> c : clrCnts.entrySet()) {
            String basicLandName = c.getKey();
            int nLand = Math.min(landsLeft, Math.round((float)(cnt * c.getValue()) / totalColor));
            this.trace.append("nLand-").append(basicLandName).append(":").append(nLand).append("\n");
            this.cardCounts.put(basicLandName, nLand);
            if (!this.landPool.contains("Plains")) {
                this.setBasicLandPool("BFZ");
                this.basicLandEdition = "BFZ";
            }
            for (int i = 0; i < nLand; ++i) {
                this.tDeck.add(this.landPool.getCard(basicLandName, edition != null ? edition : this.basicLandEdition), 1);
            }
            landsLeft -= nLand;
        }
    }

    protected void adjustDeckSize(int targetSize) {
        int actualSize = this.tDeck.countAll();
        if (actualSize < targetSize) {
            this.addSome(targetSize - actualSize, this.tDeck.toFlatList());
        } else if (actualSize > targetSize) {
            Predicate exceptBasicLand = Predicates.not(Predicates.compose(CardRulesPredicates.Presets.IS_BASIC_LAND, PaperCard::getRules));
            for (int i = 0; i < 3 && actualSize > targetSize; ++i) {
                Iterable matchingCards = Iterables.filter(this.tDeck.toFlatList(), exceptBasicLand);
                List<PaperCard> toRemove = Aggregates.random(matchingCards, actualSize - targetSize);
                this.tDeck.removeAllFlat(toRemove);
                for (PaperCard c : toRemove) {
                    this.trace.append("Removed:").append(c.getName()).append("\n");
                }
                actualSize = this.tDeck.countAll();
            }
        }
    }

    protected void addCmcAdjusted(Iterable<PaperCard> source, int cnt, List<ImmutablePair<FilterCMC, Integer>> cmcLevels) {
        int totalWeight = 0;
        for (ImmutablePair<FilterCMC, Integer> pair : cmcLevels) {
            totalWeight += pair.getRight().intValue();
        }
        float variability = 0.6f;
        float desiredWeight = (float)cnt / ((float)this.maxDuplicates * variability);
        float desiredOverTotal = desiredWeight / (float)totalWeight;
        float requestedOverTotal = (float)cnt / (float)totalWeight;
        for (ImmutablePair<FilterCMC, Integer> pair : cmcLevels) {
            Iterable<PaperCard> matchingCards = Iterables.filter(source, Predicates.compose(pair.getLeft(), PaperCard::getRules));
            int cmcCountForPool = (int)Math.ceil((float)pair.getRight().intValue() * desiredOverTotal);
            int addOfThisCmc = Math.round((float)pair.getRight().intValue() * requestedOverTotal);
            this.trace.append(String.format("Adding %d cards for cmc range from a pool with %d cards:%n", addOfThisCmc, cmcCountForPool));
            List<PaperCard> curved = Aggregates.random(matchingCards, cmcCountForPool);
            ArrayList<PaperCard> curvedRandomized = Lists.newArrayList();
            for (PaperCard c : curved) {
                this.cardCounts.put(c.getName(), 0);
                curvedRandomized.add(this.pool.getCard(c.getName()));
            }
            this.addSome(addOfThisCmc, curvedRandomized);
        }
    }

    protected Iterable<PaperCard> selectCardsOfMatchingColorForPlayer(boolean forAi) {
        Predicate<CardRules> canPlay = forAi ? AI_CAN_PLAY : CardRulesPredicates.IS_KEPT_IN_RANDOM_DECKS;
        Predicate<CardRules> hasColor = new MatchColorIdentity(this.colors);
        Predicate canUseInFormat = c -> !c.getAiHints().getRemNonCommanderDecks() || this.format.hasCommander();
        if (this.useArtifacts) {
            hasColor = Predicates.or(hasColor, COLORLESS_CARDS);
        }
        return Iterables.filter(this.pool.getAllCards(), Predicates.compose(Predicates.and(canPlay, hasColor, canUseInFormat), PaperCard::getRules));
    }

    protected static Map<String, Integer> countLands(ItemPool<PaperCard> outList) {
        TreeMap<String, Integer> res = new TreeMap<String, Integer>();
        for (Map.Entry<PaperCard, Integer> entry : outList) {
            byte profile = entry.getKey().getRules().getManaCost().getColorProfile();
            if ((profile & 1) != 0) {
                DeckGeneratorBase.increment(res, (String)MagicColor.Constant.BASIC_LANDS.get(0), entry.getValue());
                continue;
            }
            if ((profile & 2) != 0) {
                DeckGeneratorBase.increment(res, (String)MagicColor.Constant.BASIC_LANDS.get(1), entry.getValue());
                continue;
            }
            if ((profile & 4) != 0) {
                DeckGeneratorBase.increment(res, (String)MagicColor.Constant.BASIC_LANDS.get(2), entry.getValue());
                continue;
            }
            if ((profile & 8) != 0) {
                DeckGeneratorBase.increment(res, (String)MagicColor.Constant.BASIC_LANDS.get(3), entry.getValue());
                continue;
            }
            if ((profile & 0x10) == 0) continue;
            DeckGeneratorBase.increment(res, (String)MagicColor.Constant.BASIC_LANDS.get(4), entry.getValue());
        }
        return res;
    }

    protected static void increment(Map<String, Integer> map, String key, int delta) {
        Integer boxed = map.get(key);
        map.put(key, boxed == null ? delta : boxed + delta);
    }

    protected List<String> getDualLandList(boolean forAi) {
        return this.getDualLandList(forAi ? AI_CAN_PLAY : CardRulesPredicates.IS_KEPT_IN_RANDOM_DECKS);
    }

    protected List<String> getDualLandList(Predicate<CardRules> canPlay) {
        if (this.colors.countColors() > 3) {
            this.addCardNameToList("Rupture Spire", this.dLands);
            this.addCardNameToList("Undiscovered Paradise", this.dLands);
        }
        if (this.colors.countColors() > 2) {
            this.addCardNameToList("Evolving Wilds", this.dLands);
            this.addCardNameToList("Terramorphic Expanse", this.dLands);
        }
        Predicate<CardRules> dualLandFilter = CardRulesPredicates.coreType(true, CardType.CoreType.Land);
        Predicate<CardRules> exceptBasicLand = Predicates.not(CardRulesPredicates.Presets.IS_BASIC_LAND);
        Iterable<PaperCard> landCards = this.pool.getAllCards(Predicates.compose(Predicates.and(dualLandFilter, exceptBasicLand, canPlay), PaperCard::getRules));
        List<String> dualLandPatterns = Arrays.asList("Add \\{([WUBRG])\\} or \\{([WUBRG])\\}", "Add \\{([WUBRG])\\}, \\{([WUBRG])\\}, or \\{([WUBRG])\\}", "Add \\{([WUBRG])\\}\\{([WUBRG])\\}", "Add \\{[WUBRG]\\}\\{[WUBRG]\\}, \\{([WUBRG])\\}\\{([WUBRG])\\}, or \\{[WUBRG]\\}\\{[WUBRG]\\}");
        for (String pattern : dualLandPatterns) {
            this.regexLandSearch(pattern, landCards);
        }
        this.regexFetchLandSearch(landCards);
        return this.dLands;
    }

    public List<String> regexLandSearch(String pattern, Iterable<PaperCard> landCards) {
        Pattern p = Pattern.compile(pattern);
        for (PaperCard card : landCards) {
            Matcher matcher = p.matcher(card.getRules().getOracleText());
            while (matcher.find()) {
                ArrayList<String> manaColorNames = new ArrayList<String>();
                for (int i = 1; i <= matcher.groupCount(); ++i) {
                    manaColorNames.add(matcher.group(i));
                }
                ColorSet manaColorSet = ColorSet.fromNames(manaColorNames);
                if (this.colors.hasAllColors(manaColorSet.getColor())) {
                    this.addCardNameToList(card.getName(), this.dLands);
                    continue;
                }
                this.addCardNameToList(card.getName(), this.inverseDLands);
            }
        }
        return this.dLands;
    }

    public List<String> regexFetchLandSearch(Iterable<PaperCard> landCards) {
        String fetchPattern = "Search your library for an* ([^\\s]*) or ([^\\s]*) card";
        HashMap<String, String> colorLookup = new HashMap<String, String>();
        colorLookup.put("Plains", "W");
        colorLookup.put("Forest", "G");
        colorLookup.put("Mountain", "R");
        colorLookup.put("Island", "U");
        colorLookup.put("Swamp", "B");
        Pattern p = Pattern.compile("Search your library for an* ([^\\s]*) or ([^\\s]*) card");
        for (PaperCard card : landCards) {
            Matcher matcher = p.matcher(card.getRules().getOracleText());
            while (matcher.find()) {
                ArrayList<String> manaColorNames = new ArrayList<String>();
                for (int i = 1; i <= matcher.groupCount(); ++i) {
                    manaColorNames.add((String)colorLookup.get(matcher.group(i)));
                }
                ColorSet manaColorSet = ColorSet.fromNames(manaColorNames);
                if (this.colors.hasAllColors(manaColorSet.getColor())) {
                    this.addCardNameToList(card.getName(), this.dLands);
                    continue;
                }
                this.addCardNameToList(card.getName(), this.inverseDLands);
            }
        }
        return this.dLands;
    }

    private void addCardNameToList(String cardName, List<String> cardNameList) {
        if (this.pool.contains(cardName)) {
            cardNameList.add(cardName);
        }
    }

    public static class FilterCMC
    implements Predicate<CardRules> {
        private final int min;
        private final int max;

        public FilterCMC(int from, int to) {
            this.min = from;
            this.max = to;
        }

        @Override
        public boolean apply(CardRules c) {
            ManaCost mc = c.getManaCost();
            int cmc = mc.getCMC();
            return cmc >= this.min && cmc <= this.max && !mc.isNoCost();
        }
    }

    public static class MatchColorIdentity
    implements Predicate<CardRules> {
        private final ColorSet allowedColor;

        public MatchColorIdentity(ColorSet color) {
            this.allowedColor = color;
        }

        @Override
        public boolean apply(CardRules subject) {
            ManaCost mc = subject.getManaCost();
            return !mc.isPureGeneric() && this.allowedColor.containsAllColorsFrom(subject.getColorIdentity().getColor());
        }
    }
}

