/*
 * Decompiled with CFR 0.152.
 */
package forge.deck.generation;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import forge.card.ColorSet;
import forge.deck.CardPool;
import forge.deck.DeckFormat;
import forge.deck.generation.DeckGeneratorBase;
import forge.deck.generation.IDeckGenPool;
import forge.item.PaperCard;
import java.util.List;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class DeckGenerator5Color
extends DeckGeneratorBase {
    final List<ImmutablePair<DeckGeneratorBase.FilterCMC, Integer>> cmcLevels = Lists.newArrayList(ImmutablePair.of(new DeckGeneratorBase.FilterCMC(0, 2), 3), ImmutablePair.of(new DeckGeneratorBase.FilterCMC(3, 5), 2), ImmutablePair.of(new DeckGeneratorBase.FilterCMC(6, 20), 1));

    @Override
    protected final float getLandPercentage() {
        return 0.44f;
    }

    @Override
    protected final float getCreaturePercentage() {
        return 0.33f;
    }

    @Override
    protected final float getSpellPercentage() {
        return 0.23f;
    }

    public DeckGenerator5Color(IDeckGenPool pool0, DeckFormat format0, Predicate<PaperCard> formatFilter0) {
        super(pool0, format0, formatFilter0);
        format0.adjustCMCLevels(this.cmcLevels);
        this.colors = ColorSet.fromMask(0).inverse();
    }

    public DeckGenerator5Color(IDeckGenPool pool0, DeckFormat format0) {
        super(pool0, format0);
        format0.adjustCMCLevels(this.cmcLevels);
        this.colors = ColorSet.fromMask(0).inverse();
    }

    @Override
    public final CardPool getDeck(int size, boolean forAi) {
        this.addCreaturesAndSpells(size, this.cmcLevels, forAi);
        int numLands = Math.round((float)size * this.getLandPercentage());
        this.adjustDeckSize(size - numLands);
        this.trace.append("numLands:").append(numLands).append("\n");
        List<String> duals = this.getDualLandList(forAi);
        for (String s2 : duals) {
            this.cardCounts.put(s2, 0);
        }
        int dblsAdded = this.addSomeStr(numLands / 4, duals);
        this.addBasicLand(numLands -= dblsAdded);
        this.adjustDeckSize(size);
        return this.tDeck;
    }
}

