/*
 * Decompiled with CFR 0.152.
 */
package forge.deck.generation;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import forge.deck.generation.IDeckGenPool;
import forge.item.IPaperCard;
import forge.item.PaperCard;
import java.util.HashMap;
import java.util.Map;

public class DeckGenPool
implements IDeckGenPool {
    private final Map<String, PaperCard> cards = new HashMap<String, PaperCard>();

    public DeckGenPool() {
    }

    public DeckGenPool(Iterable<PaperCard> cc) {
        this.addAll(cc);
    }

    public void add(PaperCard c) {
        this.cards.put(c.getName(), c);
    }

    public void addAll(Iterable<PaperCard> cc) {
        for (PaperCard c : cc) {
            this.add(c);
        }
    }

    public int size() {
        return this.cards.size();
    }

    @Override
    public PaperCard getCard(String name) {
        return this.cards.get(name);
    }

    @Override
    public PaperCard getCard(String name, String edition) {
        Predicate<PaperCard> filter = Predicates.and(IPaperCard.Predicates.printedInSet(edition), IPaperCard.Predicates.name(name));
        Iterable<PaperCard> editionCards = Iterables.filter(this.cards.values(), filter);
        if (editionCards.iterator().hasNext()) {
            return editionCards.iterator().next();
        }
        return this.getCard(name);
    }

    @Override
    public PaperCard getCard(String name, String edition, int artIndex) {
        return this.getCard(name, edition);
    }

    public boolean contains(PaperCard card) {
        return this.contains(card.getName());
    }

    @Override
    public boolean contains(String name) {
        return this.cards.containsKey(name);
    }

    @Override
    public Iterable<PaperCard> getAllCards() {
        return this.cards.values();
    }

    @Override
    public Iterable<PaperCard> getAllCards(Predicate<PaperCard> filter) {
        return Iterables.filter(this.getAllCards(), filter);
    }
}

