/*
 * Decompiled with CFR 0.152.
 */
package forge.deck;

import forge.deck.Deck;
import forge.deck.io.DeckSerializer;
import forge.deck.io.DeckStorage;
import forge.game.GameType;
import forge.gui.GuiBase;
import forge.gui.download.GuiDownloadZipService;
import forge.gui.util.SGuiChoose;
import forge.localinstance.properties.ForgeConstants;
import forge.util.FileUtil;
import forge.util.WaitCallback;
import forge.util.storage.StorageBase;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class NetDeckArchiveLegacy
extends StorageBase<Deck> {
    public static final String PREFIX = "NET_ARCHIVE_LEGACY_DECK";
    private static Map<String, NetDeckArchiveLegacy> constructed;
    private static Map<String, NetDeckArchiveLegacy> commander;
    private static Map<String, NetDeckArchiveLegacy> brawl;
    private final String url;

    private static Map<String, NetDeckArchiveLegacy> loadCategories(String filename) {
        TreeMap<String, NetDeckArchiveLegacy> categories = new TreeMap<String, NetDeckArchiveLegacy>();
        if (FileUtil.doesFileExist(filename)) {
            List<String> lines = FileUtil.readFile(filename);
            for (String line : lines) {
                int idx = line.indexOf(124);
                if (idx == -1) continue;
                String name = line.substring(0, idx).trim();
                String url = line.substring(idx + 1).trim();
                categories.put(name, new NetDeckArchiveLegacy(name, url));
            }
        }
        return categories;
    }

    public static NetDeckArchiveLegacy selectAndLoad(GameType gameType) {
        return NetDeckArchiveLegacy.selectAndLoad(gameType, null);
    }

    public static NetDeckArchiveLegacy selectAndLoad(GameType gameType, String name) {
        WaitCallback<Boolean> callback;
        Map<String, NetDeckArchiveLegacy> categories;
        switch (gameType) {
            case Constructed: 
            case Gauntlet: {
                if (constructed == null) {
                    constructed = NetDeckArchiveLegacy.loadCategories(ForgeConstants.NET_ARCHIVE_LEGACY_DECKS_LIST_FILE);
                }
                categories = constructed;
                break;
            }
            default: {
                return null;
            }
        }
        if (name != null) {
            File downloadDir;
            NetDeckArchiveLegacy category = categories.get(name);
            if (category != null && category.map.isEmpty() && (downloadDir = new File(category.getFullPath())).exists()) {
                for (File file : NetDeckArchiveLegacy.getAllFilesList(downloadDir, DeckStorage.DCK_FILE_FILTER)) {
                    Deck deck = DeckSerializer.fromFile(file);
                    if (deck == null) continue;
                    category.map.put(deck.getName(), deck);
                }
            }
            return category;
        }
        ArrayList<NetDeckArchiveLegacy> category = new ArrayList<NetDeckArchiveLegacy>(categories.values());
        Collections.reverse(category);
        final NetDeckArchiveLegacy c = SGuiChoose.oneOrNone("Select a Net Deck Archive Legacy category", category);
        if (c == null) {
            return null;
        }
        if (c.map.isEmpty() && !((Boolean)(callback = new WaitCallback<Boolean>(){

            @Override
            public void run() {
                String downloadLoc = c.getFullPath();
                GuiBase.getInterface().download(new GuiDownloadZipService(c.getName(), "decks", c.getUrl(), downloadLoc, downloadLoc, null){

                    @Override
                    protected void copyInputStream(InputStream in, String outPath) throws IOException {
                        super.copyInputStream(in, outPath);
                        Deck deck = DeckSerializer.fromFile(new File(outPath));
                        if (deck != null) {
                            c.map.put(deck.getName(), deck);
                        }
                    }
                }, this);
            }
        }).invokeAndWait()).booleanValue()) {
            return null;
        }
        return c;
    }

    private NetDeckArchiveLegacy(String name0, String url0) {
        super(name0, ForgeConstants.DECK_NET_ARCHIVE_DIR + name0, new HashMap());
        this.url = url0;
    }

    public String getUrl() {
        return this.url;
    }

    public String getDeckType() {
        return "Net Archive Legacy Decks - " + this.name;
    }

    public String toString() {
        return this.name;
    }
}

