/*
 * Decompiled with CFR 0.152.
 */
package forge.deck;

import forge.Forge;
import forge.deck.CardPool;
import forge.item.PaperCard;
import forge.itemmanager.CardManager;
import forge.itemmanager.ItemManagerConfig;
import forge.model.FModel;
import forge.screens.FScreen;
import forge.toolbox.FButton;
import forge.toolbox.FEvent;
import forge.util.Aggregates;
import forge.util.Utils;

public class FVanguardChooser
extends FScreen {
    public static final float PADDING = Utils.scale(5.0f);
    private static final CardPool allHumanAvatars = new CardPool();
    private static final CardPool allAiAvatars = new CardPool();
    private static final CardPool nonRandomHumanAvatars = new CardPool();
    private static final CardPool nonRandomAiAvatars = new CardPool();
    private final CardManager lstVanguards = this.add(new CardManager(true));
    private final FButton btnRandom = this.add(new FButton(Forge.getLocalizer().getMessage("lblRandomVanguard", new Object[0])));
    private boolean isAi;

    public FVanguardChooser(boolean isAi0, FEvent.FEventHandler selectionChangedHandler) {
        super("");
        this.isAi = isAi0;
        this.lstVanguards.setItemActivateHandler(e -> Forge.back());
        this.btnRandom.setCommand(e -> {
            this.selectRandom();
            Forge.back();
        });
        this.lstVanguards.setup(ItemManagerConfig.VANGUARDS);
        this.lstVanguards.setPool(this.isAi ? allAiAvatars : allHumanAvatars, true);
        this.lstVanguards.setSelectionChangedHandler(selectionChangedHandler);
        this.selectRandom();
    }

    private void selectRandom() {
        if (this.lstVanguards.getItemCount() == 0) {
            return;
        }
        if (this.isAi) {
            this.lstVanguards.setSelectedItem(Aggregates.random(nonRandomAiAvatars).getKey());
        } else {
            this.lstVanguards.setSelectedItem(Aggregates.random(nonRandomHumanAvatars).getKey());
        }
    }

    public void setIsAi(boolean isAi0) {
        if (this.isAi == isAi0) {
            return;
        }
        this.isAi = isAi0;
        PaperCard lastSelection = (PaperCard)this.lstVanguards.getSelectedItem();
        this.lstVanguards.setPool(this.isAi ? allAiAvatars : allHumanAvatars, true);
        if (lastSelection != null) {
            this.lstVanguards.setSelectedItem(lastSelection);
        }
        if (this.lstVanguards.getSelectedIndex() == -1) {
            this.selectRandom();
        }
    }

    public CardManager getLstVanguards() {
        return this.lstVanguards;
    }

    @Override
    protected void doLayout(float startY, float width, float height) {
        float x = PADDING;
        float y = startY;
        float buttonHeight = Utils.AVG_FINGER_HEIGHT;
        this.lstVanguards.setBounds(x, y, width -= 2.0f * x, height - y - buttonHeight - 2.0f * PADDING);
        this.btnRandom.setBounds(x, y += this.lstVanguards.getHeight() + PADDING, width, buttonHeight);
    }

    static {
        for (PaperCard c : FModel.getMagicDb().getVariantCards().getAllCards()) {
            if (!c.getRules().getType().isVanguard()) continue;
            allHumanAvatars.add(c);
            if (!c.getRules().getAiHints().getRemRandomDecks()) {
                nonRandomHumanAvatars.add(c);
            }
            if (c.getRules().getAiHints().getRemAIDecks()) continue;
            allAiAvatars.add(c);
            if (c.getRules().getAiHints().getRemRandomDecks()) continue;
            nonRandomAiAvatars.add(c);
        }
    }
}

